/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/*
 * Name          : pips/src/pipsPrintPerformance.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   void pipsPrintPerformance (tid, perform, ntask, njobs)
 *     int tid []     IS   An array with task Id's of the tasks
 *     int perform[]  IS   An array holding the number of jobs accomplished
 *                         per task (so its size is 'ntask')
 *     int ntask      IS   Number of tasks available for parallel
 *                         data processing (spawned by pipsTaskManager)
 *     int njobs      IS   Total number of accomplished jobs.
 *
 * Description   : 
 *
 *   Prints out a table on stderr stating how many jobs have been completed
 *   by which task (task Id's printed).
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

void pipsPrintPerformance (int tid[], int perform[], int ntask, int njobs)

#else

pipsPrintPerformance (tid, perform, ntask, njobs)
    int tid[];
    int perform[];
    int ntask;
    int njobs;

#endif
{
  long i;                       /* Index to tid[] and perform[]             */

  fprintf (stderr, "Performance of the tasks (accomplished jobs)\n");
  for (i = 0; i < ntask; i++)
    fprintf (stderr, "Task No:%8x : %8d jobs.\n",tid[i],perform[i]);
  fprintf (stderr, "Total number of accomplished jobs:%d\n", njobs);
} /* pipsPrintPerformance */


/* end pipsPrintPerformance.c */
