/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/*
 * Name          : pips/src/pipsPrintError.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   pipsPrintError (ncId, result, cause, action)
 *
 *   int  ncId        IS   Id of a netcdf file or -1, if none open
 *   int  result      IS   Pips error code
 *   char *cause      IS   String containing cause of error, e.g. filename
 *   int  action      IS   If PipsExit, descr. is printed and program ended
 * 
 * Description   : 
 *
 *   Prints the errortext associated with the error code 'result' and the
 *   string 'cause' if not NULL. If 'action' is PipsExit, then the program 
 *   description in 'description' is printed as well, ncabort (ncId) and
 *   ncclose (ncId) is called and the program is left with value (-result),
 */

#include "pips.h"   /* PIPS system header file  */

/*
 * String containing the program description.
 */
extern char *programName;
extern char *description[];

/*
 * Prints an error message and usage information
 * and exits the program with '-result'
 */
#ifdef __STDC__

void pipsPrintError (int ncId, int result, char *cause, int action)

#else

pipsPrintError (ncId, result, cause, action)
    int ncId;
    int result;
    char *cause;
    int action;

#endif
{
  int i = 0;

  static char *errorText[] = {
    /*  1 */ "Could not read from file:",
    /*  2 */ "Could not write to file:",
    /*  3 */ "File allready exists:",
    /*  4 */ "No filename for netCDF file found",
    /*  5 */ "Unknown command line option:",
    /*  6 */ "Option expects parameter:",
    /*  7 */ "Not enough options on command line",
    /*  8 */ "Insufficient memory. Requested bytes:",
    /*  9 */ "Image type not recognized in file:",
    /* 10 */ "Invalid variable name specified:",
    /* 11 */ "Incompatible data type in variable:",
    /* 12 */ "In attribute definition:End of file",
    /* 13 */ "In attribute definition:VariableName or ':' expected",
    /* 14 */ "In attribute definition:':' expected",
    /* 15 */ "In attribute definition:Attribute name expected",
    /* 16 */ "In attribute definition:'=' expected",
    /* 17 */ "In attribute definition:Attribute value expected",
    /* 18 */ "In attribute definition:';' expected",
    /* 19 */ "Existing variable is unsuitable for processing results:",
    /* 20 */ "Could not participate in PVM - isn't it running ?",
    /* 21 */ "This parameter is reserved vor internal use:"
  }; /* errorText */

/*
 * Print error message, if 'result' is an error
 */
  if (result > PipsOk) {
    /* errorIndex = (result & 0x1F) - 1; */
    fprintf (stderr, "Error: %s", errorText [result-1]);
    if (cause)
      fprintf (stderr, " %s.", cause);
    fprintf (stderr, "\n");
  } /* end if */

/*
 * Close netcdf file and exit, if 'exit' is PipsExit
 */
  if (action == PipsExit) {
    if (ncId > -1) {
      ncabort (ncId);
      ncclose (ncId);
    } /* end if */
    fprintf (stderr, "\n***** This is %s version %s *****\n",
             programName, PipsVersion);
    fprintf (stderr, "Usage:\n");
/*
 * Print lines of description, until empty string is encountered
 */
    while (description [i][0] != 0)
      fprintf (stderr, "%s\n", description [i++]);
    exit (-result);
  } /* end if */
} /* pipsPrintError */


/* end pipsPrintError.c */
