/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/*
 * Name          : pips/src/pipsHistory.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   void pipsHistory (ncID, value)
 *
 *   int    ncID      IN   ID of netCDF file
 *   char *value      IN   String designating value associated with attribute
 * 
 * Description   : 
 *
 *   Append data manipulation histories to the netcdf file. The 'value' is
 *   appended as character string to the attribute name constructed from
 *   the history prefix and the current time. It is assumed that netCDF is 
 *   already in define mode for this routine to work.
 */

#include "pips.h"   /* PIPS system header file  */
#include "pvm3.h"   /* PVM system header file   */

#ifdef __STDC__

void pipsHistory (int ncID, char *value)

#else

pipsHistory (ncID, value)

int    ncID;
char *value;

#endif

{

 int i, letters;

/*
 * History and associated variables
 */

  char *hist_buffer = NULL;
  char *history = NULL;
  time_t current_time;

/*
 * Create a variable to hold the history prefix and the packed time string
 */
  history = (char *) calloc (strlen (PipsHistPrefix) + 27, sizeof (char));

/*
 * Get the current time and stick it into a C variable.
 */
  time ( &current_time );
  hist_buffer = ctime ( &current_time );

/*
 * Here we get rid of ':'s and ' 's
 * and write the message (eg "Created by uks2hdf" or argv) as the value
 * associated with this attribute
 */
  strcat (history, PipsHistPrefix);
  letters = strlen (history);
  for (i=0; i < strlen (hist_buffer); i++)  
    if (hist_buffer[i] != ' '  && 
        hist_buffer[i] != '\n' &&
        hist_buffer[i] != ':') 
      history [letters++] = hist_buffer [i];
  
/*
 * Make sure the string is not longer than allowed
 */
  if (strlen (value) >= MAX_NC_NAME)
    value [MAX_NC_NAME-1] = 0;

/*
 * Append history attribute.
 */
  ncattput (ncID, NC_GLOBAL, history, NC_CHAR, strlen(value)+1,(void *)value);

  free (history);
} /* end pipsHistory.c */

