/* 
   PXKBitmapImageRep.m

   NSBitmapImageRep for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@colorado.edu>
   Author:  Scott Christley <scottc@net-community.com>
   Date: Feb 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>
#include <stdlib.h>
#include <tiff.h>

#include <Foundation/NSLock.h>
#include <Foundation/NSData.h>

#include <gnustep/xdps/NSDPSContextWindow.h>
#include <SharedX/xrtools.h>

//
// Backend structure for PXKBitmapImageRep
//
typedef struct _PXKBitmapImageRep_struct
{
  BOOL is_cached;
  int cache_num;
  Pixmap xOpaquePixmap;
} PXKBitmapImageRep_struct;

#define PXKCACHE (((PXKBitmapImageRep_struct *)back_end_reserved)->is_cached)
#define PXKNUM (((PXKBitmapImageRep_struct *)back_end_reserved)->cache_num)
#define XPIXMAP (((PXKBitmapImageRep_struct *)back_end_reserved)->xOpaquePixmap)

#define ALPHA_THRESHOLD 158

@implementation NSBitmapImageRep (Backend)

#ifdef HAVE_WRASTER_H
+ (NSArray *) _wrasterFileTypes
{
  int i;
  NSMutableArray *warray;
  char **types = RSupportedFileFormats();
  
  i = 0;
  warray = [NSMutableArray arrayWithCapacity: 4];
  while (types[i] != NULL)
    {
      NSString *type = [NSString stringWithCString: types[i]];
      type = [type lowercaseString];
      if (strcmp(types[i], "TIFF") != 0)
	{
	  [warray addObject: type];
	  if (strcmp(types[i], "JPEG") == 0)
	    [warray addObject: @"jpg"];
	  else if (strcmp(types[i], "PPM") == 0)
	    [warray addObject: @"pgm"];
	}
      i++;
    }
  return warray;
}

- _initFromWrasterFile: (NSString *)filename number: (int)imageNumber
{
  RImage *image;
  RContext *context;

  if (imageNumber > 0)
    {
      /* RLoadImage doesn't handle this very well */
      RELEASE(self);
      return nil;
    }

  NSDebugLLog(@"NSImage", @"Loading %@ using wraster routines", filename);
  context = [(NSDPSContext *)GSCurrentContext() xrContext];
  image = RLoadImage(context, [filename cString], imageNumber);
  if (!image)
    {
      RELEASE(self);
      return nil;
    }
  [self initWithBitmapDataPlanes: &(image->data)
		pixelsWide: image->width
		pixelsHigh: image->height
		bitsPerSample: 8
	        samplesPerPixel: (image->format == RRGBAFormat) ? 4 : 3
		hasAlpha: (image->format == RRGBAFormat) ? YES : NO
		isPlanar: NO
		colorSpaceName: NSDeviceRGBColorSpace
		bytesPerRow: 0
		bitsPerPixel: 0];

  /* Make NSBitmapImageRep own the data */
  imageData = [NSMutableData dataWithBytesNoCopy: image->data
				    length: (bytesPerRow*image->height)];
  RETAIN(imageData);
  free(image);

  return self;
}
#endif /* HAVE_WRASTER_H */

- (Pixmap) xPixmapMask
{
  if (back_end_reserved == NULL)
    {
      back_end_reserved = malloc(sizeof(PXKBitmapImageRep_struct));
      XPIXMAP = 0;
    }

  if (XPIXMAP == None)
    {
      uint32 j, i;
      unsigned char	ialpha;
      unsigned char	*bData = [(NSBitmapImageRep *)self bitmapData];
      NSDPSContext	*ctxt = (NSDPSContext *)GSCurrentContext();
      Display		*xDisplay = [ctxt xDisplay];
      NSWindow		*w = [(NSView*)[NSView focusView] window];
      Drawable          xDrawable;
      int		bitmapSize = (((int)size.width * (int)size.height)/8);
      char		*aData = calloc(1, bitmapSize);
      char		*cData = aData;
      gswindow_device_t *windev;

      if (numColors == 4)
	{
	  for (j = 0; j < bitmapSize; j++)
	    {
	      for (i = 0; i < 8; i++)
		{
		  bData += 3;
		  ialpha = (unsigned short)((char)*bData++);
		  if (ialpha > ALPHA_THRESHOLD)
		    *cData |= (0x01 << i);
		}
	      cData++;
	    }
	}
      else
	{
	  for (j = 0; j < bitmapSize; j++)
	    *cData++ = 0xff;
	}

      windev = [NSDPSContext _windowWithTag: [w windowNumber]];
      xDrawable = (windev->buffer) ? windev->buffer : windev->ident;
      XPIXMAP = XCreatePixmapFromBitmapData(xDisplay,xDrawable,(char *)aData,
	      (int)size.width, (int)size.height, 1L, 0L, 1);
      free(aData);
    }

  return XPIXMAP;
}

@end
