/* Drawing object marker for XGContext

   Copyright (C) 1998 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1998
   
   This file is part of the GNU Objective C User Interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#include "gnustep/xgps/XGDrawObject.h"

@implementation XGDrawObject

- initWithDrawType: (ctxt_object_t)theType
{
  [super init];
  type = theType;
  return self;
}

- initWithDrawType: (ctxt_object_t)theType point: (NSPoint)thePoint
{
  [super init];
  type = theType;
  point = thePoint;
  return self;
}

- (ctxt_object_t)drawType
{ 
  return type;
}

- (NSPoint) drawPoint
{
  return point;
}

@end

