/* -*- C++ -*-
   XGStreamContext - Drawing context using the XR Library.

   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@boulder.colorado.edu>
   Date: Nov 1995
   
   This file is part of the GNU Objective C User Interface Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#include "gnustep/xgps/XGStreamContext.h"
#include "gnustep/xgps/XGGState.h"
#include "gnustep/xgps/XGContextPrivate.h"
#include "wraster/xrtools.h"
#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSData.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSString.h>
#include <Foundation/NSUserDefaults.h>
#include "string.h"


@implementation XGStreamContext 

+ (Display*) currentXDisplay
{
  return [(XGStreamContext*)[self currentContext] xDisplay];
}

- initWithContextInfo: (NSDictionary *)info
{
  alloc_mode = alloc_local;
  /* Initialize lists and stacks */
  opstack = [[NSMutableArray allocWithZone: [self zone]] initWithCapacity: 2];
  gstack = [[NSMutableArray allocWithZone: [self zone]] initWithCapacity: 2];
  glist  = [[NSMutableArray allocWithZone: [self zone]] initWithCapacity: 32];
  
  /* gstate index of 0 indicates no gstate, thus we put a dummy object at 0.
     Then create a default gstate */
  [glist addObject: [CTXT_OBJ_ALLOC(NSObject) init]];
  //gstate = [CTXT_OBJ_ALLOC(XGGState) initWithDrawContext: self];
  //[glist addObject: gstate];

  context->dpy = 0;

  if (info && [info objectForKey: @"NSOutputFile"])
    {
      NSString *path = [info objectForKey: @"NSOutputFile"];
      gstream = fopen([path fileSystemRepresentation], "w");
      if (!gstream)
        {
          DPS_ERROR (DPSinvalidfileaccess, @"Could not open printer file %@",
	  	path);
	  return nil;
	}
    }
  else
    {
      DPS_ERROR (DPSconfigurationerror, @"No stream file specified");
      return nil;
    }

  [super initWithContextInfo: info];
  return self;
}

- (BOOL)isDrawingToScreen
{
  return NO;
}

- (void) dealloc
{
  fclose(gstream);
  [opstack release];
  [gstack release];
  [glist release];
  [super dealloc];
}

- (RContext *) xrContext
{
  return context;
}

- (XGGState *) xrCurrentGState
{
  return gstate;
}

- (XGGState *) xrGStateWithIdent: (int)gst
{
  return [glist objectAtIndex:gst];
}

- (Region)viewclipRegion
{
  return context->viewclip;
}

- (void) setViewclipRegion: (Region)region;
{
}

/* Override superclass methods */
- (Display *) xDisplay
{
  return context->dpy;
}

- (void) setXDisplay: (Display *)xdisplay
{
}

- (Window) xDisplayRootWindow
{
  return 0;
}

- (Window) xAppRootWindow
{
  return 0;
}

@end

@implementation XGStreamContext (Ops)

/* ----------------------------------------------------------------------- */
/* Color operations */
/* ----------------------------------------------------------------------- */
- (void)DPScurrentcmykcolor: (float *) c : (float *) m : (float *) y : (float *) k 
{
}

- (void)DPSsetcmykcolor: (float)c : (float)m : (float)y : (float)k 
{
  fprintf(gstream, "%f %f %f %f setcmykcolor\n", c, m, y, k);
}

/* ----------------------------------------------------------------------- */
/* Data operations */
/* ----------------------------------------------------------------------- */
- (void)DPSclear 
{
  fprintf(gstream, "clear\n");
}

- (void)DPScleartomark 
{
  fprintf(gstream, "cleartomark\n");
}

- (void)DPScopy: (int)n 
{
  fprintf(gstream, "%d copy\n", n);
}

- (void)DPScount: (int *)n 
{
}

- (void)DPScounttomark: (int *)n 
{
}

- (void)DPSdup 
{
  fprintf(gstream, "dup\n");
}

- (void)DPSexch 
{
  fprintf(gstream, "exch\n");
}

- (void)DPSexecstack 
{
  fprintf(gstream, "execstack\n");
}

- (void)DPSget 
{
  fprintf(gstream, "get\n");
}

- (void)DPSindex: (int)i 
{
  fprintf(gstream, "%d index\n", i);
}

- (void)DPSmark 
{
  fprintf(gstream, "mark\n");
}

- (void)DPSmatrix 
{
  fprintf(gstream, "matrix\n");
}

- (void)DPSnull 
{
  fprintf(gstream, "null\n");
}

- (void)DPSpop 
{
  fprintf(gstream, "pop\n");
}

- (void)DPSput 
{
  fprintf(gstream, "put\n");
}

- (void)DPSroll: (int)n : (int)j 
{
  fprintf(gstream, "%d %d roll\n", n, j);
}

/* ----------------------------------------------------------------------- */
/* Font operations */
/* ----------------------------------------------------------------------- */
- (void)DPSFontDirectory
{
  fprintf(gstream, "FontDirectory\n");
}

- (void)DPSISOLatin1Encoding
{
  fprintf(gstream, "ISOLatin1Encoding\n");
}

- (void)DPSSharedFontDirectory
{
  fprintf(gstream, "SharedFontDirectory\n");
}

- (void)DPSStandardEncoding
{
  fprintf(gstream, "StandardEncoding\n");
}

- (void)DPScachestatus: (int *) bsize : (int *) bmax : (int *) msize 
{
}

- (void)DPScurrentcacheparams
{
  fprintf(gstream, "currentcacheparams\n");
}

- (void)DPScurrentfont
{
  fprintf(gstream, "currentfont\n");
}

- (void)DPSdefinefont
{
  fprintf(gstream, "definefont\n");
}

- (void)DPSfindfont: (const char *) name 
{
  fprintf(gstream, "%s findfont", name);
}

- (void)DPSmakefont
{
  fprintf(gstream, "makefont\n");
}

- (void)DPSscalefont: (float)size 
{
  fprintf(gstream, "%f scalefont\n", size);
}

- (void)DPSselectfont: (const char *)name : (float)scale 
{
  fprintf(gstream, "%s %f selectfont\n", name, scale);
}

- (void)DPSsetcachedevice: (float)wx : (float)wy : (float)llx : (float)lly : (float)urx : (float)ury 
{
  fprintf(gstream, "%f %f %f %f %f %f setcachedevice\n", 
	  wx, wy, llx, lly, urx, ury);
}

- (void)DPSsetcachelimit: (float)n 
{
  fprintf(gstream, "%f setcachelimit\n", n);
}

- (void)DPSsetcacheparams
{
  fprintf(gstream, "setcacheparams\n");
}

- (void)DPSsetcharwidth: (float)wx : (float)wy 
{
  fprintf(gstream, "%f %f setcharwidth\n", wx, wy);
}

- (void)DPSsetfont: (int)f 
{
  fprintf(gstream, "%d setfont\n", f);
}

- (void)DPSundefinefont: (const char *) name 
{
  fprintf(gstream, "%s undefinefont\n", name);
}

/* ----------------------------------------------------------------------- */
/* Gstate operations */
/* ----------------------------------------------------------------------- */
- (void)DPSconcat: (const float *)m 
{
  fprintf(gstream, "[%f %f %f %f %f %f] concat\n", 
	  m[0], m[1], m[2], m[3], m[4], m[5]);
}

- (void)DPScurrentdash
{
  fprintf(gstream, "currentdash\n");
}

- (void)DPScurrentflat: (float *) flatness 
{
}

- (void)DPScurrentgray: (float *) gray 
{
}

- (void)DPScurrentgstate: (int)gst 
{
}

- (void)DPScurrenthalftone
{
}

- (void)DPScurrenthalftonephase: (float *) x : (float *) y 
{
}

- (void)DPScurrenthsbcolor: (float *) h : (float *) s : (float *) b 
{
}

- (void)DPScurrentlinecap: (int *) linecap 
{
}

- (void)DPScurrentlinejoin: (int *) linejoin 
{
}

- (void)DPScurrentlinewidth: (float *) width 
{
}

- (void)DPScurrentmatrix
{
}

- (void)DPScurrentmiterlimit: (float *) limit 
{
}

- (void)DPScurrentpoint: (float *) x : (float *) y 
{
}

- (void)DPScurrentrgbcolor: (float *) r : (float *) g : (float *) b 
{
}

- (void)DPScurrentscreen
{
}

- (void)DPScurrentstrokeadjust: (int *) b 
{
}

- (void)DPScurrenttransfer
{
}

- (void)DPSdefaultmatrix
{
  fprintf(gstream, "defaultmatrix\n");
}

- (void)DPSgrestore
{
  fprintf(gstream, "grestore\n");
}

- (void)DPSgrestoreall
{
  fprintf(gstream, "grestoreall\n");
}

- (void)DPSgsave
{
  fprintf(gstream, "gsave\n");
}

- (void)DPSgstate
{
  fprintf(gstream, "gstate\n");
}

- (void)DPSinitgraphics
{
  fprintf(gstream, "initgraphics\n");
}

- (void)DPSinitmatrix
{
  fprintf(gstream, "initmatrix\n");
}

- (void)DPSrotate: (float)angle 
{
  fprintf(gstream, "%f rotate\n", angle);
}

- (void)DPSscale: (float)x : (float)y 
{
  fprintf(gstream, "%f %f scale\n", x, y);
}

- (void)DPSsetdash: (const float *)pat : (int)size : (float)offset 
{
  int i;
  fprintf(gstream, "[");
  for (i = 0; i < size; i++)
    fprintf(gstream, "%f ", pat[i]);
  fprintf(gstream, "] %d %f setdash\n", size, offset);
}

- (void)DPSsetflat: (float)flatness 
{
  fprintf(gstream, "%f setflat\n", flatness);
}

- (void)DPSsetgray: (float)gray 
{
  fprintf(gstream, "%f setgray\n", gray);
}

- (void)DPSsetgstate: (int)gst 
{
  fprintf(gstream, "%d setgstate\n", gst);
}

- (void)DPSsethalftone
{
  fprintf(gstream, "sethalftone\n");
}

- (void)DPSsethalftonephase: (float)x : (float)y 
{
  fprintf(gstream, "%f %f sethalftonephase\n", x, y);
}

- (void)DPSsethsbcolor: (float)h : (float)s : (float)b 
{
  fprintf(gstream, "%f %f %f sethsbcolor\n", h, s, b);
}

- (void)DPSsetlinecap: (int)linecap 
{
  fprintf(gstream, "%d setlinecap\n", linecap);
}

- (void)DPSsetlinejoin: (int)linejoin 
{
  fprintf(gstream, "%d setlinejoin\n", linejoin);
}

- (void)DPSsetlinewidth: (float)width 
{
  fprintf(gstream, "%f setlinewidth\n", width);
}

- (void)DPSsetmatrix
{
  fprintf(gstream, "setmatrix\n");
}

- (void)DPSsetmiterlimit: (float)limit 
{
  fprintf(gstream, "%f setmiterlimit\n", limit);
}

- (void)DPSsetrgbcolor: (float)r : (float)g : (float)b 
{
  fprintf(gstream, "%f %f %f setrgbcolor\n", r, g, b);
}

- (void)DPSsetscreen
{
  fprintf(gstream, "setscreen\n");
}

- (void)DPSsetstrokeadjust: (int)b 
{
  fprintf(gstream, "%d setstrokeadjust\n", b);
}

- (void)DPSsettransfer
{
  fprintf(gstream, "settransfer\n");
}

- (void)DPStranslate: (float)x : (float)y 
{
  fprintf(gstream, "%f %f translate\n", x, y);
}

/* ----------------------------------------------------------------------- */
/* Matrix operations */
/* ----------------------------------------------------------------------- */
- (void)DPSconcatmatrix
{
  fprintf(gstream, "concatmatrix\n");
}

- (void)DPSdtransform: (float)x1 : (float)y1 : (float *) x2 : (float *) y2 
{
}

- (void)DPSidentmatrix
{
  fprintf(gstream, "identmatrix\n");
}

- (void)DPSidtransform: (float)x1 : (float)y1 : (float *) x2 : (float *) y2 
{
}

- (void)DPSinvertmatrix
{
  fprintf(gstream, "invertmatrix\n");
}

- (void)DPSitransform: (float)x1 : (float)y1 : (float *) x2 : (float *) y2 
{
}

- (void)DPStransform: (float)x1 : (float)y1 : (float *) x2 : (float *) y2 
{
  fprintf(gstream, "%f %f transform\n", x1, y1);
  *x2 = 0;
  *y2 = 0;
}

/* ----------------------------------------------------------------------- */
/* Paint operations */
/* ----------------------------------------------------------------------- */
- (void)DPSashow: (float)x : (float)y : (const char *) s 
{
  fprintf(gstream, "%f %f (%s) ashow\n", x, y, s);
}

- (void)DPSawidthshow: (float)cx : (float)cy : (int)c : (float)ax : (float)ay : (const char *) s 
{
}

- (void)DPScopypage
{
  fprintf(gstream, "copypage\n");
}

- (void)DPSeofill
{
  fprintf(gstream, "eofill\n");
}

- (void)DPSerasepage
{
  fprintf(gstream, "erasepage\n");
}

- (void)DPSfill
{
  fprintf(gstream, "fill\n");
}

- (void)DPSimage
{
  fprintf(gstream, "image\n");
}

- (void)DPSimagemask
{
  fprintf(gstream, "imagemask\n");
}

- (void)DPSkshow: (const char *) s 
{
}

- (void)DPSrectfill: (float)x : (float)y : (float)w : (float)h 
{
  fprintf(gstream, "%f %f %f %f rectfill\n", x, y, w, h);
}

- (void)DPSrectstroke: (float)x : (float)y : (float)w : (float)h 
{
  fprintf(gstream, "%f %f %f %f rectstroke\n", x, y, w, h);
}

- (void)DPSshow: (const char *) s 
{
  fprintf(gstream, "(%s) show\n", s);
}

- (void)DPSshowpage
{
  fprintf(gstream, "showpage\n");
}

- (void)DPSstroke
{
  fprintf(gstream, "stroke\n");
}

- (void)DPSstrokepath
{
  fprintf(gstream, "strokepath\n");
}

- (void)DPSwidthshow: (float)x : (float)y : (int)c : (const char *) s 
{
  fprintf(gstream, "%f %f %d (%s) widthshow\n", x, y, c, s);
}

- (void)DPSxshow: (const char *) s : (const float *)numarray : (int)size 
{
}

- (void)DPSxyshow: (const char *) s : (const float *)numarray : (int)size 
{
}

- (void)DPSyshow: (const char *) s : (const float *)numarray : (int)size 
{
}

/* ----------------------------------------------------------------------- */
/* Path operations */
/* ----------------------------------------------------------------------- */
- (void)DPSarc: (float)x : (float)y : (float)r : (float)angle1 : (float)angle2 
{
  fprintf(gstream, "%f %f %f %f %f arc\n", x, y, r, angle1, angle2);
}

- (void)DPSarcn: (float)x : (float)y : (float)r : (float)angle1 : (float)angle2 
{
  fprintf(gstream, "%f %f %f %f %f arcn\n", x, y, r, angle1, angle2);
}

- (void)DPSarct: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)r 
{
  fprintf(gstream, "%f %f %f %f %f arct\n", x1, y1, x2, y2, r);
}

- (void)DPSarcto: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)r : (float *) xt1 : (float *) yt1 : (float *) xt2 : (float *) yt2 
{
}

- (void)DPScharpath: (const char *) s : (int)b 
{
  fprintf(gstream, "(%s) %d charpath\n", s, b);
}

- (void)DPSclip
{
  fprintf(gstream, "clip\n");
}

- (void)DPSclippath
{
  fprintf(gstream, "clippath\n");
}

- (void)DPSclosepath
{
  fprintf(gstream, "closepath\n");
}

- (void)DPScurveto: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)x3 : (float)y3 
{
  fprintf(gstream, "%f %f %f %f %f %f curveto\n", x1, y1, x2, y2, x3, y3);
}

- (void)DPSeoclip
{
  fprintf(gstream, "eoclip\n");
}

- (void)DPSeoviewclip
{
  fprintf(gstream, "eoviewclip\n");
}

- (void)DPSflattenpath
{
  fprintf(gstream, "flattenpath\n");
}

- (void)DPSinitclip
{
  fprintf(gstream, "initclip\n");
}

- (void)DPSinitviewclip
{
  fprintf(gstream, "initviewclip\n");
}

- (void)DPSlineto: (float)x : (float)y 
{
  fprintf(gstream, "%f %f lineto\n", x, y);
}

- (void)DPSmoveto: (float)x : (float)y 
{
  fprintf(gstream, "%f %f moveto\n", x, y);
}

- (void)DPSnewpath
{
  fprintf(gstream, "newpath\n");
}

- (void)DPSpathbbox: (float *) llx : (float *) lly : (float *) urx : (float *) ury 
{
}

- (void)DPSpathforall
{
  fprintf(gstream, "pathforall\n");
}

- (void)DPSrcurveto: (float)x1 : (float)y1 : (float)x2 : (float)y2 : (float)x3 : (float)y3 
{
  fprintf(gstream, "%f %f %f %f %f %f rcurveto\n", x1, y1, x2, y2, x3, y3);
}

- (void)DPSrectclip: (float)x : (float)y : (float)w : (float)h 
{
  fprintf(gstream, "%f %f %f %f rectclip\n", x, y, w, h);
}

- (void)DPSrectviewclip: (float)x : (float)y : (float)w : (float)h 
{
  fprintf(gstream, "%f %f %f %f rectviewclip\n", x, y, w, h);
}

- (void)DPSreversepath
{
  fprintf(gstream, "reversepath\n");
}

- (void)DPSrlineto: (float)x : (float)y 
{
  fprintf(gstream, "%f %f rlineto\n", x, y);
}

- (void)DPSrmoveto: (float)x : (float)y 
{
  fprintf(gstream, "%f %f rmoveto\n", x, y);
}

- (void)DPSsetbbox: (float)llx : (float)lly : (float)urx : (float)ury 
{
  fprintf(gstream, "%f %f %f %f setbbox\n", llx, lly, urx, ury);
}

- (void)DPSsetucacheparams
{
}

- (void)DPSviewclip
{
}

- (void)DPSviewclippath
{
}

/* ----------------------------------------------------------------------- */
/* X operations */
/* ----------------------------------------------------------------------- */

@end



