/* 
   XGScreen.m

   NSScreen for GNUstep GUI X/GPS Backend

   Copyright (C) 1999 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@gnu.org>
   Date: April 1999
   
   This file is part of the GNUstep GUI X/GPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "config.h"
#include <gnustep/xgps/XGContext.h>

@implementation XGScreen

- (id) initWithDeviceDescription: (NSDictionary *)dict
{
  int screen;
  XGContext	*ctxt = (XGContext*)[XGContext currentContext];
  Display	*xDisplay = [ctxt xDisplay];

  [super initWithDeviceDescription: (NSDictionary *)dict];
  if ([ctxt isDrawingToScreen] == NO)
    {
      NSLog(@"Internal error: trying to find screen with wrong context\n");
      [self dealloc];
      return nil;
    }

  if (!dict || [[dict objectForKey: @"NSScreenKeyName"] isEqual: @"Main"])
    {
      /* Assume the main screen is the one we started with */
      screen = ctxt->context->screen_number;
    }
  else if ([dict objectForKey: @"NSScreenNumber"])
    {
      screen = [[dict objectForKey: @"NSScreenNumber"] intValue];
    }
  frame = NSMakeRect(0, 0,
		     DisplayWidth(xDisplay, screen),
		     DisplayHeight(xDisplay, screen));
  depth = DefaultDepthOfScreen(ScreenOfDisplay(xDisplay, screen));
  be_screen_reserved = (void *)screen;
  return self;
}

- (int) xScreen
{
  return (int)be_screen_reserved;
}

- (Class) classForCoder: (NSCoder*)aCoder
{
  if ([self class] == [XGScreen class])
    return [super class];
  return [self class];
}

@end
