/*
   XGFontManager.m

   NSFontManager for GNUstep GUI X/GPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: February 1997
   A completely rewritten version of the original source of Scott Christley.
   
   This file is part of the GNUstep GUI X/GPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <config.h>
#include <stdio.h>

#include <gnustep/xgps/XGContext.h>
#include <Foundation/NSDebug.h>

@interface XGFontManager : NSFontManager
{
}
@end

// Several strings needed for the manipulation of our font list files.
static NSString *GSLibDirPath = @GNUSTEP_INSTALL_LIBDIR;
static NSString *GSUserXFontListLocation = @"GNUstep/.GNUstepXFontList";  
static NSString *GSSystemXFontListLocation =  @"Resources/GNUstepSystemXFontList";

@implementation XGFontManager

+ (void)initialize
{
	if (self == [XGFontManager class])
		{
		NSDebugLog(@"Initialize XGFontManager class\n");
		[self setVersion:1];
														// Set the factories
		[self setFontManagerFactory:[XGFontManager class]];
		[self setFontPanelFactory:[NSFontPanel class]];
		}
}

@end

@implementation XGFontManager (GNUstepBackend)

- (void)enumerateFontsAndFamilies
{
  BOOL fileExists;
  NSMutableDictionary *xfontDict = [NSMutableDictionary new];

  fileExists  = [[NSFileManager defaultManager] fileExistsAtPath:[NSString
                        stringWithFormat:@"%@/%@",
                        GSLibDirPath,
                        GSSystemXFontListLocation]];

  if (!fileExists) {

    // The main system dictionary is missing. This is bad.

    NSLog(@"System X font dictionary is corrupt or missing, unless you
            have fonts defined in your user X font dictionary, GNUstep
            will use 9x15 for all fonts.");

  } else {

    // Goody, the dictionary is available for use. In the first step of
    // constructing the eventual fontdictionary we load all definitions
    // the system has.

    [xfontDict addEntriesFromDictionary:[NSMutableDictionary
    dictionaryWithContentsOfFile:[NSString stringWithFormat:@"%@/%@",
    GSLibDirPath, GSSystemXFontListLocation]]];
  }

  // Now in the second phase we attempt to load the individual users X
  // font dictionary and supplement the system dictionary or overwrite
  // duplicate entries in favor of user defines.

  fileExists  = [[NSFileManager defaultManager] fileExistsAtPath:[NSString
                        stringWithFormat:@"%@/%@",
                        NSHomeDirectoryForUser(NSUserName()),
                        GSUserXFontListLocation]];

  if (fileExists) {

    // Force the system dictionary to accept user entries and in the
    // process overwrite any older entries.

    [xfontDict addEntriesFromDictionary:[NSMutableDictionary
    dictionaryWithContentsOfFile:[NSString stringWithFormat:@"%@/%@",
    NSHomeDirectoryForUser(NSUserName()), GSUserXFontListLocation]]];
  }
    
  // Now if our fontdictionary has more entries than 0 we will proceed to
  // educate XGFont to which fonts the system knows about.

  if ([xfontDict count] > 0)
    [XGFont makeKnownFonts:xfontDict];

}

- (Class) classForCoder: (NSCoder*)aCoder
{
  if ([self class] == [XGFontManager class])
    return [super class];
  return [self class];
}

@end
