/* drawing context using the Xlib library.

   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1998
   
   This file is part of the GNU Objective C User Interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

/* This is a reasonable attempt at mapping PostScript operators to an
   Xlib library implementation. Don't even begin to think that this
   is a full PostScript implementation, however. Many, many operators are
   not implemented or do not work as expected. Before using an operator,
   check to make sure it is implemented, otherwise the opstack may 
   be screwed up and nothing else will work!. No errors are returned
   for non-implmeneted operators.
*/

#ifndef _XGContext_h_INCLUDE
#define _XGContext_h_INCLUDE

#include <Foundation/NSArray.h>
#include <Foundation/NSGeometry.h>
#include <AppKit/AppKit.h>

#include <wraster/wraster.h>
#include <wraster/xdnd.h>
#include <X11/Xatom.h>
#include <X11/extensions/shape.h>

/* HACKS
 *
 * For the time being, we still need to have several backend classes use the
 * poseAs: mechanism.
 * For tidyness, we declare the class interfaces here rather than in separate
 * header files.
 * As the backend classes are removed, their interfaces will be removed too.
 */

@interface XGColor : NSColor
{
}
- (XColor)xColor;
- (void)setXColor:(XColor)xcolor;
@end

@interface XGCursor : NSCursor
{
}

- (void)setXCursor:(Cursor)cursor;
- (Cursor)xCursor;
- (BOOL)xCursorIsValid;

@end

@interface XGScreen : NSScreen
{
}
- (int)xScreen;
@end

@interface	XGWindow : NSWindow
{
}
+ (XGWindow*)_windowForXWindow:(Window)xWindow;
+ (NSWindow*)_windowWithTag:(int)windowNumber;

- (void)setContentViewSize:(NSSize)aSize;

- (NSRect)xFrame;
- (Window)xWindow;
- (GC)xGC;
- (void)xSetFrameFromXFrame:(NSRect)rect;
- (void)_setVisible:(BOOL)flag;
- (void)_updateWindowGeometry;
- (Drawable)xDrawable;
- (void)_createBackingStore;

//
// Dealing with expose events
//
- (void)_addExposedRectangle:(XRectangle)rectangle;
- (void)_processExposedRectangles;

@end


@interface XGBitmapImageRep : NSBitmapImageRep
{
}

- (RXImage *)xImage;
- (Pixmap) xPixmapMask;

@end

@interface	XGDragView : NSView <NSDraggingInfo>
{
  
  NSCell         *dragCell;
  NSPasteboard   *dragPasteboard;
  NSPoint         dragPoint;
  int             dragSequence;
  id              dragSource;
  NSDragOperation dragMask;
  id              dragWindow;
  Atom           *typelist;

  BOOL            dragLocal;
}

+ (XGDragView*) sharedDragView;

- (void) setDragInfoFromEvent: (NSEvent *)event;
@end

/*
 *	Declare all the backend classes here.
 */

@class  XGApplication;
@class  XGBitmapImageRep;
@class  XGCachedImageRep;
@class  XGColor;
@class  XGFont;
@class  XGFontManager;
@class  XGImage;
@class  XGMenuWindow;

@class XGGState;

/*
 * Enumerated type to say how we should draw pixels to the X display - used
 * to select different drawing mechanisms to try to optimise.
 */
typedef enum {
  XGDM_FAST16,
  XGDM_FAST32,
  XGDM_PORTABLE
} XGDrawMechanism;

typedef enum {
  alloc_local, alloc_global
} alloc_mode_t;

@interface XGContext : NSGraphicsContext
{
@public
  Window		xAppRootWindow;
  Window		xDisplayRootWindow;

  void			*opstack;
  void			*gstack;
  XGGState		*gstate;
  NSMutableArray	*ulist;
  NSMutableArray	*fontid;

  RContext		*context;
  Window		appRootWindow;
  Window		grabWindow;
  XGWindow		*iconWindow;
  alloc_mode_t		alloc_mode;
  NSMutableArray	*windowList;
  XGDrawMechanism	drawMechanism;
  unsigned		lastKeyFlags;
}

+ (Display*) currentXDisplay;
- (XGDrawMechanism) drawMechanism;
- (Display*)xDisplay;
- (void)setXDisplay:(Display *)xdisplay;
- (Window)xDisplayRootWindow;
- (Window)xAppRootWindow;

- (RContext *) xrContext;
- (XGGState *) xrCurrentGState;
- (XGGState *) xrGStateWithIdent: (int)gst;

@end

#endif /* _XGContext_h_INCLUDE */
