/* 
   PXKWindow.h

   NSWindow for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Author:  Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: August 1995
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_PXKWindow
#define _GNUstep_H_PXKWindow

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <AppKit/NSWindow.h>

@class NSMutableArray;

//
// Methods for XWindows implementation
//
@interface PXKWindow : NSWindow
{
}

+ (PXKWindow*)windowForXWindow:(Window)xWindow;
+ (int)numberForXWindow:(Window)xWindow;
+ (NSWindow*)windowWithNumber:(int)windowNumber;

- (void)setContentViewSize:(NSSize)aSize;

- (void)createXWindow:(NSRect)rect;
- (Window)xWindow;
- (GC)xGC;
- (void)setXExposed:(BOOL)flag;
- (BOOL)isXExposed;
- (void)setFrameFromXFrame:(NSRect)rect;
- (void)setXUnmap:(BOOL)flag;

- (void)_updateWindowGeometry;
- (Drawable)drawable;

- (void)createBackingStore;

/* Dealing with expose events */
- (void)addExposedRectangle:(XRectangle)rectangle;
- (void)processExposedRectangles;

- (NSRect)xFrame;

+ (BOOL)_needsFlushWindows;
+ (void)_setNeedsFlushWindows:(BOOL)flag;
+ (BOOL)_flushWindows;
- (BOOL)_needsFlush;
- (void)_setNeedsDisplay;
- (void)_setNeedsFlush;
- (void)_view:(NSView*)view needsFlushInRect:(NSRect)rect;			

//
// Private methods
//
- (void)_collectFlushRectangles;

@end

//
// Backend structure for PXKWindow
//
typedef struct _PXKWindow_struct
{
  Window xWindow;
  GC context;
  BOOL is_exposed;
  NSMutableArray* exposedRectangles;
  Drawable xPixmap;	// This is the pixmap used as backing store
  unsigned int x, y;	// The actual coordinates of xWindow (device space)
  unsigned int width, height;	// The actual size of xWindow (device space)
  int depth;		// Depth of xWindow
  Region region;	// Temporary region used between several expose events
} PXKWindow_struct;

#endif /* _GNUstep_H_PXKWindow */
