/*
   nsbrowsercell.m
   
   Copyright (C) 1996 Free Software Foundation, Inc.
   
   Author: Scott Christley <scottc@net-community.com>
   Date: October 1997
   
   This file is part of the GNUstep GUI X/DPS Library.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/AppKit.h>

@interface MyObject : NSObject
{
  NSMatrix* matrix;
}
@end

@implementation MyObject
- (void)setMatrix:(NSMatrix*)anObject
{
  matrix = anObject;
}

- (void)setMatrixMode:sender
{
  [matrix setMode:[[sender selectedCell] tag]];
}

- (void)setSelectionByRect:sender
{
  [matrix setSelectionByRect:[sender state]];
}
@end

int
main(int argc, char **argv, char** env)
{
  NSApplication *theApp;
  NSWindow *window;
  NSRect winRect = {{100, 100}, {600, 600}};
  NSRect scrollViewRect = {{20, 115}, {150, 335}};
  NSRect matrixRect = {{0, 0}, {100, 550}};
  id pool = [NSAutoreleasePool new];
  NSMatrix* matrix;
  NSBrowserCell* browserCell;
  NSScrollView* scrollView;
  MyObject* handler = [[MyObject new] autorelease];
  NSSize cs, ms;
  NSRect mr;

#if LIB_FOUNDATION_LIBRARY
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

#ifndef NX_CURRENT_COMPILER_RELEASE
  initialize_gnustep_backend();
#endif

  theApp = [NSApplication sharedApplication];

#if 1
  window = [[NSWindow alloc]
	      initWithContentRect:winRect
	      styleMask:NSTitledWindowMask
	      backing:NSBackingStoreNonretained
	      defer:NO];
#else
  window = [[NSWindow alloc] init];
#endif

  browserCell = [[NSBrowserCell new] autorelease];

  matrix = [[[NSMatrix alloc]
		initWithFrame:matrixRect
		mode:NSListModeMatrix
		prototype:browserCell
		numberOfRows:10
		numberOfColumns:1]
	      autorelease];
  [matrix sizeToCells];
  // [[window contentView] addSubview:matrix];
//  [matrix _test];

  scrollView = [[NSScrollView alloc] initWithFrame:scrollViewRect];
  [scrollView setHasHorizontalScroller:NO];
  [scrollView setHasVerticalScroller:YES];

  cs = [scrollView contentSize];
  ms = [matrix cellSize];
  ms.width = cs.width;
  [matrix setCellSize: ms];
  mr = [matrix frame];

  // Adjust because NSMatrix has incorrect origin
  if (mr.size.height < cs.height)
    {
      mr.origin.y = cs.height - mr.size.height;
      [matrix setFrame: mr];
    }

  [scrollView setDocumentView:matrix];

  [[window contentView] addSubview:scrollView];

  [window setTitle:@"NSMatrix with NSBrowserCells"];
  [window setFrame:winRect display:YES];
  [window orderFront:nil];

  [theApp run];
  [pool release];
  return 0;
}
