/* 
   Functions.m

   Generic Functions for the GNUstep GUI X/DPS Library.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Author:  Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: September 1996
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#include <DPS/psops.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSCStringText.h>
#include <AppKit/NSEvent.h>
#include <gnustep/xdps/PXKDPSContext.h>
#include "drawingfuncs.h"

//
// Rectangle Drawing Functions
//
//
// Optimize Drawing
//
void NSEraseRect(NSRect aRect)
{
  PSgsave();
  PSsetgray(1);
  PSrectfill(aRect.origin.x, aRect.origin.y, 
	     aRect.size.width, aRect.size.height);
  PSgrestore();
}

void NSHighlightRect(NSRect aRect)
{}

void NSRectClip(NSRect aRect)
{}

void NSRectClipList(const NSRect *rects, int count)
{}

void NSRectFill(NSRect aRect)
{
  PSrectfill(aRect.origin.x, aRect.origin.y, 
	     aRect.size.width, aRect.size.height);
}

void NSRectFillList(const NSRect *rects, int count)
{
  int i;

  for (i = 0;i < count; ++i)
    PSrectfill(rects[i].origin.x, rects[i].origin.y, 
	       rects[i].size.width, rects[i].size.height);
}

void NSRectFillListWithGrays(const NSRect *rects, 
			     const float *grays, int count)
{
  int i;

  for (i = 0;i < count; ++i)
    {
      PSsetgray(grays[i]);
      PSrectfill(rects[i].origin.x, rects[i].origin.y, 
		 rects[i].size.width, rects[i].size.height);
    }
}

//
// Draw a Bordered Rectangle
//
void NSDrawButton(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawButton (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height);
}

void NSDrawGrayBezel(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawGrayBezel (rect.origin.x, rect.origin.y,
		     rect.size.width, rect.size.height);
}

void NSDrawGroove(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawGroove (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height);
}

void NSDrawWhiteBezel(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawWhiteBezel (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
}

void NSDrawBezel(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawBezel (rect.origin.x, rect.origin.y,
		  rect.size.width, rect.size.height);
}

void GSDrawPressedPushButton(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawPressedPushButton (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
}

void GSDrawPressedToggleButton(NSRect rect, NSRect clipRect)
{
    PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    PSWDrawPressedToggleButton (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
}

void NSFrameRect(NSRect rect)
{
    PSWFrameRect (rect.origin.x, rect.origin.y,
		  rect.size.width, rect.size.height);
}

void NSFrameRectWithWidth(NSRect rect, float frameWidth)
{
    PSWFrameRectWithWidth (rect.origin.x, rect.origin.y,
			   rect.size.width, rect.size.height, frameWidth);
}

NSRect NSDrawTiledRects(NSRect boundsRect, NSRect clipRect, 
			const NSRectEdge *sides, const float *grays, 
			int count)
{
	return NSZeroRect;
}

//
// Color Functions
//
//
// Get Information About Color Space and Window Depth
//
const NSWindowDepth *NSAvailableWindowDepths(void)
{
	return NULL;
}

NSWindowDepth NSBestDepth(NSString *colorSpace, 
			  int bitsPerSample, int bitsPerPixel, 
			  BOOL planar, BOOL *exactMatch)
{
	return 0;
}

int NSBitsPerPixelFromDepth(NSWindowDepth depth)
{
	return 0;
}

int NSBitsPerSampleFromDepth(NSWindowDepth depth)
{
	return 0;
}

NSString *NSColorSpaceFromDepth(NSWindowDepth depth)
{
	return nil;
}

int NSNumberOfColorComponents(NSString *colorSpaceName)
{
	return 0;
}

BOOL NSPlanarFromDepth(NSWindowDepth depth)
{
	return NO;
}

//
// Read the Color at a Screen Position
//
NSColor *NSReadPixel(NSPoint location)
{
	return nil;
}

//
// Text Functions
//
//
// Filter Characters Entered into a Text Object
//
unsigned short NSEditorFilter(unsigned short theChar, 
			      int flags, NSStringEncoding theEncoding)
{
	return 0;
}

unsigned short NSFieldFilter(unsigned short theChar, 
			     int flags, NSStringEncoding theEncoding)
{
	return 0;
}

//
// Calculate or Draw a Line of Text (in Text Object)
//
int NSDrawALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

int NSScanALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

//
// Calculate Font Ascender, Descender, and Line Height (in Text Object)
//
void NSTextFontInfo(id fid, 
		    float *ascender, float *descender, 
		    float *lineHeight)
{}

//
// Access Text Object's Word Tables
//
NSData * NSDataWithWordTable(const unsigned char *smartLeft,
			     const unsigned char *smartRight,
			     const unsigned char *charClasses,
			     const NSFSM *wrapBreaks,
			     int wrapBreaksCount,
			     const NSFSM *clickBreaks, 
			     int clickBreaksCount, 
			     BOOL charWrap)
{
	return nil;
}

void NSReadWordTable(NSZone *zone,
		     NSData *data,
		     unsigned char **smartLeft,
		     unsigned char **smartRight,
		     unsigned char **charClasses,
		     NSFSM **wrapBreaks,
		     int *wrapBreaksCount,
		     NSFSM **clickBreaks,
		     int *clickBreaksCount, 
		     BOOL *charWrap)
{}

//
// Array Allocation Functions for Use by the NSText Class
//
NSTextChunk *NSChunkCopy(NSTextChunk *pc, NSTextChunk *dpc)
{
	return NULL;
}

NSTextChunk *NSChunkGrow(NSTextChunk *pc, int newUsed)
{
	return NULL;
}

NSTextChunk *NSChunkMalloc(int growBy, int initUsed)
{
	return NULL;
}

NSTextChunk *NSChunkRealloc(NSTextChunk *pc)
{
	return NULL;
}

NSTextChunk *NSChunkZoneCopy(NSTextChunk *pc, 
                             NSTextChunk *dpc,
                             NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneGrow(NSTextChunk *pc, int newUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneMalloc(int growBy, int initUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneRealloc(NSTextChunk *pc, NSZone *zone)
{
	return NULL;
}


//
// Imaging Functions
//
//
// Copy an image
//
void NSCopyBitmapFromGState(int srcGstate, NSRect srcRect, NSRect destRect)
{}

void NSCopyBits(int srcGstate, NSRect srcRect, NSPoint destPoint)
{}

//
// Render Bitmap Images
//
void NSDrawBitmap(NSRect rect,
                  int pixelsWide,
                  int pixelsHigh,
                  int bitsPerSample,
                  int samplesPerPixel,
                  int bitsPerPixel,
                  int bytesPerRow, 
                  BOOL isPlanar,
                  BOOL hasAlpha, 
                  NSString *colorSpaceName, 
                  const unsigned char *const data[5])
{}

//
// Attention Panel Functions
//
//
// Create an Attention Panel without Running It Yet
//
id NSGetAlertPanel(NSString *title,
                   NSString *msg,
                   NSString *defaultButton,
                   NSString *alternateButton, 
                   NSString *otherButton, ...)
{
	return nil;
}

//
// Create and Run an Attention Panel
//
int NSRunAlertPanel(NSString *title,
                    NSString *msg,
                    NSString *defaultButton,
                    NSString *alternateButton,
                    NSString *otherButton, ...)
{
	return 0;
}

int NSRunLocalizedAlertPanel(NSString *table,
                             NSString *title,
                             NSString *msg,
                             NSString *defaultButton, 
                             NSString *alternateButton, 
                             NSString *otherButton, ...)
{
	return 0;
}

//
// Release an Attention Panel
//
void NSReleaseAlertPanel(id panel)
{}

//
// Services Menu Functions
//
//
// Determine Whether an Item Is Included in Services Menus
//
int NSSetShowsServicesMenuItem(NSString *item, BOOL showService)
{
	return 0;
}

BOOL NSShowsServicesMenuItem(NSString *item)
{
	return NO;
}

//
// Programmatically Invoke a Service
//
BOOL NSPerformService(NSString *item, NSPasteboard *pboard)
{
	return NO;
}

//
// Force Services Menu to Update Based on New Services
//
void NSUpdateDynamicServices(void)
{}

//
// Other Application Kit Functions
//

//
// Play the System Beep
//
void NSBeep(void)
{
  Display *xDisplay = [(PXKDPSContext *)[NSDPSContext currentContext]
					xDisplay];

  XBell(xDisplay, 50);
}

//
// Draw a Distinctive Outline around Linked Data
//
void NSFrameLinkRect(NSRect aRect, BOOL isDestination)
{}

float NSLinkFrameThickness(void)
{
	return 0;
}

//
// Convert an Event Mask Type to a Mask
//
unsigned int NSEventMaskFromType(NSEventType type)
{
	return 0;
}
