/* Tests the compiled C-library, libgnussl.h.  Since all the functions in
the library are simply fronts for the C++ functions, only one function is 
tested. */

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This software is free; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<stdio.h>
#include<stdlib.h>
#include<c_gnussl.h>

int main() {
  int dim=5,r,c;
  struct c_complex_matrix a,i;
  struct c_complex_matrix b,d;
  struct c_complex p1[dim*dim],p2[dim*dim],p3[dim*dim],p4[dim*dim];
  double maxr;
  for(r=0;r<dim*dim;r++) { p1[r].re=0.0; p1[r].im=0.0; }
  for(r=0;r<dim*dim;r++) { p2[r].re=0.0; p2[r].im=0.0; }
  for(r=0;r<dim*dim;r++) { p3[r].re=0.0; p3[r].im=0.0; }
  for(r=0;r<dim*dim;r++) { p4[r].re=0.0; p4[r].im=0.0; }

  maxr=(double)0x0fffffff;
  a.r_=a.c_=dim;
  a.data_=p1;
  b.r_=b.c_=dim;
  b.data_=p2;
  d.r_=d.c_=dim;
  d.data_=p3;
  i.r_=i.c_=dim;
  i.data_=p4;

  rand(1);
  for(r=1;r<=dim;r++) {
    for(c=1;c<=dim;c++) {
      a.data_[(r-1)*a.c_+c-1].re=rand()/maxr;
      a.data_[(r-1)*a.c_+c-1].im=rand()/maxr;
      b.data_[(r-1)*a.c_+c-1].re=a.data_[(r-1)*a.c_+c-1].re;
      b.data_[(r-1)*a.c_+c-1].im=a.data_[(r-1)*a.c_+c-1].im;
      i.data_[(r-1)*a.c_+c-1].re=0.0;
      i.data_[(r-1)*a.c_+c-1].im=0.0;
      d.data_[(r-1)*a.c_+c-1].re=0.0;
      d.data_[(r-1)*a.c_+c-1].im=0.0;
    }
    i.data_[(r-1)*a.c_+r-1].re=1.0;
    d.data_[(r-1)*a.c_+r-1].re=1.0;
  }
  complex_gauss_jordan(b,d,0.0,1,1,1);
  printf("\n\nCheck the deviation from the identity\n");
  for(r=1;r<=dim;r++) {    
    for(c=1;c<=dim;c++) 
      printf("(%e,%e)\t",i.data_[(r-1)*a.c_+c-1].re-b.data_[(r-1)*a.c_+c-1].re,
i.data_[(r-1)*a.c_+c-1].im-b.data_[(r-1)*a.c_+c-1].im);
    printf("\n");
  }
  printf("\n\nCheck the deviation from the inverse\n");
  complex_mdotm(d,a,b);
  for(r=1;r<=dim;r++) {    
    for(c=1;c<=dim;c++) 
      printf("(%e,%e)\t",i.data_[(r-1)*a.c_+c-1].re-b.data_[(r-1)*a.c_+c-1].re,
i.data_[(r-1)*a.c_+c-1].im-b.data_[(r-1)*a.c_+c-1].im);
    printf("\n");
    printf("\n");
  }
  return 0;
}
