;;; /***************************************************************************
;;; *
;;; *
;;; * Copyright (C) 2016, 2017 ng0 <ng0@infotropique.org>.
;;; *
;;; * This file is an appendum to gnurl.
;;; *
;;; * This software is licensed as described in the file COPYING, which
;;; * you should have received as part of this distribution. The terms
;;; * are also available at https://curl.haxx.se/docs/copyright.html.
;;; *
;;; * You may opt to use, copy, modify, merge, publish, distribute and/or sell
;;; * copies of the Software, and permit persons to whom the Software is
;;; * furnished to do so, under the terms of the COPYING file.
;;; *
;;; * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
;;; * KIND, either express or implied.
;;; *
;;; ***************************************************************************/


(use-modules
 (ice-9 popen)
 (ice-9 match)
 (ice-9 rdelim)
 (guix packages)
 (guix build-system gnu)
 (guix gexp)
 ((guix build utils) #:select (with-directory-excursion))
 (gnu packages)
 (gnu packages base)
 (gnu packages autotools)
 (gnu packages gnunet))

(define %source-dir (dirname (current-filename)))

(define-public gnurl-git
  (package
    (inherit gnurl)
    (name "gnurl-git")
    (version (string-append "7.55.1-" "dev"))
    (source
     (local-file %source-dir
                 #:recursive? #t))))

gnurl-git
