#!/usr/bin/env perl
#***************************************************************************
#                                  _   _ ____  _
#  Project                     ___| | | |  _ \| |
#                             / __| | | | |_) | |
#                            | (__| |_| |  _ <| |___
#                             \___|\___/|_| \_\_____|
#
# Copyright (C) 2017, Daniel Stenberg, <daniel@haxx.se>, et al.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at https://curl.haxx.se/docs/copyright.html.
#
# You may opt to use, copy, modify, merge, publish, distribute and/or sell
# copies of the Software, and permit persons to whom the Software is
# furnished to do so, under the terms of the COPYING file.
#
# This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
# KIND, either express or implied.
#
###########################################################################

# Usage:
#   perl mk-lib1521.pl < ../../include/curl/curl.h > lib1521.c

# minimum and maximum long signed values
my $minlong = "LONG_MIN";
my $maxlong = "LONG_MAX";

print <<HEADER
/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \\| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \\___|\\___/|_| \\_\\_____|
 *
 * Copyright (C) 2017, Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.haxx.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ***************************************************************************/
#include "test.h"
#include "memdebug.h"
#include <limits.h>

/* This source code is generated by mk-lib1521.pl ! */

struct data {
    char *blaha;
};

#define LO $minlong
#define HI $maxlong
#define OFF_VAL (curl_off_t) 3123123123
#define OFF_LO (curl_off_t) LO
#define OFF_HI (curl_off_t) HI
#define OFF_NO (curl_off_t) 0

static size_t writecb(char *buffer, size_t size, size_t nitems,
                      void *outstream)
{
  (void)buffer;
  (void)size;
  (void)nitems;
  (void)outstream;
  return 0;
}

static size_t readcb(char *buffer,
              size_t size,
              size_t nitems,
              void *instream)
{
  (void)buffer;
  (void)size;
  (void)nitems;
  (void)instream;
  return 0;
}

curl_progress_callback progresscb;
curl_write_callback headercb;
curl_debug_callback debugcb;
curl_ssl_ctx_callback ssl_ctx_cb;
curl_ioctl_callback ioctlcb;
curl_sockopt_callback sockoptcb;
curl_opensocket_callback opensocketcb;
curl_seek_callback seekcb;
curl_sshkeycallback ssh_keycb;
curl_chunk_bgn_callback chunk_bgn_cb;
curl_chunk_end_callback chunk_end_cb;
curl_fnmatch_callback fnmatch_cb;
curl_closesocket_callback closesocketcb;
curl_xferinfo_callback xferinfocb;

int test(char *URL)
{
  int res = 0;
  CURL *curl = NULL;
  CURL *dep = NULL;
  CURLSH *share = NULL;
  char errorbuffer[CURL_ERROR_SIZE];
  void *conv_from_network_cb = NULL;
  void *conv_to_network_cb = NULL;
  void *conv_from_utf8_cb = NULL;
  void *interleavecb = NULL;
  char *stringpointerextra=(char *)"moooo";
  struct curl_slist *slist=NULL;
  struct curl_httppost *httppost=NULL;
  FILE *stream = stderr;
  struct data object;
  (void)URL; /* not used */
  easy_init(dep);
  easy_init(curl);
  share = curl_share_init();
  if(!share) {
    res = CURLE_OUT_OF_MEMORY;
    goto test_cleanup;
  }

HEADER
    ;

while(<STDIN>) {
    if($_ =~ /^  CINIT\(([^ ]*), ([^ ]*), (\d*)\)/) {
        my ($name, $type, $val)=($1, $2, $3);
        my $w="  ";
        my $pref = "$w(void)curl_easy_setopt(curl, CURLOPT_$name,";
        my $i = ' ' x (length($w) + 23);
        if($type eq "STRINGPOINT") {
            print "${pref} \"string\");\n";
            print "${pref} NULL);\n";
        }
        elsif($type eq "LONG") {
            print "${pref} 0L);\n";
            print "${pref} 22L);\n";
            print "${pref} LO);\n";
            print "${pref} HI);\n";
        }
        elsif($type eq "OBJECTPOINT") {
            if($name =~ /DEPENDS/) {
              print "${pref} dep);\n";
            }
            elsif($name =~ "SHARE") {
              print "${pref} share);\n";
            }
            elsif($name eq "ERRORBUFFER") {
              print "${pref} errorbuffer);\n";
            }
            elsif(($name eq "POSTFIELDS") ||
                  ($name eq "COPYPOSTFIELDS")) {
              print "${pref} stringpointerextra);\n";
            }
            elsif(($name eq "HTTPHEADER") ||
                  ($name eq "POSTQUOTE") ||
                  ($name eq "PREQUOTE") ||
                  ($name eq "HTTP200ALIASES") ||
                  ($name eq "TELNETOPTIONS") ||
                  ($name eq "MAIL_RCPT") ||
                  ($name eq "RESOLVE") ||
                  ($name eq "PROXYHEADER") ||
                  ($name eq "QUOTE")) {
              print "${pref} slist);\n";
            }
            elsif($name eq "HTTPPOST") {
              print "${pref} httppost);\n";
            }
            elsif($name eq "STDERR") {
              print "${pref} stream);\n";
            }
            else {
              print "${pref} &object);\n";
            }
            print "${pref} NULL);\n";
        }
        elsif($type eq "FUNCTIONPOINT") {
            if($name =~ /([^ ]*)FUNCTION/) {
              my $l=lc($1);
              print "${pref}\n$i${l}cb);\n";
            }
            else {
              print "${pref} &func);\n";
            }
            print "${pref} NULL);\n";
        }
        elsif($type eq "OFF_T") {
            # play conservative to work with 32bit curl_off_t
            print "${pref} OFF_NO);\n";
            print "${pref} OFF_VAL);\n";
            print "${pref} OFF_LO);\n";
        }
        else {
            print "\n---- $type\n";
        }
    }
}


print <<FOOTER
  curl_easy_setopt(curl, 1, 0);

test_cleanup:
  curl_easy_cleanup(curl);
  curl_easy_cleanup(dep);
  curl_share_cleanup(share);

  return res;
}
FOOTER
    ;
