# GNU Enterprise Forms - QT3 UI driver - Label widgets
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: label.py 9956 2009-10-11 18:54:57Z reinhard $

import qt

from gnue.forms.uidrivers.qt3.widgets._base import UIHelper

_alignment = {
        'left'  : qt.Qt.AlignLeft | qt.Qt.AlignVCenter,
        'center': qt.Qt.AlignHCenter | qt.Qt.AlignVCenter,
        'right' : qt.Qt.AlignRight | qt.Qt.AlignVCenter}

# =============================================================================
# UI Label widget
# =============================================================================

class UILabel(UIHelper):
    """
    """

    # -------------------------------------------------------------------------
    # Create the widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):

        self.widget = qt.QLabel(self._gfObject.text, event.container)
        self.widget.setAlignment(_alignment[self._gfObject.alignment])

        self.getParent().add_widgets(self, spacer)
        
        return self.widget


# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UILabel,
  'provides' : 'GFLabel',
  'container': 0,
}
