# GNU Enterprise Forms - HTML UI Driver - Splash Screen
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: UISplashScreen.py 8150 2006-02-06 13:57:33Z johannes $

import os.path

from gnue.common.apps import GConfig
from gnue.forms import VERSION
from Generator import build_splashscreen

# =============================================================================
# Implementation of a splash screen
# =============================================================================

class SplashScreen:

    # ---------------------------------------------------------------------------
    # Constructor
    # ---------------------------------------------------------------------------

    def __init__ (self):

        iDir    = GConfig.getInstalledBase ('forms_images', 'common_images')
        picture = gConfigForms ('splashScreenPNG')
        if not os.path.isabs (picture):
            self.picture = os.path.join (iDir, picture)

    def getPicture(self):
        file = open(self.picture,"rb")
        data = ""
        for line in file:
            data+=line
        return data

    def get_html(self, forward_url):
        return build_splashscreen(forward_url, VERSION)
