; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppId=GNUe-Common
AppName=GNU Enterprise Common Base
AppVerName=GNU Enterprise Common Base 0.6.9
AppPublisher=GNU Enterprise
AppPublisherURL=http://www.gnuenterprise.org
AppSupportURL=http://www.gnuenterprise.org
AppUpdatesURL=http://www.gnuenterprise.org
DefaultDirName={pf}\GNUe\
DefaultGroupName=GNUe
AllowNoIcons=true
LicenseFile=
ChangesAssociations=true
CreateAppDir=true
ShowLanguageDialog=yes
OutputDir=C:\GNUE\dist
OutputBaseFilename=gnue-common-0.6.9
DisableDirPage=true

[Tasks]

[Components]
Name: main; Description: Shared Program Files; Types: full compact custom; Flags: fixed
Name: doc; Description: Documentation; Types: full
Name: translations; Description: Translations; Types: full

[Files]
Source: c:\gnue\bin\gnue-schema.exe; DestDir: {app}\bin; Components: main; Flags: ignoreversion
Source: c:\gnue\bin\gnue\*.*; DestDir: {app}\bin\gnue; Components: main; Flags: ignoreversion
Source: c:\gnue\bin\gnue\common\*.*; DestDir: {app}\bin\gnue\common; Flags: recursesubdirs ignoreversion; Components: main
Source: C:\gnue\etc\sample.gnue.conf; DestDir: {app}\etc; Components: main; Flags: ignoreversion
Source: C:\gnue\etc\sample.connections.conf; DestDir: {app}\etc; Components: main; Flags: ignoreversion
Source: C:\gnue\etc\gnue.conf; DestDir: {app}\etc; Components: main; Flags: onlyifdoesntexist
Source: C:\gnue\etc\connections.conf; DestDir: {app}\etc; Components: main; Flags: onlyifdoesntexist
Source: c:\gnue\share\locale\gnue-common.mo; DestDir: {app}\share\locale\; Flags: recursesubdirs createallsubdirs; Components: translations
Source: c:\gnue\share\doc\gnue-common\*.*; DestDir: {app}\share\doc\gnue-common; Flags: recursesubdirs; Components: doc
Source: c:\gnue\share\gnue\*.*; DestDir: {app}\share\gnue\; Components: main; Flags: recursesubdirs createallsubdirs

[Icons]

[UninstallDelete]
Type: filesandordirs; Name: {app}\bin\gnue\common\*.*
Type: files; Name: {app}\bin\gnue-schema.exe
Type: files; Name: {app}\bin\gnue\*.*

[Code]
function GetPathInstalled(AppID: String): String;
var
   sPrevPath: String;
begin
  sPrevPath := '';
  if not RegQueryStringValue( HKLM,
    'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1',
    'Inno Setup: App Path', sPrevpath) then
    RegQueryStringValue( HKCU, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1' ,
      'Inno Setup: App Path', sPrevpath);

  Result := sPrevPath;
end;


function InitializeSetup(): Boolean;
var
	sPrevPath: String;
	sPrevID: String;
begin
  sPrevID := 'GNUe-Tools';
  sPrevPath := GetPathInstalled( sprevID );

  if ( Length(sPrevPath) > 0 ) then
    Result := true
  else
    begin
      MsgBox( 'GNUe-Runtime-Environment is not installed!', mbInformation, MB_OK );
      Result := false;
    end;
end;
[Registry]
Root: HKCR; SubKey: .gsd; ValueType: string; ValueData: GNUeSchema; Flags: uninsdeletekey
Root: HKCR; SubKey: GNUeSchema; ValueType: string; ValueData: GNUe Schema Definition; Flags: uninsdeletekey
Root: HKCR; SubKey: GNUeSchema\Shell\Open\Command; ValueType: string; ValueData: """{app}\bin\gnue-schema.exe"" ""%1"""; Flags: uninsdeletevalue
Root: HKCR; Subkey: GNUeSchema\DefaultIcon; ValueType: string; ValueData: {app}\bin\gnue-schema.exe,-1; Flags: uninsdeletevalue
