/* libraries.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__LIBRARIES_H
#define INCLUDE__LIBARCH__LIBRARIES_H


#include "hackerlab/machine/types.h"
#include "tla/libawk/relational.h"



/* automatically generated __STDC__ prototypes */
extern t_uchar * arch_library_archive_dir (t_uchar * archive);
extern t_uchar * arch_library_category_dir (t_uchar * archive, t_uchar * category);
extern t_uchar * arch_library_branch_dir (t_uchar * archive, t_uchar * branch);
extern t_uchar * arch_library_version_dir (t_uchar * archive, t_uchar * version);
extern t_uchar * arch_library_revision_dir (t_uchar * archive, t_uchar * revision);
extern t_uchar * arch_library_find (t_uchar * archive, t_uchar * revision);
extern t_uchar * arch_library_find_file (t_uchar * archive, t_uchar * revision, t_uchar * loc);
extern t_uchar * arch_library_find_file_by_tag (t_uchar * archive, t_uchar * revision, t_uchar * tag);
extern rel_table arch_library_archives (void);
extern rel_table arch_library_categories (t_uchar * archive);
extern rel_table arch_library_branches (t_uchar * archive, t_uchar * category);
extern rel_table arch_library_versions (t_uchar * archive, t_uchar * branch);
extern rel_table arch_library_revisions (t_uchar * archive, t_uchar * version, int full);
extern t_uchar * arch_library_log (t_uchar * archive, t_uchar * revision);
extern t_uchar * arch_library_index_file (t_uchar * archive, t_uchar * revision);
extern rel_table arch_library_index (t_uchar * archive, t_uchar * revision);
#endif  /* INCLUDE__LIBARCH__LIBRARIES_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (libraries.h)
 */
