/*
*  gcal_hlp.c:  The help, version and license screens.
*
*
*  Copyright (C) 1994, 1995, 1996 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



#ifdef RCSID
static char rcsid[]="$Id: gcal_hlp.c 2.10 1996/07/02 02:01:00 tom Exp $";
#endif



/*
*  Include header files.
*/
#include "gcal_tai.h"
#include "gcal.h"



/*
*  Function prototypes.
*/
#if __cplusplus
extern "C"
{
#endif
/*
************************************************** Defined in `gcal_tty.c'.
*/
IMPORT void
print_text __P_((FILE *fp,
                 char *text_line));
/*
************************************************** Defined in `gcal_utl.c'.
*/
IMPORT VOID_PTR
my_malloc __P_((const int   amount,
                const int   exit_status,
                const char *module_name,
                const long  module_line,
                const char *var_name,
                const int   var_contents));
IMPORT const char *
short_day_name __P_((const int day));
IMPORT const char *
short3_day_name __P_((const int day));
IMPORT const char *
short_month_name __P_((const int month));
/*
************************************************** Defined in `gcal_hlp.c'.
*/
EXPORT void
my_help_on_help __P_((      FILE *fp,
                      const char *longopt,
                      const Bool  lopt_ambig,
                      const int   cols));
EXPORT void
my_extended_help __P_((      FILE *fp,
                       const int   longopt_symbolic));
EXPORT void
my_basic_help __P_((FILE *fp));
EXPORT void
my_license __P_((      FILE *fp,
                 const char *prgr_id));
EXPORT void
my_version __P_((      FILE *fp,
                 const char *prgr_id));
EXPORT char *
usage_msg __P_((void));
EXPORT void
put_longopt_description __P_((FILE *fp));
LOCAL const char *
get_longopt_description __P_((const int  longopt_symbolic,
                              const Bool with_larglist));
LOCAL void
my_copyright __P_((      FILE *fp,
                   const char *prgr_id));
LOCAL void
my_help_head_text __P_((FILE *fp));
LOCAL void
my_help_tail_text __P_((FILE *fp));
LOCAL void
print_compiler_info __P_((FILE *fp));
#if __cplusplus
}
#endif



/*
*  Declare public(extern) variables.
*/
IMPORT const Lopt_struct  lopt[];               /* The table of long-style options */
IMPORT const Df_struct    info_date_format[];   /* The table of information of supported date formats */
IMPORT Df_struct    supported_date_format[];    /* The table of supported date formats */
IMPORT Df_struct   *date_format;                /* Points to the used date format */
IMPORT Greg_struct  greg_reform_date[];         /* The table of Gregorian Reformation dates */
IMPORT Greg_struct *greg;                       /* Points to the used Gregorian Reformation date */
IMPORT Hls_struct   ehls1s;                     /* Effective hls 1 start (current day) */
IMPORT Hls_struct   ehls1e;                     /* Effective hls 1 end (current day) */
IMPORT Hls_struct   ehls2s;                     /* Effective hls 2 start (holiday) */
IMPORT Hls_struct   ehls2e;                     /* Effective hls 2 end (holiday) */
IMPORT int          len_year_max;               /* String length of the maximum year able to compute */
IMPORT int          act_year;                   /* Actual year */
IMPORT int          is_tty;                     /* Is output displayed on a terminal? */
IMPORT int          len_prgr_name;              /* Length of actual program name */
IMPORT char        *yy_lit;                     /* The "yy" text */
IMPORT char        *yyyy_lit;                   /* The "yyyy" text */
IMPORT char        *mm_lit;                     /* The "mm" text */
IMPORT char        *www_lit;                    /* The "www" text */
IMPORT char        *dd_lit;                     /* The "dd" text */
IMPORT char        *s1;                         /* General purpose text buffer */
IMPORT char        *s2;                         /* General purpose text buffer */
IMPORT char        *prgr_name;                  /* Stores the actual program name */
#ifdef GCAL_EPAGER
IMPORT char        *ext_pager;                  /* Name of external pager program */
#endif
IMPORT Bool         use_short3_day_name;        /* 3 char day name format specifier given in date format? */
IMPORT Bool         emu_hls;                    /* Must we emulate the highlighting sequences? */
IMPORT Bool         highlight_flag;             /* -H<yes> or -H<no> */



/*
*  Define local(static) variables.
*/
#if USE_GER
LOCAL const char *compiler_info[]={"   Kompiliert mit %s%s f"UE"r %s%s%s%s"};   /* Compiler infotext */
#else /* !USE_GER */
LOCAL const char *compiler_info[]={N_("   Compiled with %s%s for %s%s%s%s")};    /* Compiler infotext */
#endif /* !USE_GER */



   PUBLIC void
my_help_on_help (fp, longopt, lopt_ambig, cols)
         FILE *fp;
   const char *longopt;
   const Bool  lopt_ambig;
   const int   cols;
/*
   Prints the "help on help" text to file `fp' using the central output
     function `print_text()' and uses global text buffer `s1' internally.
     If delivered `lopt_ambig' is TRUE, only display the names of all
     longoptions stored in `lopt' structure member `long_name', which
     are equal to delivered `longopt'.
*/
{
   auto     const Lopt_struct  *ptr_lopt=lopt;
   register const int           filler_blanks=2;
   register const int           len_longopt=(int)strlen(longopt);
   register       int           len_line;
   register       int           len_string;


#if USE_GER
   sprintf(s1, "%s: Benutze `%s %s' mit einem dieser Argumente",
           prgr_name, prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#else /* !USE_GER */
   sprintf(s1, _("%s: Use `%s %s' with one of these arguments"),
           prgr_name, prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE));
#endif /* !USE_GER */
   print_text (fp, s1);
   print_text (fp, s1);
   for (len_line=0 ; len_line < filler_blanks ; len_line++)
     s1[len_line] = ' ';
   s1[len_line] = '\0';
   if (lopt_ambig)
    {
      while (*ptr_lopt->long_name < *longopt)
        ptr_lopt++;
      while (strncmp(longopt+1, ptr_lopt->long_name+1, len_longopt-1))
        ptr_lopt++;
    }
   while (ptr_lopt->long_name != NULL)
    {
      len_string = (int)strlen(ptr_lopt->long_name) + 1;
      if ((ptr_lopt+1)->long_name != NULL)
        len_string++;
      if (len_line + len_string >= cols)
       {
         print_text (fp, s1);
         for (len_line=0 ; len_line < filler_blanks ; len_line++)
           s1[len_line] = ' ';
         s1[len_line] = '\0';
       }
      strcat(s1, " ");
      strcat(s1, ptr_lopt->long_name);
      if ((ptr_lopt+1)->long_name != NULL)
       {
         if (   lopt_ambig
             && strncmp(longopt, (ptr_lopt+1)->long_name, len_longopt))
           break;
         strcat(s1, ",");
         len_line += len_string;
       }
      ptr_lopt++;
    }
   print_text (fp, s1);
}



   PUBLIC void
my_extended_help (fp, longopt_symbolic)
         FILE *fp;
   const int   longopt_symbolic;
/*
   Prints the "extended help" text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' and `s2' internally.
     If `longopt_symbolic' is set to SYM_NIL, the complete text
     is shown, otherwise the text corresponding to SYM_??? only!
*/
{
   auto const Df_struct    *ptr_info_date_format=info_date_format;
   auto       Df_struct    *ptr_date_format=supported_date_format;
   auto       Greg_struct  *ptr_greg=greg_reform_date;
   auto       Bool          print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   if (longopt_symbolic == SYM_NIL)
    {
      my_help_head_text (fp);
#if USE_RC
#  if USE_GER
      sprintf(s1, "Aufruf: %s [[OPTION...] [%cDATUM] [%cDATEI...]] [KOMMANDO]",
              prgr_name, RC_ADATE_CHAR, RSP_CHAR);
#  else /* !USE_GER */
      sprintf(s1, _("Usage:  %s [[OPTION...] [%cDATE] [%cFILE...]] [COMMAND]"),
              prgr_name, RC_ADATE_CHAR, RSP_CHAR);
#  endif /* !USE_GER */
#else /* !USE_RC */
#  if USE_GER
      sprintf(s1, "Aufruf: %s [[OPTION...] [%cDATEI...]] [KOMMANDO]", prgr_name, RSP_CHAR);
#  else /* !USE_GER */
      sprintf(s1, _("Usage:  %s [[OPTION...] [%cFILE...]] [COMMAND]"), prgr_name, RSP_CHAR);
#  endif /* !USE_GER */
#endif /* !USE_RC */
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      strcat(s1, _("OPTION"));
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
    }
#if USE_GER
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_HELP:
        sprintf(s1, "%s?        %s", SWITCH, get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        sprintf(s1, "%sh        %s", SWITCH, get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Hilfetext ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LONG_HELP1:
      case SYM_LONG_HELP2:
        sprintf(s1, "%s??       %s", SWITCH, get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "%shh       %s", SWITCH, get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LONG_HELP2, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Erweiterten Hilfetext ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LICENSE1:
      case SYM_LICENSE2:
      case SYM_LICENSE3:
        sprintf(s1, "%sL        %s", SWITCH, get_longopt_description (SYM_LICENSE1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE2, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE3, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Softwarelizenz ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_VERSION:
        sprintf(s1, "%sV        %s", SWITCH, get_longopt_description (SYM_VERSION, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Versionsnummer ausgeben und Programm beenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESPONSE_FILE:
        sprintf(s1, "%sR ARG    %s", SWITCH, get_longopt_description (SYM_RESPONSE_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Antwortdatei f"UE"r die `%cDATEI' Option erzeugen", RSP_CHAR);
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Schreibe Argumente der Kommandozeile in Datei ARG");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_SHELL
      case SYM_SCRIPT_FILE:
        sprintf(s1, "%sS ARG    %s", SWITCH, get_longopt_description (SYM_SCRIPT_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Shell script mit den Argumenten der Kommandozeile erzeugen");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Dateiname des shell scripts");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
#  if USE_RC
      case SYM_DATE_VARIABLE:
        sprintf(s1, "%sv ARG    %s", SWITCH, get_longopt_description (SYM_DATE_VARIABLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Globale Datumvariable(n) \"dvar->a|b|c|d|f|...|z\" definieren");
        print_text (fp, s1);
        sprintf(s1, "   ARG    = Definitionen der Form \"dvar%s`%s%s'\" getrennt durch `%s' Zeichen",
                RC_DVAR_ASSIGN, mm_lit, dd_lit, SEP);
        print_text (fp, s1);
        sprintf(s1, "            z.B.  %sv a%s1127%sb%s054   Setze `a' auf 27 Nov und `b' auf 4 Mai",
                SWITCH, RC_DVAR_ASSIGN, SEP, RC_DVAR_ASSIGN);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXPORT_LOCAL_DVARS:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXPORT_LOCAL_DVARS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Lokale Datumvariablen von Datei zu Datei exportieren");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_TEXT_VARIABLE:
        sprintf(s1, "%sr ARG    %s", SWITCH, get_longopt_description (SYM_TEXT_VARIABLE, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Globale Textvariable(n) \"tvar->%ca...%cz\" definieren",
                RC_TVAR_CHAR, RC_TVAR_CHAR);
        print_text (fp, s1);
        sprintf(s1, "   ARG    = Definitionen der Form \"tvar%s`text'\" getrennt durch `%s' Zeichen",
                RC_TVAR_ASSIGN, SEP);
        print_text (fp, s1);
        sprintf(s1, "            z.B.  %sr %ca%sfoo%s%cb%sbar   Setze `%ca' auf `foo' und `%cb' auf `bar'",
                SWITCH, RC_TVAR_CHAR, RC_TVAR_ASSIGN, SEP, RC_TVAR_CHAR, RC_TVAR_ASSIGN,
                RC_TVAR_CHAR, RC_TVAR_CHAR);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXPORT_LOCAL_TVARS:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXPORT_LOCAL_TVARS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Lokale Textvariablen von Datei zu Datei exportieren");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DEBUG:
        sprintf(s1, "          %s", get_longopt_description (SYM_DEBUG, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Einige Debug-Informationen ausgeben");
        print_text (fp, s1);
        strcpy(s1, "  [ARG]   = internal    Warnungen bei Erreichen programminterner Maxima");
        print_text (fp, s1);
        strcpy(s1, "          = handled     Wie `internal' und zudem gehandhabte Dateinamen");
        print_text (fp, s1);
        strcpy(s1, "          = unhandled   Wie `internal' und zudem nicht gehandhabte Dateinamen");
        print_text (fp, s1);
        strcpy(s1, "          = all         Wie `handled' und `unhandled' zusammen");
        print_text (fp, s1);
        strcpy(s1, "          = abort       Wie `all' und Abbruch bei ungehandhabten Dateinamen");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_TYPE_OF_CALENDAR:
        sprintf(s1, "%si[MOD]   %s", SWITCH, get_longopt_description (SYM_TYPE_OF_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Spezial-Kalenderformat f"UE"r Kalenderblatt verwenden");
        print_text (fp, s1);
        strcat(s1, "  [MOD]   = -   Standard-Kalenderformat f"UE"r Kalenderblatt verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_SUPPRESS_CALENDAR:
        sprintf(s1, "%su        %s", SWITCH, get_longopt_description (SYM_SUPPRESS_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ausgabe des Kalenderblatts explizit unterdr"UE"cken");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  if USE_PAGER
      case SYM_PAGER:
        sprintf(s1, "%sp        %s", SWITCH, get_longopt_description (SYM_PAGER, TRUE));
        print_text (fp, s1);
#    ifdef GCAL_EPAGER
        if (ext_pager != (char *)NULL)
          sprintf(s1, "          Ausgabe durch externen `%s' Paginierer lenken",
                  (*ext_pager == *DIR_SEP) ? strrchr(ext_pager, *DIR_SEP)+1 : ext_pager);
        else
          strcpy(s1, "          Ausgabe durch einfachen internen Paginierer lenken");
#    else /* !GCAL_EPAGER */
        strcpy(s1, "          Ausgabe durch einfachen internen Paginierer lenken");
#    endif /* !GCAL_EPAGER */
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DISABLE_HIGHLIGHTING:
        sprintf(s1, "%sH no     %s", SWITCH, get_longopt_description (SYM_DISABLE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=no",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, "          Text, Feiertag bzw. aktuelles Datum ohne Hervorhebung ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_FORCE_HIGHLIGHTING:
        sprintf(s1, "%sH yes    %s", SWITCH, get_longopt_description (SYM_FORCE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=yes",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, "          Bel"AE"sst Hervorhebungssequenzen in Ausgabe bei Ausgabeumlenkung");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HIGHLIGHTING:
        sprintf(s1, "%sH ARG    %s", SWITCH, get_longopt_description (SYM_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Setze Hervorhebungssequenz-Paare 1 (=aktueller Tag) und 2 (=Feiertag)");
        print_text (fp, s1);
        sprintf(s1, "   ARG    = Durch `%s' Zeichen getrennte Hervorhebungssequenz-Paare",
                SEP);
        print_text (fp, s1);
        sprintf(s1, "            z.B.  %sH \\x2%s\\xAE   Benutze Hex-Wert 2 und AE f"UE"r Sequenz 1",
                SWITCH, SEP);
        print_text (fp, s1);
        sprintf(s1, "            z.B.  %sH %s%s*%s*      Benutze Zeichen `*' und `*' f"UE"r Sequenz 2",
                SWITCH, SEP, SEP, SEP);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_BLOCKS:
        sprintf(s1, "%sb ARG    %s", SWITCH, get_longopt_description (SYM_BLOCKS, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Format des Jahreskalenders festlegen");
        print_text (fp, s1);
        strcpy(s1, "   ARG    = 1|2|3|4|6|12   Anzahl der Bl"OE"cke");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_CALENDAR_DATES:
        sprintf(s1, "%sj[MOD]   %s", SWITCH, get_longopt_description (SYM_CALENDAR_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Fortlaufenden Tag des Jahres im Kalenderblatt verwenden");
        print_text (fp, s1);
        strcpy(s1, "  [MOD]   = b   Beide Datumnotationen (Tag des Monats+Jahres) verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HOLIDAY_DATES:
        sprintf(s1, "%sjn[MOD]  %s", SWITCH, get_longopt_description (SYM_HOLIDAY_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Fortlaufenden Tag des Jahres in ewiger Feiertagsliste verwenden");
        print_text (fp, s1);
        strcpy(s1, "   [MOD]  = b   Beide Datumnotationen (Tag des Monats+Jahres) verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#if USE_RC
      case SYM_FIXED_DATES:
        sprintf(s1, "%sjc[MOD]  %s", SWITCH, get_longopt_description (SYM_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Fortlaufenden Tag des Jahres in Terminwarnungsliste verwenden");
        print_text (fp, s1);
        strcpy(s1, "   [MOD]  = b   Beide Datumnotationen (Tag des Monats+Jahres) verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
      case SYM_STARTING_DAY:
        sprintf(s1, "%ss ARG    %s", SWITCH, get_longopt_description (SYM_STARTING_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Starttag der Woche festlegen");
        print_text (fp, s1);
        sprintf(s1, "   ARG    = 0|Today | %d|%s | %d|%s | ... | %d|%s",
                DAY_MIN, short_day_name (DAY_MIN),
                DAY_MIN+1, short_day_name (DAY_MIN+1),
                DAY_MAX, short_day_name (DAY_MAX));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_EMAIL
      case SYM_MAIL:
        sprintf(s1, "%sm ARG    %s", SWITCH, get_longopt_description (SYM_MAIL, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Versenden der Ausgabe via `%s' Programm an Benutzer",
                MAIL_PRGR);
        print_text (fp, s1);
        strcpy(s1, "   ARG    = Email Adresse");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_HOLIDAY_LIST:
      case SYM_DESC_HOLIDAY_LIST:
        sprintf(s1, "%sn|N[MOD] %s", SWITCH, get_longopt_description (SYM_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_DESC_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Ewige Feiertagsliste ausgeben (Jahr im Bereich: %d...%d)",
                EASTER_MIN, EASTER_MAX);
        print_text (fp, s1);
        strcpy(s1, " n        = Gesetzliche Feiertage und Gedenktage");
        print_text (fp, s1);
        strcpy(s1, "   N      = Nur gesetzliche Feiertage");
        print_text (fp, s1);
        sprintf(s1, "    [MOD] = %s   Absteigend sortiert", DES_LIT);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_HD_TITLE:
        sprintf(s1, "%sX        %s", SWITCH, get_longopt_description (SYM_EXCLUDE_HD_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ewige Feiertagsliste ohne "UUE"berschrift ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_CHRIST_HDY:
        sprintf(s1, "          %s", get_longopt_description (SYM_CHRIST_HDY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ewige Feiertagsliste mit christlichen Feiertagen ausstatten");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_DE_HDY:
        sprintf(s1, "          %s", get_longopt_description (SYM_DE_HDY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ewige Feiertagsliste mit deutschen Feiertagen ausstatten");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_US_HDY:
        sprintf(s1, "          %s", get_longopt_description (SYM_US_HDY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Ewige Feiertagsliste mit US amerikanischen Feiertagen ausstatten");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_GREG_REFORM:
        sprintf(s1, "          %s", get_longopt_description (SYM_GREG_REFORM, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Setze Zeitraum der Gregorianischen Reformation");
        print_text (fp, s1);
        sprintf(s1, "          Aktuell ber"UE"cksichtigter Zeitraum:  %d-%d %s %0*d",
                greg->first_day, greg->last_day, short_month_name (greg->month),
                len_year_max, greg->year);
        print_text (fp, s1);
        do
         {
           sprintf(s1, "   %-*d%*s = Setze Zeitraum auf:  %d-%d %s %0*d",
                   len_year_max, ptr_greg->year, 6-len_year_max, "",
                   ptr_greg->first_day, ptr_greg->last_day,
                   short_month_name (ptr_greg->month), len_year_max, ptr_greg->year);
           print_text (fp, s1);
         } while ((++ptr_greg)->year);   /* I don't like the GNU-coding scheme for do-whiles */
        sprintf(s1, "   ARG    = %s%s%s%s%s%s%s   Setze Zeitraum explizit",
                yyyy_lit, GDATE_SEP, mm_lit, GDATE_SEP, dd_lit, GDATE_SEP, dd_lit);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_DATE_FORMAT:
        sprintf(s1, "          %s", get_longopt_description (SYM_DATE_FORMAT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Anordnung der Datumelemente mit dem Formattext ARG festlegen");
        print_text (fp, s1);
        sprintf(s1, "          Aktuelles Format:  (%s) `%s' (%s)",
                (date_format->id==(char *)NULL) ? "Selbstdefiniert" : date_format->id,
                date_format->format, date_format->info);
        print_text (fp, s1);
        do
         {
           sprintf(s1, "   %-6s = Setze Format auf:  `%s' (%s)", ptr_date_format->id,
                   ptr_date_format->format, ptr_date_format->info);
           print_text (fp, s1);
         } while ((++ptr_date_format)->id != (char *)NULL);   /* I don't like the GNU-coding scheme for do-whiles */
        strcpy(s1, "   ARG    = Eigenes Format definieren. Ber"UE"cksichtigte Formatelemente sind:");
        print_text (fp, s1);
        do
         {
           if (*ptr_info_date_format->format == '\0')
             sprintf(s1, "               %s", ptr_info_date_format->info);
           else
             sprintf(s1, "            %-2s = %s", ptr_info_date_format->format, ptr_info_date_format->info);
           print_text (fp, s1);
         } while ((++ptr_info_date_format)->info != (char *)NULL);   /* I don't like the GNU-coding scheme for do-whiles */
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXIT_STAT_HELP_127:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXIT_STAT_HELP_127, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Setze Programm EXIT Status auf 127 bei --help, --version etc.");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
#  if USE_RC
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      sprintf(s1, "+++ TERMINWARNUNGEN +++");
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_TODAY:
      case SYM_FIXED_DATES_LIST:
      case SYM_DESC_FIXED_DATES_LIST:
        sprintf(s1, "%sc|C[MOD] %s", SWITCH, get_longopt_description (SYM_FIXED_DATES_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_DESC_FIXED_DATES_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_TODAY, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          Benutze Standard-Ressourcendatei `%s' f"UE"r Terminliste",
                PRGR_RC_NAME);
        print_text (fp, s1);
        strcpy(s1, "          Impliziert Warnungszeitraum:  Heute");
        print_text (fp, s1);
        strcpy(s1, " c        = Nur die Daten ausgeben, zu denen Termine vorliegen");
        print_text (fp, s1);
        strcpy(s1, "   C      = Auch die Daten ausgeben, zu denen keine Termine vorliegen");
        print_text (fp, s1);
        sprintf(s1, "    [MOD] = %s   Absteigend sortiert", DES_LIT);
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "    [MOD] = Einer oder mehr der folgenden Modifizierer; hier markiert mit #");
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_GROUPING_TEXT:
        sprintf(s1, "          %s", get_longopt_description (SYM_GROUPING_TEXT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # g[MOD]       = Benutze Trenntext MOD f"UE"r tageweise Gruppierung");
        print_text (fp, s1);
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          1. Darstellung des Textes");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_FILENAME:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_FILENAME, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # a            = Herkunft der Terminwarnung ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_ALTERNATIVE_FORMAT:
        sprintf(s1, "          %s", get_longopt_description (SYM_ALTERNATIVE_FORMAT, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # A            = Alternatives Listenformat verwenden");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_HOLIDAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_HOLIDAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # e            = Gesetzliche Feiertage und Gedenktage einf"UE"gen");
        print_text (fp, s1);
        strcpy(s1, "          # E            = Nur gesetzliche Feiertage einf"UE"gen");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_WEEK_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_WEEK_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # k            = ISO-Wochennummer ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_OMIT_DATE_PART:
        sprintf(s1, "          %s", get_longopt_description (SYM_OMIT_DATE_PART, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # o            = Datumfeld nur einmal ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_RC_TITLE:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXCLUDE_RC_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # x            = Terminwarnungsliste ohne "UUE"berschrift ausgeben");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_CONS_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_CONS_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # z            = Fortlaufende Postennummer ausgeben");
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, "          2. Warnungszeitraum");
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LEAP_DAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_LEAP_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "                         = Den `29-FEBRUAR' in Nicht-Schaltjahren handhaben");
        print_text (fp, s1);
        strcpy(s1, "                           ARG = february   Am `28-FEBRUAR' ber"UE"cksichtigen");
        print_text (fp, s1);
        strcpy(s1, "                           ARG = march      Am `01-M"AAE"RZ' ber"UE"cksichtigen");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_TODAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_TODAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # d            = Aktuelles Datum einschliessen bei Datumliste");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LIST_MODE:
        sprintf(s1, "          %s", get_longopt_description (SYM_LIST_MODE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # l            = Datumliste anstelle Einzeldatum");
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_PERIOD:
        sprintf(s1, "          %s", get_longopt_description (SYM_PERIOD, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # Nd           = Einzelner absoluter Tag N");
        print_text (fp, s1);
        sprintf(s1, "          # %cdN          = Einzelner absoluter Tag N", RC_NWD_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # NMOD         = Einzelner Tag N relativ zu heute");
        print_text (fp, s1);
        sprintf(s1, "             MOD           = %s   Vorw"AE"rts", ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, "                           = %s   R"UE"ckw"AE"rts", DES_LIT);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, "          # Nw           = Gesamte Woche N");
        print_text (fp, s1);
        strcpy(s1, "                           N = 0        1'te Woche / letzte Woche im Vorjahr");
        print_text (fp, s1);
        strcpy(s1, "                           N = 1...52   1'te...52'te Woche (stets)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 53       53'te Woche (manchmal)");
        print_text (fp, s1);
        strcpy(s1, "                           N = 99       Letzte Woche");
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # `%s%s'       = Einzelner Tag `%s' im Monat `%s'",
                mm_lit, dd_lit, dd_lit, mm_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # `%s%s'N     = Einzelner N'ter Wochentag `%s' im Monat `%s'",
                mm_lit, www_lit, www_lit, mm_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 1...4   1'ter...4'ter Wochentag `%s' (stets)", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 5       5'ter Wochentag `%s' (manchmal)", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 9       Letzter Wochentag `%s'", www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cdN`%s'     = Einzelner N'ter Wochentag `%s'",
                RC_NWD_CHAR, www_lit, www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 1...51   1'ter...51'ter Wochentag `%s' (stets)", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 52|53    52|53'ter Wochentag `%s' (manchmal)", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 99       Letzter Wochentag `%s'", www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cwN`%s'     = Einzelner Wochentag `%s' der N'ten Woche",
                RC_NWD_CHAR, www_lit, www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 0        `%s' der nicht in der 1'ten Woche ist", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 1...51   `%s' der 1'ten...51'ten Woche (stets)", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 52|53    `%s' der 52|53'ten Woche (manchmal)", www_lit);
        print_text (fp, s1);
        sprintf(s1, "                           N = 99       `%s' der letzten Woche", www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %ce[[%s|%s]N]   = Einzelner Tag N relativ zu Ostersonntag",
                RC_HDY_CHAR, ASC_LIT, DES_LIT);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %ce[%s|%s]N`%s'= Einzelner N'ter Wochentag relativ zu Ostersonntag",
                RC_HDY_CHAR, ASC_LIT, DES_LIT, www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cv[[%s|%s]N]   = Einzelner Tag N relativ zur Datumvariablen",
                RC_HDY_CHAR, ASC_LIT, DES_LIT);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, "          # %cv[%s|%s]N`%s'= Einzelner N'ter Wochentag relativ zur Datumvariablen",
                RC_HDY_CHAR, ASC_LIT, DES_LIT, www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
      case SYM_TOMORROW:
        sprintf(s1, "          %s", get_longopt_description (SYM_TOMORROW, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # t|T          = Datumliste von morgen");
        print_text (fp, s1);
        if (longopt_symbolic == SYM_TOMORROW)
          break;
        print_text (fp, s1);
      case SYM_WEEK:
      case SYM_END_OF_WEEK:
      case SYM_START_OF_WEEK:
        sprintf(s1, "          %s", get_longopt_description (SYM_WEEK, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_END_OF_WEEK, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_START_OF_WEEK, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # w|W[MOD]     = Datumliste der gesamten Woche");
        print_text (fp, s1);
        sprintf(s1, "               [MOD]       = %s   Liste von morgen bis Ende der Woche",
                ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, "                           = %s   Liste von gestern bis Anfang der Woche",
                DES_LIT);
        print_text (fp, s1);
        if (   longopt_symbolic == SYM_WEEK
            || longopt_symbolic == SYM_END_OF_WEEK
            || longopt_symbolic == SYM_START_OF_WEEK)
          break;
        print_text (fp, s1);
      case SYM_MONTH:
      case SYM_END_OF_MONTH:
      case SYM_START_OF_MONTH:
        sprintf(s1, "          %s", get_longopt_description (SYM_MONTH, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_END_OF_MONTH, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_START_OF_MONTH, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # m|M[MOD]     = Datumliste des gesamten Monats");
        print_text (fp, s1);
        sprintf(s1, "               [MOD]       = %s   Liste von morgen bis Ende des Monats",
                ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, "                           = %s   Liste von gestern bis Anfang der Monats",
                DES_LIT);
        print_text (fp, s1);
        if (   longopt_symbolic == SYM_MONTH
            || longopt_symbolic == SYM_END_OF_MONTH
            || longopt_symbolic == SYM_START_OF_MONTH)
          break;
        print_text (fp, s1);
      case SYM_YEAR:
      case SYM_END_OF_YEAR:
      case SYM_START_OF_YEAR:
        sprintf(s1, "          %s", get_longopt_description (SYM_YEAR, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_END_OF_YEAR, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_START_OF_YEAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          # y|Y[MOD]     = Datumliste des gesamten Jahres");
        print_text (fp, s1);
        sprintf(s1, "               [MOD]       = %s   Liste von morgen bis Ende des Jahres",
                ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, "                           = %s   Liste von gestern bis Anfang des Jahres",
                DES_LIT);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESOURCE_FILE:
        sprintf(s1, "%sf|F ARG  %s", SWITCH, get_longopt_description (SYM_RESOURCE_FILE, TRUE));
        print_text (fp, s1);
        strcpy(s1, "          Benutze alternative Datei(en) anstelle Standard-Ressourcendatei");
        print_text (fp, s1);
        strcpy(s1, "          Impliziert Warnungszeitraum:  Heute");
        print_text (fp, s1);
        strcpy(s1, " f        = Nur die Daten ausgeben, zu denen Termine vorliegen");
        print_text (fp, s1);
        strcpy(s1, "   F      = Auch die Daten ausgeben, zu denen keine Termine vorliegen");
        print_text (fp, s1);
        sprintf(s1, "     ARG  = Einzelne Datei oder durch `%s' Zeichen separierte Liste von Dateien",
                RC_FNAME_SEP);
        print_text (fp, s1);
      default:
          ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, "%cDATUM", RC_ADATE_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, "Vorgegebenes `DATUM' anstelle heutiges Datum verwenden");
      print_text (fp, s1);
      sprintf(s1, "Datumformat:  `%s[%s[%s|%s[N]]]', `%s%c%c|dvar[[%s|%s]N[%s]]', `%s%cdN[%s]'",
              yyyy_lit, mm_lit, dd_lit, www_lit, yyyy_lit, RC_HDY_CHAR, RC_EASTER_CHAR, ASC_LIT,
              DES_LIT, www_lit, yyyy_lit, RC_NWD_CHAR, www_lit);
      print_text (fp, s1);
      sprintf(s1, "              `%s%cwN[%s]', `Monatsname[%s]', `Wochentagsname[N]' oder `%s'",
              yyyy_lit, RC_NWD_CHAR, www_lit, dd_lit, dd_lit);
      print_text (fp, s1);
    }
#  endif /* USE_RC */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, "%cDATEI", RSP_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, "L"AE"dt Optionen und Kommandos aus `DATEI' vor");
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      strcat(s1, "KOMMANDO");
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      sprintf(s1, "%s       = Monat im Bereich:  %d...%d", mm_lit, MONTH_MIN, MONTH_MAX);
      print_text (fp, s1);
      sprintf(s1, "                       oder:  Monatsname | %s | %s%s | %s%s | %s%s",
              MONTH3_LIT, MONTH3_LIT, MONTH3_LIT, MONTH3_LIT, ASC_LIT, MONTH3_LIT, DES_LIT);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, "           Liste:    %s[%s%s]%s...%s%s[%s%s]",
              mm_lit, YEAR_SEP, yyyy_lit, MLIST_SEP, MLIST_SEP, mm_lit, YEAR_SEP, yyyy_lit);
      print_text (fp, s1);
      sprintf(s1, "           Bereich:  %s[%s%s]%s%s[%s%s] | %s%s%s%s%s | %s %s%s%s",
              mm_lit, YEAR_SEP, yyyy_lit, MRANGE_SEP, mm_lit, YEAR_SEP, yyyy_lit,
              mm_lit, YEAR_SEP, yyyy_lit, MRANGE_SEP, yyyy_lit,
              mm_lit, yyyy_lit, MRANGE_SEP, yyyy_lit);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, "%s%*s   = Jahr  im Bereich:  %d...%d",
              yyyy_lit, 6-len_year_max, "", YEAR_MIN, YEAR_MAX);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, "           Liste:    [%s%s]%s%s...%s[%s%s]%s",
              mm_lit, FYEAR_SEP, yyyy_lit, YLIST_SEP, YLIST_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
      print_text (fp, s1);
      sprintf(s1, "           Bereich:  [%s%s]%s%s[%s%s]%s",
              mm_lit, FYEAR_SEP, yyyy_lit, YRANGE_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, "   +++ Bei zweistelliger Jahresangabe wird NICHT von %2d%s ausgegangen +++",
              act_year/100, yy_lit);
    }
#else /* !USE_GER */
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_HELP:
        sprintf(s1, "%s?        %s", SWITCH, get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        sprintf(s1, "%sh        %s", SWITCH, get_longopt_description (SYM_HELP, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Display help text and quit program"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LONG_HELP1:
      case SYM_LONG_HELP2:
        sprintf(s1, "%s??       %s", SWITCH, get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "%shh       %s", SWITCH, get_longopt_description (SYM_LONG_HELP1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LONG_HELP2, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Display extended help text and quit program"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LICENSE1:
      case SYM_LICENSE2:
      case SYM_LICENSE3:
        sprintf(s1, "%sL        %s", SWITCH, get_longopt_description (SYM_LICENSE1, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE2, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_LICENSE3, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Display software license and quit program"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_VERSION:
        sprintf(s1, "%sV        %s", SWITCH, get_longopt_description (SYM_VERSION, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Display version number and quit program"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESPONSE_FILE:
        sprintf(s1, "%sR ARG    %s", SWITCH, get_longopt_description (SYM_RESPONSE_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, _("          Create response file for the `%cFILE' option"), RSP_CHAR);
        print_text (fp, s1);
        strcpy(s1, _("   ARG    = Store arguments of command line in file ARG"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_SHELL
      case SYM_SCRIPT_FILE:
        sprintf(s1, "%sS ARG    %s", SWITCH, get_longopt_description (SYM_SCRIPT_FILE, TRUE));
        print_text (fp, s1);
        sprintf(s1, _("          Create shell script which contains the arguments of command line"));
        print_text (fp, s1);
        strcpy(s1, _("   ARG    = File name of the shell script"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
#  if USE_RC
      case SYM_DATE_VARIABLE:
        sprintf(s1, "%sv ARG    %s", SWITCH, get_longopt_description (SYM_DATE_VARIABLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Define global date variable(s) \"dvar->a|b|c|d|f|...|z\""));
        print_text (fp, s1);
        sprintf(s1, _("   ARG    = Definition of \"dvar%s`%s%s'\" separated by `%s' characters"),
                RC_DVAR_ASSIGN, mm_lit, dd_lit, SEP);
        print_text (fp, s1);
        sprintf(s1, _("            e.g.  %sv a%s1127%sb%s054   Set `a' to Nov 27 and `b' to May 4"),
                SWITCH, RC_DVAR_ASSIGN, SEP, RC_DVAR_ASSIGN);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXPORT_LOCAL_DVARS:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXPORT_LOCAL_DVARS, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Export local date variables from file to file"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_TEXT_VARIABLE:
        sprintf(s1, "%sr ARG    %s", SWITCH, get_longopt_description (SYM_TEXT_VARIABLE, TRUE));
        print_text (fp, s1);
        sprintf(s1, _("          Define global text variable(s) \"tvar->%ca...%cz\""),
                RC_TVAR_CHAR, RC_TVAR_CHAR);
        print_text (fp, s1);
        sprintf(s1, _("   ARG    = Definition of \"tvar%s`text'\" separated by `%s' characters"),
                RC_TVAR_ASSIGN, SEP);
        print_text (fp, s1);
        sprintf(s1, _("            e.g.  %sr %ca%sfoo%s%cb%sbar   Set `%ca' to `foo' and `%cb' to `bar'"),
                SWITCH, RC_TVAR_CHAR, RC_TVAR_ASSIGN, SEP, RC_TVAR_CHAR, RC_TVAR_ASSIGN,
                RC_TVAR_CHAR, RC_TVAR_CHAR);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXPORT_LOCAL_TVARS:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXPORT_LOCAL_TVARS, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Export local text variables from file to file"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DEBUG:
        sprintf(s1, "          %s", get_longopt_description (SYM_DEBUG, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Display some debug informations"));
        print_text (fp, s1);
        strcpy(s1, _("  [ARG]   = internal    Warnings if program internal maximums are reached"));
        print_text (fp, s1);
        strcpy(s1, _("          = handled     Like `internal' and file names which are handled"));
        print_text (fp, s1);
        strcpy(s1, _("          = unhandled   Like `internal' and file names which are unhandled"));
        print_text (fp, s1);
        strcpy(s1, _("          = all         Like `handled' and `unhandled' together"));
        print_text (fp, s1);
        strcpy(s1, _("          = abort       Like `all' and abort if file name can't be handled"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_TYPE_OF_CALENDAR:
        sprintf(s1, "%si[MOD]   %s", SWITCH, get_longopt_description (SYM_TYPE_OF_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Use special format for calendar sheet"));
        print_text (fp, s1);
        strcat(s1, _("  [MOD]   = -   Use standard format for calendar sheet"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_SUPPRESS_CALENDAR:
        sprintf(s1, "%su        %s", SWITCH, get_longopt_description (SYM_SUPPRESS_CALENDAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Suppress output of calendar sheet explicitly"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  if USE_PAGER
      case SYM_PAGER:
        sprintf(s1, "%sp        %s", SWITCH, get_longopt_description (SYM_PAGER, TRUE));
        print_text (fp, s1);
#    ifdef GCAL_EPAGER
        if (ext_pager != (char *)NULL)
          sprintf(s1, _("          Pass output thru external `%s' pager"),
                  (*ext_pager == *DIR_SEP) ? strrchr(ext_pager, *DIR_SEP)+1 : ext_pager);
        else
          strcpy(s1, _("          Pass output thru simple internal pager"));
#    else /* !GCAL_EPAGER */
        strcpy(s1, _("          Pass output thru simple internal pager"));
#    endif /* !GCAL_EPAGER */
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_DISABLE_HIGHLIGHTING:
        sprintf(s1, "%sH no     %s", SWITCH, get_longopt_description (SYM_DISABLE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=no",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, _("          Disable highlighting of text, holiday resp., actual day"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_FORCE_HIGHLIGHTING:
        sprintf(s1, "%sH yes    %s", SWITCH, get_longopt_description (SYM_FORCE_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s=yes",  get_longopt_description (SYM_HIGHLIGHTING, FALSE));
        print_text (fp, s1);
        strcpy(s1, _("          Forces highlighting sequences if output is redirected/piped"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HIGHLIGHTING:
        sprintf(s1, "%sH ARG    %s", SWITCH, get_longopt_description (SYM_HIGHLIGHTING, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Set highlighting sequence pairs 1 (=actual day) and 2 (=holiday)"));
        print_text (fp, s1);
        sprintf(s1, _("   ARG    = Highlighting sequence pairs separated by `%s' characters"),
                SEP);
        print_text (fp, s1);
        sprintf(s1, _("            e.g.  %sH \\x2%s\\xAE   Use hex values 2 and AE for sequence 1"),
                SWITCH, SEP);
        print_text (fp, s1);
        sprintf(s1, _("            e.g.  %sH %s%s*%s*      Use characters `*' and `*' for sequence 2"),
                SWITCH, SEP, SEP, SEP);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_BLOCKS:
        sprintf(s1, "%sb ARG    %s", SWITCH, get_longopt_description (SYM_BLOCKS, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Modify format of year calendar"));
        print_text (fp, s1);
        strcpy(s1, _("   ARG    = 1|2|3|4|6|12   Number of blocks"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_CALENDAR_DATES:
        sprintf(s1, "%sj[MOD]   %s", SWITCH, get_longopt_description (SYM_CALENDAR_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Use consecutive day of year in calendar sheet"));
        print_text (fp, s1);
        strcpy(s1, _("  [MOD]   = b   Use both date notations (day of month+year)"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_HOLIDAY_DATES:
        sprintf(s1, "%sjn[MOD]  %s", SWITCH, get_longopt_description (SYM_HOLIDAY_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Use consecutive day of year in eternal holiday list"));
        print_text (fp, s1);
        strcpy(s1, _("   [MOD]  = b   Use both date notations (day of month+year)"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#if USE_RC
      case SYM_FIXED_DATES:
        sprintf(s1, "%sjc[MOD]  %s", SWITCH, get_longopt_description (SYM_FIXED_DATES, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Use consecutive day of year in fixed date warning list"));
        print_text (fp, s1);
        strcpy(s1, _("   [MOD]  = b   Use both date notations (day of month+year)"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#endif
      case SYM_STARTING_DAY:
        sprintf(s1, "%ss ARG    %s", SWITCH, get_longopt_description (SYM_STARTING_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Set starting day of week"));
        print_text (fp, s1);
        if (use_short3_day_name)
          sprintf(s1, "   ARG    = 0|Today | %d|%s | %d|%s | ... | %d|%s",
                  DAY_MIN, short3_day_name (DAY_MIN),
                  DAY_MIN+1, short3_day_name (DAY_MIN+1),
                  DAY_MAX, short3_day_name (DAY_MAX));
        else
          sprintf(s1, "   ARG    = 0|Today | %d|%s | %d|%s | ... | %d|%s",
                  DAY_MIN, short_day_name (DAY_MIN),
                  DAY_MIN+1, short_day_name (DAY_MIN+1),
                  DAY_MAX, short_day_name (DAY_MAX));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  ifdef GCAL_EMAIL
      case SYM_MAIL:
        sprintf(s1, "%sm ARG    %s", SWITCH, get_longopt_description (SYM_MAIL, TRUE));
        print_text (fp, s1);
        sprintf(s1, _("          Send output via `%s' program to user"), MAIL_PRGR);
        print_text (fp, s1);
        strcpy(s1, _("   ARG    = Email Address"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
#  endif
      case SYM_HOLIDAY_LIST:
      case SYM_DESC_HOLIDAY_LIST:
        sprintf(s1, "%sn|N[MOD] %s", SWITCH, get_longopt_description (SYM_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_DESC_HOLIDAY_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, _("          Display eternal holiday list (Year in range: %d...%d)"),
                EASTER_MIN, EASTER_MAX);
        print_text (fp, s1);
        strcpy(s1, _(" n        = Legal days and memorial days"));
        print_text (fp, s1);
        strcpy(s1, _("   N      = Legal days only"));
        print_text (fp, s1);
        sprintf(s1, _("    [MOD] = %s   Descending sort order"), DES_LIT);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_HD_TITLE:
        sprintf(s1, "%sX        %s", SWITCH, get_longopt_description (SYM_EXCLUDE_HD_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Exclude title of eternal holiday list"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_CHRIST_HDY:
        sprintf(s1, "          %s", get_longopt_description (SYM_CHRIST_HDY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Provide eternal holiday list with Christian holidays"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_DE_HDY:
        sprintf(s1, "          %s", get_longopt_description (SYM_DE_HDY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Provide eternal holiday list with German holidays"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_US_HDY:
        sprintf(s1, "          %s", get_longopt_description (SYM_US_HDY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Provide eternal holiday list with U.S. American holidays"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_GREG_REFORM:
        sprintf(s1, "          %s", get_longopt_description (SYM_GREG_REFORM, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Set period of Gregorian Reformation"));
        print_text (fp, s1);
        sprintf(s1, _("          Actual respected period:  %d-%d %s %0*d"),
                greg->first_day, greg->last_day, short_month_name (greg->month),
                len_year_max, greg->year);
        print_text (fp, s1);
        do
         {
           sprintf(s1, _("   %-*d%*s = Set period to:  %d-%d %s %0*d"),
                   len_year_max, ptr_greg->year, 6-len_year_max, "",
                   ptr_greg->first_day, ptr_greg->last_day,
                   short_month_name (ptr_greg->month), len_year_max, ptr_greg->year);
           print_text (fp, s1);
         } while ((++ptr_greg)->year);   /* I don't like the GNU-coding scheme for do-whiles */
        sprintf(s1, _("   ARG    = %s%s%s%s%s%s%s   Set period explicitly"),
                yyyy_lit, GDATE_SEP, mm_lit, GDATE_SEP, dd_lit, GDATE_SEP, dd_lit);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_DATE_FORMAT:
        sprintf(s1, "          %s", get_longopt_description (SYM_DATE_FORMAT, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Set order of date elements using the ARG format text"));
        print_text (fp, s1);
        sprintf(s1, _("          Actual format:  (%s) `%s' (%s)"),
                (date_format->id==(char *)NULL) ? _("self-defined") : date_format->id,
                date_format->format, _(date_format->info));
        print_text (fp, s1);
        do
         {
           sprintf(s1, _("   %-6s = Set format to:  `%s' (%s)"), ptr_date_format->id,
                   ptr_date_format->format, _(ptr_date_format->info));
           print_text (fp, s1);
         } while ((++ptr_date_format)->id != (char *)NULL);   /* I don't like the GNU-coding scheme for do-whiles */
        strcpy(s1, _("   ARG    = Define personal format. Respected format elements are:"));
        print_text (fp, s1);
        do
         {
           if (*ptr_info_date_format->format == '\0')
             sprintf(s1, "               %s", _(ptr_info_date_format->info));
           else
             sprintf(s1, "            %-2s = %s", ptr_info_date_format->format, _(ptr_info_date_format->info));
           print_text (fp, s1);
         } while ((++ptr_info_date_format)->info != (char *)NULL);   /* I don't like the GNU-coding scheme for do-whiles */
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXIT_STAT_HELP_127:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXIT_STAT_HELP_127, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Set EXIT status of program to 127 on --help, --version etc."));
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
#  if USE_RC
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      sprintf(s1, _("+++ FIXED DATE WARNINGS +++"));
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_FIXED_DATES_LIST:
      case SYM_DESC_FIXED_DATES_LIST:
        sprintf(s1, "%sc|C[MOD] %s", SWITCH, get_longopt_description (SYM_FIXED_DATES_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_DESC_FIXED_DATES_LIST, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_TODAY, TRUE));
        print_text (fp, s1);
        sprintf(s1, _("          Use standard resource file `%s' for fixed dates list"),
                PRGR_RC_NAME);
        print_text (fp, s1);
        strcpy(s1, _("          Implies warning period:  Today"));
        print_text (fp, s1);
        strcpy(s1, _(" c        = Display only those dates, for which fixed dates exists"));
        print_text (fp, s1);
        strcpy(s1, _("   C      = Display those dates, for which fixed dates doesn't exit, too"));
        print_text (fp, s1);
        sprintf(s1, _("    [MOD] = %s   Descending sort order"), DES_LIT);
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, _("    [MOD] = One or more of the following modifiers which are marked by #"));
      print_text (fp, s1);
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_GROUPING_TEXT:
        sprintf(s1, "          %s", get_longopt_description (SYM_GROUPING_TEXT, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # g[MOD]       = Group fixed date warnings by day using text MOD"));
        print_text (fp, s1);
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, _("          1. Representation of text"));
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_INCLUDE_FILENAME:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_FILENAME, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # a            = Display origin of fixed date warning"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_ALTERNATIVE_FORMAT:
        sprintf(s1, "          %s", get_longopt_description (SYM_ALTERNATIVE_FORMAT, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # A            = Display using alternative list format"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_HOLIDAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_HOLIDAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # e            = Include legal days and memorial days"));
        print_text (fp, s1);
        strcpy(s1, _("          # E            = Include legal days only"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_WEEK_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_WEEK_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # k            = Display ISO week number"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_OMIT_DATE_PART:
        sprintf(s1, "          %s", get_longopt_description (SYM_OMIT_DATE_PART, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # o            = Omit repeating date part of fixed date warnings"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_EXCLUDE_RC_TITLE:
        sprintf(s1, "          %s", get_longopt_description (SYM_EXCLUDE_RC_TITLE, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # x            = Exclude title of fixed date warning list"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_CONS_NO:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_CONS_NO, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # z            = Display consecutive number of fixed date warnings"));
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      strcpy(s1, _("          2. Respected warning period"));
      print_text (fp, s1);
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_LEAP_DAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_LEAP_DAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("                         = Manage `29-FEBRUARY' in non-leap years"));
        print_text (fp, s1);
        strcpy(s1, _("                           ARG = february   Respect at `28-FEBRUARY'"));
        print_text (fp, s1);
        strcpy(s1, _("                           ARG = march      Respect at `01-MARCH'"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_INCLUDE_TODAY:
        sprintf(s1, "          %s", get_longopt_description (SYM_INCLUDE_TODAY, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # d            = Include actual date if list of periods is generated"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_LIST_MODE:
        sprintf(s1, "          %s", get_longopt_description (SYM_LIST_MODE, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # l            = Generate list of periods instead of a single period"));
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      default:
        ;   /* Void */
    }
   switch (longopt_symbolic)
    {
      case SYM_NIL:
      case SYM_PERIOD:
        sprintf(s1, "          %s", get_longopt_description (SYM_PERIOD, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # Nd           = Single absolute day N"));
        print_text (fp, s1);
        sprintf(s1, _("          # %cdN          = Single absolute day N"), RC_NWD_CHAR);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, _("          # NMOD         = Single day N relative to today"));
        print_text (fp, s1);
        sprintf(s1, _("             MOD           = %s   Forwards"), ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, _("                           = %s   Backwards"), DES_LIT);
        print_text (fp, s1);
        print_text (fp, s1);
        strcpy(s1, _("          # Nw           = Complete week N"));
        print_text (fp, s1);
        strcpy(s1, _("                           N = 0        1st week / last week of previous year"));
        print_text (fp, s1);
        strcpy(s1, _("                           N = 1...52   1st...52nd week (always)"));
        print_text (fp, s1);
        strcpy(s1, _("                           N = 53       53rd week (sometimes)"));
        print_text (fp, s1);
        strcpy(s1, _("                           N = 99       Last week"));
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # `%s%s'       = Single day `%s' of month `%s'"),
                mm_lit, dd_lit, dd_lit, mm_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # `%s%s'N     = Single N'th weekday `%s' of month `%s'"),
                mm_lit, www_lit, www_lit, mm_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 1...4   1st...4th weekday `%s' (always)"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 5       5th weekday `%s' (sometimes)"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 9       Last weekday `%s'"), www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # %cdN`%s'     = Single N'th weekday `%s'"),
                RC_NWD_CHAR, www_lit, www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 1...51   1st...51st weekday `%s' (always)"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 52|53    52|53rd weekday `%s' (sometimes)"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 99       Last weekday `%s'"), www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # %cwN`%s'     = Single weekday `%s' of N'th week"),
                RC_NWD_CHAR, www_lit, www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 0        `%s' which isn't located in 1st week"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 1...51   `%s' of 1st...51st week (always)"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 52|53    `%s' of 52|53rd week (sometimes)"), www_lit);
        print_text (fp, s1);
        sprintf(s1, _("                           N = 99       `%s' of last week"), www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # %ce[[%s|%s]N]   = Single day N relative to Easter Sunday"),
                RC_HDY_CHAR, ASC_LIT, DES_LIT);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # %ce[%s|%s]N`%s'= Single N'th weekday relative to Easter Sunday"),
                RC_HDY_CHAR, ASC_LIT, DES_LIT, www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # %cv[[%s|%s]N]   = Single day N relative to date variable"),
                RC_HDY_CHAR, ASC_LIT, DES_LIT);
        print_text (fp, s1);
        print_text (fp, s1);
        sprintf(s1, _("          # %cv[%s|%s]N`%s'= Single N'th weekday relative to date variable"),
                RC_HDY_CHAR, ASC_LIT, DES_LIT, www_lit);
        print_text (fp, s1);
        print_text (fp, s1);
      case SYM_TOMORROW:
        sprintf(s1, "          %s", get_longopt_description (SYM_TOMORROW, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # t|T          = List tomorrow"));
        print_text (fp, s1);
        if (longopt_symbolic == SYM_TOMORROW)
          break;
        print_text (fp, s1);
      case SYM_WEEK:
      case SYM_END_OF_WEEK:
      case SYM_START_OF_WEEK:
        sprintf(s1, "          %s", get_longopt_description (SYM_WEEK, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_END_OF_WEEK, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_START_OF_WEEK, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # w|W[MOD]     = List complete week"));
        print_text (fp, s1);
        sprintf(s1, _("               [MOD]       = %s   List tomorrow until ending day of week"),
                ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, _("                           = %s   List yesterday until starting day of week"),
                DES_LIT);
        print_text (fp, s1);
        if (   longopt_symbolic == SYM_WEEK
            || longopt_symbolic == SYM_END_OF_WEEK
            || longopt_symbolic == SYM_START_OF_WEEK)
          break;
        print_text (fp, s1);
      case SYM_MONTH:
      case SYM_END_OF_MONTH:
      case SYM_START_OF_MONTH:
        sprintf(s1, "          %s", get_longopt_description (SYM_MONTH, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_END_OF_MONTH, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_START_OF_MONTH, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # m|M[MOD]     = List complete month"));
        print_text (fp, s1);
        sprintf(s1, _("               [MOD]       = %s   List tomorrow until starting day of month"),
                ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, _("                           = %s   List yesterday until starting day of month"),
                DES_LIT);
        print_text (fp, s1);
        if (   longopt_symbolic == SYM_MONTH
            || longopt_symbolic == SYM_END_OF_MONTH
            || longopt_symbolic == SYM_START_OF_MONTH)
          break;
        print_text (fp, s1);
      case SYM_YEAR:
      case SYM_END_OF_YEAR:
      case SYM_START_OF_YEAR:
        sprintf(s1, "          %s", get_longopt_description (SYM_YEAR, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_END_OF_YEAR, TRUE));
        print_text (fp, s1);
        sprintf(s1, "          %s", get_longopt_description (SYM_START_OF_YEAR, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          # y|Y[MOD]     = List complete year"));
        print_text (fp, s1);
        sprintf(s1, _("               [MOD]       = %s   List tomorrow until starting day of year"),
                ASC_LIT);
        print_text (fp, s1);
        sprintf(s1, _("                           = %s   List yesterday until ending day of year"),
                DES_LIT);
        print_text (fp, s1);
        if (longopt_symbolic != SYM_NIL)
          break;
        print_text (fp, s1);
      case SYM_RESOURCE_FILE:
        sprintf(s1, "%sf|F ARG  %s", SWITCH, get_longopt_description (SYM_RESOURCE_FILE, TRUE));
        print_text (fp, s1);
        strcpy(s1, _("          Use alternative file(s) instead of standard resource file"));
        print_text (fp, s1);
        strcpy(s1, _("          Implies warning period:  Today"));
        print_text (fp, s1);
        strcpy(s1, _(" f        = Display only those dates, for which fixed dates exists"));
        print_text (fp, s1);
        strcpy(s1, _("   F      = Display those dates, for which fixed dates doesn't exit, too"));
        print_text (fp, s1);
        sprintf(s1, _("     ARG  = Single file or list of files separated by `%s' character"),
                RC_FNAME_SEP);
        print_text (fp, s1);
      default:
          ;   /* Void */
    }
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, _("%cDATE"), RC_ADATE_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, _("Use given `DATE' instead of todays date"));
      print_text (fp, s1);
      sprintf(s1, _("Date format:  `%s[%s[%s|%s[N]]]', `%s%c%c|dvar[[%s|%s]N[%s]]', `%s%cdN[%s]'"),
              yyyy_lit, mm_lit, dd_lit, www_lit, yyyy_lit, RC_HDY_CHAR, RC_EASTER_CHAR, ASC_LIT,
              DES_LIT, www_lit, yyyy_lit, RC_NWD_CHAR, www_lit);
      print_text (fp, s1);
      sprintf(s1, _("              `%s%cwN[%s]', `month name[%s]', `weekday name[N]' or `%s'"),
              yyyy_lit, RC_NWD_CHAR, www_lit, dd_lit, dd_lit);
      print_text (fp, s1);
    }
#  endif /* USE_RC */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      sprintf(s2, _("%cFILE"), RSP_CHAR);
      strcat(s1, s2);
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      strcpy(s1, _("Preload options and commands from `FILE'"));
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      if (print_hls)
        strcpy(s1, ehls2s.seq);
      strcat(s1, _("COMMAND"));
      if (print_hls)
        strcat(s1, ehls2e.seq);
      print_text (fp, s1);
      sprintf(s1, _("%s        = Month in range:  %d...%d"), mm_lit, MONTH_MIN, MONTH_MAX);
      print_text (fp, s1);
      sprintf(s1, _("                        or:  month name | %s | %s%s | %s%s | %s%s"),
              MONTH3_LIT, MONTH3_LIT, MONTH3_LIT, MONTH3_LIT, ASC_LIT, MONTH3_LIT, DES_LIT);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, _("            List:   %s[%s%s]%s...%s%s[%s%s]"),
              mm_lit, YEAR_SEP, yyyy_lit, MLIST_SEP, MLIST_SEP, mm_lit, YEAR_SEP, yyyy_lit);
      print_text (fp, s1);
      sprintf(s1, _("            Range:  %s[%s%s]%s%s[%s%s] | %s%s%s%s%s | %s %s%s%s"),
              mm_lit, YEAR_SEP, yyyy_lit, MRANGE_SEP, mm_lit, YEAR_SEP, yyyy_lit,
              mm_lit, YEAR_SEP, yyyy_lit, MRANGE_SEP, yyyy_lit,
              mm_lit, yyyy_lit, MRANGE_SEP, yyyy_lit);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, _("%s%*s    = Year  in range:  %d...%d"),
              yyyy_lit, 6-len_year_max, "", YEAR_MIN, YEAR_MAX);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, _("            List:   [%s%s]%s%s...%s[%s%s]%s"),
              mm_lit, FYEAR_SEP, yyyy_lit, YLIST_SEP, YLIST_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
      print_text (fp, s1);
      sprintf(s1, _("            Range:  [%s%s]%s%s[%s%s]%s"),
              mm_lit, FYEAR_SEP, yyyy_lit, YRANGE_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
      print_text (fp, s1);
      print_text (fp, s1);
      print_text (fp, s1);
      sprintf(s1, _("    +++ If you specify two digits for the year I DON'T ASSUME %2d%s +++"),
              act_year/100, yy_lit);
    }
#endif /* !USE_GER */
   if (longopt_symbolic == SYM_NIL)
    {
      print_text (fp, s1);
      my_help_tail_text (fp);
    }
}



   PUBLIC void
my_basic_help (fp)
   FILE *fp;
/*
   Prints the "basic help" text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' and `s2' internally.
*/
{
   my_help_head_text (fp);
#if USE_GER
   sprintf(s1, "%sh|hh   = Hilfetext; %sL = Lizenz; %sV = Version; %su = Kalender unterdr"UE"cken",
           SWITCH, SWITCH, SWITCH, SWITCH);
   print_text (fp, s1);
   sprintf(s1, "%si[-]   = Spezial-Kalenderformat; ", SWITCH);
#  if USE_PAGER
   sprintf(s2, "%sp = Paginierer; ", SWITCH);
   strcat(s1, s2);
#  endif
   sprintf(s2, "%sH yes = Mit Hervorhebungen", SWITCH);
   strcat(s1, s2);
   print_text (fp, s1);
   sprintf(s1, "%sb ARG  = Jahreskalender in 1|2|3|4|6|12 Bl"OE"cken; %sH no = Ohne Hervorhebungen",
           SWITCH, SWITCH);
   print_text (fp, s1);
   sprintf(s1, "%sj[]    = Fortlaufenden Tag des Jahres ausgeben (Modifizierer: [b n nb",
           SWITCH);
#  if USE_RC
   strcat(s1, " c cb])");
#  else /* !USE_RC */
   strcat(s1, "])");
#  endif /* !USE_RC */
   print_text (fp, s1);
   sprintf(s1, "%ss ARG  = Starttag der Woche (ARG = 0|Today | %d|%s | %d|%s | ... | %d|%s)",
           SWITCH, DAY_MIN, short_day_name (DAY_MIN), DAY_MIN+1, short_day_name (DAY_MIN+1),
           DAY_MAX, short_day_name (DAY_MAX));
   print_text (fp, s1);
   sprintf(s1, "%sn|N[%s] = Ewige Feiertagsliste ausgeben (Jahr im Bereich: %d...%d)",
           SWITCH, DES_LIT, EASTER_MIN, EASTER_MAX);
   print_text (fp, s1);
#  if USE_RC
   sprintf(s1, "%sc|C[]  = Terminliste aus Datei `%s'; %sf|F ARG[%sARG%s...]=Benutze Datei ARG",
           SWITCH, PRGR_RC_NAME, SWITCH, RC_FNAME_SEP, RC_FNAME_SEP);
   print_text (fp, s1);
   sprintf(s1, "    ^^--> [g[] | [%saAdeEkloxz][N[d|w|%s|%s]|`%s%s'|`%s%s'N|t|[w|m|y[%s|%s]]]]",
           DES_LIT, ASC_LIT, DES_LIT, mm_lit, dd_lit, mm_lit, www_lit, ASC_LIT, DES_LIT);
   print_text (fp, s1);
#  endif
   sprintf(s1, "%s   = Monat im Bereich: %d...%d               Liste:   %s[%s%s]%s...%s%s[%s%s]",
           mm_lit, MONTH_MIN, MONTH_MAX, mm_lit, YEAR_SEP, yyyy_lit, MLIST_SEP, MLIST_SEP, mm_lit,
           YEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, "                   oder: Monatsname|%s[%s|%s|%s]  Bereich: %s[%s%s]%s%s[%s%s]",
           MONTH3_LIT, MONTH3_LIT, ASC_LIT, DES_LIT, mm_lit, YEAR_SEP, yyyy_lit, MRANGE_SEP,
           mm_lit, YEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, "%s = Jahr  im Bereich: %d...%d%*s%*s         Liste:   [%s%s]%s%s...%s[%s%s]%s",
           yyyy_lit, YEAR_MIN, YEAR_MAX, 6-len_year_max, "", 6-len_year_max, "", mm_lit,
           FYEAR_SEP, yyyy_lit, YLIST_SEP, YLIST_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, "                                              Bereich: [%s%s]%s%s[%s%s]%s",
           mm_lit, FYEAR_SEP, yyyy_lit, YRANGE_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, "   +++ Bei zweistelliger Jahresangabe wird NICHT von %2d%s ausgegangen +++",
           act_year/100, yy_lit);
#else /* !USE_GER */
   sprintf(s1, _("%sh|hh   = Help screen; %sL = License; %sV = Version; %su = Suppress calendar sheet"),
           SWITCH, SWITCH, SWITCH, SWITCH);
   print_text (fp, s1);
   sprintf(s1, _("%si[-]   = Special calendar format; "), SWITCH);
#  if USE_PAGER
   sprintf(s2, _("%sp = Simple pager; "), SWITCH);
   strcat(s1, s2);
#  endif
   sprintf(s2, _("%sH yes = Use highlighting"), SWITCH);
   strcat(s1, s2);
   print_text (fp, s1);
   sprintf(s1, _("%sb ARG  = Year calendar with 1|2|3|4|6|12 blocks; %sH no = Disable highlighting"),
           SWITCH, SWITCH);
   print_text (fp, s1);
   sprintf(s1, _("%sj[]    = Output of consecutive day of year (Modifiers: [b n nb"),
           SWITCH);
#  if USE_RC
   strcat(s1, " c cb])");
#  else /* !USE_RC */
   strcat(s1, "])");
#  endif /* !USE_RC */
   print_text (fp, s1);
   if (use_short3_day_name)
     sprintf(s1, _("%ss ARG  = Starting day of week (ARG = 0|Today | %d|%s | %d|%s | ... | %d|%s)"),
             SWITCH, DAY_MIN, short3_day_name (DAY_MIN), DAY_MIN+1, short3_day_name (DAY_MIN+1),
             DAY_MAX, short3_day_name (DAY_MAX));
   else
     sprintf(s1, _("%ss ARG  = Starting day of week (ARG = 0|Today | %d|%s | %d|%s | ... | %d|%s)"),
             SWITCH, DAY_MIN, short_day_name (DAY_MIN), DAY_MIN+1, short_day_name (DAY_MIN+1),
             DAY_MAX, short_day_name (DAY_MAX));
   print_text (fp, s1);
   sprintf(s1, _("%sn|N[%s] = Display eternal holiday list (Year in range: %d...%d)"),
           SWITCH, DES_LIT, EASTER_MIN, EASTER_MAX);
   print_text (fp, s1);
#  if USE_RC
   sprintf(s1, _("%sc|C[]  = Fixed dates list of file `%s'; %sf|F ARG[%sARG%s...]=Use file ARG"),
           SWITCH, PRGR_RC_NAME, SWITCH, RC_FNAME_SEP, RC_FNAME_SEP);
   print_text (fp, s1);
   sprintf(s1, "    ^^--> [g[] | [%saAdeEkloxz][N[d|w|%s|%s]|`%s%s'|`%s%s'N|t|[w|m|y[%s|%s]]]]",
           DES_LIT, ASC_LIT, DES_LIT, mm_lit, dd_lit, mm_lit, www_lit, ASC_LIT, DES_LIT);
   print_text (fp, s1);
#  endif
   sprintf(s1, _("%s    = Month in range: %d...%d                 List:  %s[%s%s]%s...%s%s[%s%s]"),
           mm_lit, MONTH_MIN, MONTH_MAX, mm_lit, YEAR_SEP, yyyy_lit, MLIST_SEP, MLIST_SEP, mm_lit,
           YEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, _("                    or: month name|%s[%s|%s|%s]    Range: %s[%s%s]%s%s[%s%s]"),
           MONTH3_LIT, MONTH3_LIT, ASC_LIT, DES_LIT, mm_lit, YEAR_SEP, yyyy_lit, MRANGE_SEP,
           mm_lit, YEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, _("%s  = Year  in range: %d...%d%*s%*s           List:  [%s%s]%s%s...%s[%s%s]%s"),
           yyyy_lit, YEAR_MIN, YEAR_MAX, 6-len_year_max, "", 6-len_year_max, "", mm_lit,
           FYEAR_SEP, yyyy_lit, YLIST_SEP, YLIST_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, _("                                               Range: [%s%s]%s%s[%s%s]%s"),
           mm_lit, FYEAR_SEP, yyyy_lit, YRANGE_SEP, mm_lit, FYEAR_SEP, yyyy_lit);
   print_text (fp, s1);
   sprintf(s1, _("    +++ If you specify two digits for the year I DON'T assume %2d%s +++"),
           act_year/100, yy_lit);
#endif /* !USE_GER */
   my_help_tail_text (fp);
}



   PUBLIC void
my_license (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
/*
   Prints the program-id and the license text to file `fp' using the central
     output function `print_text()', uses global text buffer `s1' internally.
*/
{
   my_copyright (fp, prgr_id);
#if USE_GER
   strcpy(s1, "   Diese Software erhebt keinen Anspruch auf Vollst"AE"ndigkeit,");
   print_text (fp, s1);
   strcpy(s1, "   Verwendungsf"AE"higkeit oder Korrektheit. F"UE"r JEDWEDE Sch"AE"den oder");
   print_text (fp, s1);
   strcpy(s1, "   Verluste (implizit oder explizit), die aus Nutzung oder Handhabung");
   print_text (fp, s1);
   strcpy(s1, "   meiner Software hervorgehen, wird grunds"AE"tzlich keine Haftung");
   print_text (fp, s1);
   strcpy(s1, "   "UE"bernommen. Bei Verwendung dieser Software erkl"AE"rt sich der Benutzer");
   print_text (fp, s1);
   strcpy(s1, "   mit dieser Vereinbarung in vollem Umfang einverstanden.");
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   Dieses Programm ist freie Software; Sie k"OE"nnen es weitervertreiben");
   print_text (fp, s1);
   strcpy(s1, "   und/oder ver"AE"ndern innerhalb der Bestimmungen der `GNU General Public");
   print_text (fp, s1);
   strcpy(s1, "   License'; herausgegeben von der `Free Software Foundation';");
   print_text (fp, s1);
   strcpy(s1, "   in der Version 2 oder jeder sp"AE"teren Version.");
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   Sie sollten eine Kopie der `GNU General Public License' zusammen mit");
   print_text (fp, s1);
   strcpy(s1, "   diesem Programm erhalten haben; falls nicht, schreiben Sie an die:");
#else /* !USE_GER */
   strcpy(s1, _("   This software doesn't claim completeness, correctness or usability."));
   print_text (fp, s1);
   strcpy(s1, _("   On principle I will not be liable for ANY damages or losses (implicit"));
   print_text (fp, s1);
   strcpy(s1, _("   or explicit), which result from using or handling my software."));
   print_text (fp, s1);
   strcpy(s1, _("   If you use this software, you agree without any exception to this"));
   print_text (fp, s1);
   strcpy(s1, _("   agreement, which binds you LEGALLY !!"));
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, _("   This program is free software; you can redistribute it and/or modify"));
   print_text (fp, s1);
   strcpy(s1, _("   it under the terms of the `GNU General Public License' as published by"));
   print_text (fp, s1);
   strcpy(s1, _("   the `Free Software Foundation'; either version 2, or (at your option)"));
   print_text (fp, s1);
   strcpy(s1, _("   any later version."));
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, _("   You should have received a copy of the `GNU General Public License'"));
   print_text (fp, s1);
   strcpy(s1, _("   along with this program; if not, write to the:"));
#endif /* !USE_GER */
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "      Free Software Foundation, Inc.");
   print_text (fp, s1);
   strcpy(s1, "      59 Temple Place - Suite 330");
   print_text (fp, s1);
   strcpy(s1, "      Boston, MA 02111-1307,  USA");
   print_text (fp, s1);
}



   PUBLIC void
my_version (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
/*
   Prints the program-id and all compilation flags to file `fp' using the central
     output function `print_text()', uses global text buffer `s1' internally.
*/
{
   register int    i=0;
   auto     char  *ptr_env=(char *)NULL;


   my_copyright (fp, prgr_id);
   print_compiler_info (fp);
   print_text (fp, s1);
#if USE_GER
   strcpy(s1, "   Kompilations-Optionen:");
#else /* !USE_GER */
   strcpy(s1, _("   Compilation options:"));
#endif /* !USE_GER */
   print_text (fp, s1);
   strcpy(s1, "     ");
#ifdef GCAL_NLS
   strcat(s1, " NLS");
   i++;
#endif
#if USE_EASC
   strcat(s1, " USE_EASC");
   i++;
#endif
#if USE_GER
   strcat(s1, " USE_GER");
   i++;
#endif
#if USE_HLS
   strcat(s1, " USE_HLS");
   i++;
#endif
#if USE_PAGER
   strcat(s1, " USE_PAGER");
   i++;
#endif
#if USE_RC
   strcat(s1, " USE_RC");
   i++;
#endif
   if (i)
     print_text (fp, s1);
   sprintf(s1, "      GCAL_SYS_DATADIR=%s", GCAL_SYS_DATADIR);
   print_text (fp, s1);
#if !defined(AMIGA) || defined(__GNUC__)
   ptr_env = getenv(ENV_VAR_HOME);
   if (   *ptr_env
       && (ptr_env != (char *)NULL))
    {
      if (*(ptr_env+(strlen(ptr_env)-1)) == *DIR_SEP)
        sprintf(s1, "      GCAL_USR_DATADIR=%s%s", ptr_env, GCAL_USR_DATADIR);
      else
        sprintf(s1, "      GCAL_USR_DATADIR=%s%s%s", ptr_env, DIR_SEP, GCAL_USR_DATADIR);
    }
   else
     sprintf(s1, "      GCAL_USR_DATADIR=$%s%s%s", ENV_VAR_HOME, DIR_SEP, GCAL_USR_DATADIR);
#else /* AMIGA && !__GNUC__ */
   sprintf(s1, "      GCAL_USR_DATADIR=%s", GCAL_USR_DATADIR);
#endif /* AMIGA && !__GNUC__ */
   print_text (fp, s1);
#if USE_GER
   sprintf(s1, "      Gregorianische Reformation:  %d-%d %s %0*d", greg->first_day,
           greg->last_day, short_month_name (greg->month), len_year_max, greg->year);
#else /* !USE_GER */
   sprintf(s1, _("      Gregorian Reformation:  %d-%d %s %0*d"), greg->first_day,
           greg->last_day, short_month_name (greg->month), len_year_max, greg->year);
#endif /* !USE_GER */
   print_text (fp, s1);
#if USE_GER
   sprintf(s1, "      Datumformat:  (%s) `%s' (%s)",
           (date_format->id==(char *)NULL) ? "Selbstdefiniert" : date_format->id,
           date_format->format, date_format->info);
#else /* !USE_GER */
   sprintf(s1, _("      Date format:  (%s) `%s' (%s)"),
           (date_format->id==(char *)NULL) ? _("self-defined") : date_format->id,
           date_format->format, _(date_format->info));
#endif /* !USE_GER */
   print_text (fp, s1);
}



   PUBLIC char *
usage_msg ()
/*
   Creates the usage text `usage_text' and includes the actual program name.
*/
{
   static char  *usg_text;
   static Bool   is_initialized=FALSE;


   if (!is_initialized)
    {
      usg_text = (char *)my_malloc (120, 124, __FILE__, ((long)__LINE__)-1, "usg_text", 0);
#if USE_GER
      sprintf(usg_text, "Aufruf: %s [%s|%s{[h|hh|L|V]|{H R%s X b%s i j%s n%s s u%s}}]  [[%s] [%s]]",
              prgr_name, SWITCH, SWITCH2, USAGE_SHELL, USAGE_RC1, USAGE_MAIL, USAGE_PAGER,
              USAGE_RC2, mm_lit, yyyy_lit);
#else /* !USE_GER */
      sprintf(usg_text, _("Usage:  %s [%s|%s{[h|hh|L|V]|{H R%s X b%s i j%s n%s s u%s}}]  [[%s] [%s]]"),
              prgr_name, SWITCH, SWITCH2, USAGE_SHELL, USAGE_RC1, USAGE_MAIL, USAGE_PAGER,
              USAGE_RC2, mm_lit, yyyy_lit);
#endif /* !USE_GER */
      is_initialized = TRUE;
    }

   return usg_text;
}



   PUBLIC void
put_longopt_description (fp)
   FILE *fp;
/*
   Puts a description text of the long-style options to file `fp'.
*/
{
#if USE_GER
   fprintf(fp, "Benutze `%s %s' oder ",
           prgr_name, get_longopt_description (SYM_HELP, TRUE));
   fprintf(fp, "`%s %s|[%s?]' f"UE"r mehr Information.",
           prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE), LARG_SEP);
#else /* !USE_GER */
   fprintf(fp, _("Use `%s %s' or "),
           prgr_name, get_longopt_description (SYM_HELP, TRUE));
   fprintf(fp, _("`%s %s|[%s?]' for more information."),
           prgr_name, get_longopt_description (SYM_LONG_HELP2, TRUE), LARG_SEP);
#endif /* !USE_GER */
}



   LOCAL const char *
get_longopt_description (longopt_symbolic, with_larglist)
   const int  longopt_symbolic;
   const Bool with_larglist;
/*
   Returns a description text of given `longopt_symbolic' long-style option
     in global text buffer `s2'.  If `with_larglist' is TRUE, the returned
     description text contains the argument list text (if any) too, otherwise
     the returned description text contains the complete name of the long option only!
*/
{
   auto     const Lopt_struct  *ptr_lopt=lopt;
   register       int           i;


   while (ptr_lopt->long_name != NULL)
    {
      if (ptr_lopt->symbolic_name == longopt_symbolic)
        break;
      ptr_lopt++;
    }
   if (ptr_lopt->long_name != NULL)
    {
      i = 0;
      sprintf(s2, "%s%s%s", SWITCH, SWITCH, ptr_lopt->long_name);
      if (   with_larglist
          && (ptr_lopt->larg_mode != LARG_NO))
       {
         if (ptr_lopt->larg_mode == LARG_NO_OR_ONE)
           strcat(s2, "["LARG_SEP);
         else
           strcat(s2, LARG_SEP);
         if (   (ptr_lopt->larg_mode == LARG_ONE)
             && (ptr_lopt->largs[0] == NULL))
           strcat(s2, LARG_TXT);
         else
          {
            if (ptr_lopt->largs[0] == NULL)
              strcat(s2, LARG_TXT);
            else
              while (ptr_lopt->largs[i] != NULL)
               {
                 strcat(s2, ptr_lopt->largs[i]);
                 if (ptr_lopt->largs[i+1] != NULL)
                   strcat(s2, "|");
                 i++;
               }
          }
         if (ptr_lopt->larg_mode == LARG_NO_OR_ONE)
           strcat(s2, "]");
       }
    }
   else
     *s2 = '\0';

   return s2;
}



   LOCAL void
my_copyright (fp, prgr_id)
         FILE *fp;
   const char *prgr_id;
/*
   Prints the id and copyright text to file `fp' using the central output
     function `print_text()' and uses global text buffer `s1' internally.
*/
{
   strcpy(s1, prgr_id);
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, "   "COPYRIGHT_TXT);
   print_text (fp, s1);
   print_text (fp, s1);
}



   LOCAL void
my_help_head_text (fp)
   FILE *fp;
/*
   Prints the help header text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' and `s2' internally.
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   *s1 = '\0';
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, prgr_name);
   if (print_hls)
     strcat(s1, ehls2e.seq);
#if USE_GER
   sprintf(s2, ":%*s Das GNU Kalenderprogramm  (", 6-len_prgr_name, "");
#else /* !USE_GER */
   sprintf(s2, _(":%*s The GNU calendar program  ("), 6-len_prgr_name, "");
#endif /* !USE_GER */
   strcat(s1, s2);
   if (print_hls)
     strcat(s1, ehls2s.seq);
   strcat(s1, VERSION_NO);
   if (print_hls)
     strcat(s1, ehls2e.seq);
   strcat(s1, ")  "COPYRIGHT_TXT);
   print_text (fp, s1);
   print_text (fp, s1);
   strcpy(s1, usage_msg ());
   print_text (fp, s1);
   print_text (fp, s1);
}



   LOCAL void
my_help_tail_text (fp)
   FILE *fp;
/*
   Prints the help tail text to file `fp' using the central
     output function `print_text()' and uses global text buffer
     `s1' internally.
*/
{
   auto Bool  print_hls=(Bool)(is_tty&&highlight_flag&&!emu_hls);


   print_text (fp, s1);
   print_text (fp, s1);
#if USE_GER
   sprintf(s1, "`%s' ist `freie Software'     %*s", prgr_name, 6-len_prgr_name, "");
#else /* !USE_GER */
   sprintf(s1, _("`%s' is `free software'       %*s"), prgr_name, 6-len_prgr_name, "");
#endif /* !USE_GER */
   if (print_hls)
     strcat(s1, ehls2s.seq);
   strcat(s1, "\\\\\\_''/'");
   if (print_hls)
     strcat(s1, ehls2e.seq);
#if USE_GER
#  if USE_EASC
   strcat(s1, " ");
#  endif
   strcat(s1, "          Viel Spa"SZ" damit");
#else /* !USE_GER */
   strcat(s1, _("                     Enjoy"));
#endif /* !USE_GER */
   strcat(s1, "   =8^)");
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "---------------------------oOO    (/");
   if (print_hls)
    {
      strcat(s1, ehls2e.seq);
      strcat(s1, ehls1s.seq);
    }
   strcat(s1, "o");
   if (print_hls)
    {
      strcat(s1, ehls1e.seq);
      strcat(s1, ehls2s.seq);
    }
   strcat(s1, "-");
   if (print_hls)
    {
      strcat(s1, ehls2e.seq);
      strcat(s1, ehls1s.seq);
    }
   strcat(s1, "o");
   if (print_hls)
    {
      strcat(s1, ehls1e.seq);
      strcat(s1, ehls2s.seq);
    }
   strcat(s1, "\\)    OOo---------------------------");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "  Thomas Esken                o  (.  \"  .)"
          "  o   Internet :                 ");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "  Im Hagenfeld 84              \\___) ~ (__"
          "_/      (esken@uni-muenster.de)  ");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
   if (print_hls)
     strcpy(s1, ehls2s.seq);
   strcat(s1, "  D-48147 M\"unster; GERMANY               "
          "      Phone    : +49 251 232585  ");
   if (print_hls)
     strcat(s1, ehls2e.seq);
   print_text (fp, s1);
}



/*
   Writes an informational text to "fp" using the central output function
     showing the date, compiler and operating system used.  Uses global
     text buffer `s1' internally.  Code taken from `zip21' source package
     and adjusted to gcal's needs.
   Special thanks to the Info-ZIP group (http://quest.jpl.nasa.gov/Info-ZIP/),
     which merely granted the permission to use their `version_local()' function
     of `zip-2.1' in a modified way for Gcal (the `print_compiler_info()' function
     is based on copyrighted code by the Info-ZIP group).
*/
#if defined(MSDOS)
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
#if defined(__DJGPP__) || defined(__WATCOMC__) || \
    (defined(_MSC_VER) && (_MSC_VER != 800))
   char buf[80];
#endif


    sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
#  ifdef __DJGPP__
   (sprintf(buf, "djgpp v%d / gcc ", __DJGPP__), buf),
#  else
#    ifdef __GO32__           /* __GO32__ is defined as "1" only (sigh) */
   "djgpp v1.x / gcc ",
#    else
#      ifdef __EMX__            /* ...so is __EMX__ (double sigh) */
   "emx+gcc ",
#      else
   "gcc ",
#      endif
#    endif
#  endif
   __VERSION__,
#else
#  ifdef __WATCOMC__
#    if (__WATCOMC__ % 10 > 0)
/* We do this silly test because __WATCOMC__ gives two digits for the  */
/* minor version, but Watcom packaging prefers to show only one digit. */
   (sprintf(buf, "Watcom C/C++ %d.%02d", __WATCOMC__ / 100,
            __WATCOMC__ % 100), buf), "",
#    else
   (sprintf(buf, "Watcom C/C++ %d.%d", __WATCOMC__ / 100,
            (__WATCOMC__ % 100) / 10), buf), "",
#    endif
#  else
#    ifdef __TURBOC__
#      ifdef __BORLANDC__
   "Borland C++",
#        if (__BORLANDC__ < 0x0200)
   " 1.0",
#        else
#          if (__BORLANDC__ == 0x0200)   /* James:  __TURBOC__ = 0x0297 */
   " 2.0",
#          else
#            if (__BORLANDC__ == 0x0400)
   " 3.0",
#            else
#              if (__BORLANDC__ == 0x0410)   /* __BCPLUSPLUS__ = 0x0310 */
   " 3.1",
#              else
#                if (__BORLANDC__ == 0x0452)   /* __BCPLUSPLUS__ = 0x0320 */
#                  if USE_GER
   " 4.0 oder 4.02",
#                  else /* !USE_GER */
   _(" 4.0 or 4.02"),
#                  endif /* !USE_GER */
#                else
#                  if (__BORLANDC__ == 0x0460)   /* __BCPLUSPLUS__ = 0x0340 */
   " 4.5",
#                  else
#                    if (__BORLANDC__ == 0x0500)   /* __TURBOC__ = 0x0500 */
   " 5.0",
#                    else
#                      if USE_GER
   " neuer als 5.0",
#                      else /* !USE_GER */
   _(" later than 5.0"),
#                      endif /* !USE_GER */
#                    endif
#                  endif
#                endif
#              endif
#            endif
#          endif
#        endif
#      else
   "Turbo C",
#        if (__TURBOC__ >= 0x0400)     /* Kevin:  3.0 -> 0x0401 */
#          if USE_GER
   "++ 3.0 oder neuer",
#          else /* !USE_GER */
   _("++ 3.0 or later"),
#          endif /* !USE_GER */
#        else
#          if (__TURBOC__ == 0x0295)     /* [661] vfy'd by Kevin */
   "++ 1.0",
#          else
#            if ((__TURBOC__ >= 0x018d) && (__TURBOC__ <= 0x0200))  /* James: 0x0200 */
   " 2.0",
#            else
#              if (__TURBOC__ > 0x0100)
   " 1.5",                    /* James:  0x0105? */
#              else
   " 1.0",                    /* James:  0x0100 */
#              endif
#            endif
#          endif
#        endif
#      endif
#    else
#      ifdef MSC
   "Microsoft C ",
#        ifdef _MSC_VER
#          if (_MSC_VER == 800)
   "8.0/8.0c (Visual C++ 1.0/1.5)",
#          else
   (sprintf(buf, "%d.%02d", _MSC_VER/100, _MSC_VER%100), buf),
#          endif
#        else
#          if USE_GER
   "5.1 oder "AE"lter",
#          else /* !USE_GER */
   _("5.1 or earlier"),
#          endif /* !USE_GER */
#        endif
#      else
#        if USE_GER
   "unbekannter Kompilierer", "",
#        else /* !USE_GER */
   _("unknown compiler"), "",
#        endif /* !USE_GER */
#      endif /* MSC */
#    endif /* __TURBOC__ */
#  endif /* __WATCOMC__ */
#endif /* __GNUC__ */

   "MS-DOS",

#if (defined(__GNUC__) || (defined(__WATCOMC__) && defined(__386__)))
   " (32-bit)",
#else
#  if defined(M_I86HM) || defined(__HUGE__)
   " (16-bit, huge)",
#  else
#    if defined(M_I86LM) || defined(__LARGE__)
   " (16-bit, large)",
#    else
#      if defined(M_I86MM) || defined(__MEDIUM__)
   " (16-bit, medium)",
#      else
#        if defined(M_I86CM) || defined(__COMPACT__)
   " (16-bit, compact)",
#        else
#          if defined(M_I86SM) || defined(__SMALL__)
   " (16-bit, small)",
#          else
#            if defined(M_I86TM) || defined(__TINY__)
   " (16-bit, tiny)",
#            else
   " (16-bit)",
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#endif

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#else /* !MSDOS */
#  if defined(WIN32)
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
#if (defined(_MSC_VER) || defined(__WATCOMC__))
   char buf[80];
#endif


   sprintf(s1, _(*compiler_info),

#ifdef _MSC_VER  /* MSC == MSVC++, including the SDK compiler */
   (sprintf(buf, "Microsoft C %d.%02d ", _MSC_VER/100, _MSC_VER%100), buf),
#  if (_MSC_VER == 800)
   "(Visual C++ v1.1)",
#  else
#    if (_MSC_VER == 850)
   "(Windows NT v3.5 SDK)",
#    else
#      if (_MSC_VER == 900)
   "(Visual C++ v2.0/v2.1)",
#      else
#        if (_MSC_VER == 1000)
   "(Visual C++ v4.0)",
#        else
#          if (_MSC_VER == 1010)
   "(Visual C++ v4.1)",
#          else
#            if (_MSC_VER > 800)
   "(Visual C++)",
#            else
#              if USE_GER
   "(fehlerhafte Version)",
#              else /* !USE_GER */
   _("(bad version)"),
#              endif /* !USE_GER */
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#endif /* _MSC_VER */

#ifdef __WATCOMC__
#  if (__WATCOMC__ % 10 > 0)
/* We do this silly test because __WATCOMC__ gives two digits for the  */
/* minor version, but Watcom packaging prefers to show only one digit. */
   (sprintf(buf, "Watcom C/C++ %d.%02d", __WATCOMC__ / 100,
            __WATCOMC__ % 100), buf), "",
#  else
   (sprintf(buf, "Watcom C/C++ %d.%d", __WATCOMC__ / 100,
            (__WATCOMC__ % 100) / 10), buf), "",
#  endif /* __WATCOMC__ % 10 > 0 */
#endif /* __WATCOMC__ */

#ifdef __TURBOC__
#  ifdef __BORLANDC__
   "Borland C++",
#    if (__BORLANDC__ == 0x0452)   /* __BCPLUSPLUS__ = 0x0320 */
#      if USE_GER
   " 4.0 oder 4.02",
#      else /* !USE_GER */
   _(" 4.0 or 4.02"),
#      endif /* !USE_GER */
#    else
#      if (__BORLANDC__ == 0x0460)   /* __BCPLUSPLUS__ = 0x0340 */
   " 4.5",
#      else
#        if (__BORLANDC__ == 0x0500)   /* __TURBOC__ = 0x0500 */
   " 5.0",
#        else
#          if USE_GER
   " neuer als 5.0",
#          else /* !USE_GER */
   _(" later than 5.0"),
#          endif /* !USE_GER */
#        endif
#      endif
#    endif
#  else /* !__BORLANDC__ */
   "Turbo C",
#    if (__TURBOC__ >= 0x0400)     /* Kevin:  3.0 -> 0x0401 */
#      if USE_GER
   "++ 3.0 oder neuer",
#      else /* !USE_GER */
   _("++ 3.0 or later"),
#      endif /* !USE_GER */
#    else
#      if (__TURBOC__ == 0x0295)     /* [661] vfy'd by Kevin */
   "++ 1.0",
#      endif
#    endif
#  endif /* __BORLANDC__ */
#endif /* __TURBOC__ */

#if !defined(__TURBOC__) && !defined(__WATCOMC__) && !defined(_MSC_VER)
#  if USE_GER
   "unbekannter Kompilierer (SDK?)", "",
#  else /* !USE_GER */
   _("unknown compiler (SDK?)"), "",
#  endif /* !USE_GER */
#endif

   "\n\tWindows 95 / Windows NT", " (32-bit)",

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#  else /* !WIN32 */
#    if defined(OS2)
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
#if defined(__IBMC__) || defined(__WATCOMC__) || defined(_MSC_VER)
   char buf[80];
#endif


   sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
#  ifdef __EMX__  /* __EMX__ is defined as "1" only (sigh) */
   "emx+gcc ", __VERSION__,
#  else
   "gcc/2 ", __VERSION__,
#  endif
#else
#  ifdef __IBMC__
   "IBM ",
#    if (__IBMC__ < 200)
   (sprintf(buf, "C Set/2 %d.%02d", __IBMC__/100,__IBMC__%100), buf),
#    else
#      if (__IBMC__ < 300)
   (sprintf(buf, "C Set++ %d.%02d", __IBMC__/100,__IBMC__%100), buf),
#      else
   (sprintf(buf, "Visual Age C++ %d.%02d", __IBMC__/100,__IBMC__%100), buf),
#      endif
#    endif
#  else
#    ifdef __WATCOMC__
   "Watcom C", (sprintf(buf, " (__WATCOMC__ = %d)", __WATCOMC__), buf),
#    else
#      ifdef __TURBOC__
#        ifdef __BORLANDC__
   "Borland C++",
#          if (__BORLANDC__ < 0x0200)
   " 1.0",
#          else
#            if (__BORLANDC__ == 0x0200)
   " 2.0",
#            else
#              if (__BORLANDC__ == 0x0400)
   " 3.0",
#              else
#                if (__BORLANDC__ == 0x0410)
   " 3.1",
#                else
#                  if (__BORLANDC__ == 0x0452)
   " 4.0",
#                  else                    /* these two are guesses based on DOS version */
#                    if (__BORLANDC__ == 0x0460)
   " 4.5",
#                    else
#                      if USE_GER
   " neuer als 4.5",
#                      else /* !USE_GER */
   _(" later than 4.5"),
#                      endif /* !USE_GER */
#                    endif
#                  endif
#                endif
#              endif
#            endif
#          endif
#        else
   "Turbo C",
#          if (__TURBOC__ >= 661)
#            if USE_GER
   "++ 1.0 oder neuer",
#            else /* USE_GER */
   _("++ 1.0 or later"),
#            endif /* USE_GER */
#          else
#            if (__TURBOC__ == 661)
   " 3.0?",
#            else
#              if (__TURBOC__ == 397)
   " 2.0",
#              else
#                if USE_GER
   " 1.0 oder 1.5?",
#                else /* !USE_GER */
   _(" 1.0 or 1.5?"),
#                endif /* !USE_GER */
#              endif
#            endif
#          endif
#        endif
#      else
#        ifdef MSC
   "Microsoft C ",
#          ifdef _MSC_VER
   (sprintf(buf, "%d.%02d", _MSC_VER/100, _MSC_VER%100), buf),
#          else
#            if USE_GER
   "5.1 oder "AE"lter",
#            else /* !USE_GER */
   _("5.1 or earlier"),
#            endif /* !USE_GER */
#          endif
#        else
#          if USE_GER
   "unbekannter Kompilierer", "",
#          else /* !USE_GER */
   _("unknown compiler"), "",
#          endif /* !USE_GER */
#        endif /* MSC */
#      endif /* __TURBOC__ */
#    endif /* __WATCOMC__ */
#  endif /* __IBMC__ */
#endif /* __GNUC__ */

   "OS/2",

/* GRR:  does IBM C/2 identify itself as IBM rather than Microsoft? */
#if (defined(MSC) || (defined(__WATCOMC__) && !defined(__386__)))
#  if defined(M_I86HM) || defined(__HUGE__)
   " (16-bit, huge)",
#  else
#    if defined(M_I86LM) || defined(__LARGE__)
   " (16-bit, large)",
#    else
#      if defined(M_I86MM) || defined(__MEDIUM__)
   " (16-bit, medium)",
#      else
#        if defined(M_I86CM) || defined(__COMPACT__)
   " (16-bit, compact)",
#        else
#          if defined(M_I86SM) || defined(__SMALL__)
   " (16-bit, small)",
#          else
#            if defined(M_I86TM) || defined(__TINY__)
   " (16-bit, tiny)",
#            else
   " (16-bit)",
#            endif
#          endif
#        endif
#      endif
#    endif
#  endif
#else
   " 2.x (32-bit)",
#endif

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#    else /* !OS2 */
#      if defined(ACORN)
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
   sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
#  ifdef __CC_NORCROFT
   "Norcroft ", "cc",
#  else
   "cc", "",
#  endif
#endif

   "RISC OS",

   " (Acorn Computers Ltd)",

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#      else /* !ACORN */
#        if defined(AMIGA)

/* NOTE:  the following include depends upon the environment
 *        variable $Workbench to be set correctly.  (Set by
 *        default, by kickstart during startup)
 */
int WBversion = (int)
#include "ENV:Workbench"
;

   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
/* Define buffers. */

   char buf1[16];  /* compiler name */
   char buf2[16];  /* revstamp */
   char buf3[16];  /* OS */
   char buf4[16];  /* Date */

/* format "with" name strings */

#ifdef __SASC
   strcpy(buf1, "SAS/C ");
#else
#  ifdef LATTICE
   strcpy(buf1, "Lattice C ");
#  else
#    ifdef AZTEC_C
   strcpy(buf1, "Manx Aztec C ");
#    else
#      if USE_GER
   strcpy(buf1, "unbekannt ");
#      else /* !USE_GER */
   strcpy(buf1, _("unknown "));
#      endif /* !USE_GER */
#    endif
#  endif
#endif
/* "under" */
   sprintf(buf3, "AmigaDOS v%d", WBversion);

/* Define revision, date, and time strings.
 * NOTE:  Do not calculate run time, be sure to use time compiled.
 * Pass these strings via your makefile if undefined.
 */

#if defined(__VERSION__) && defined(__REVISION__)
#  if USE_GER
   sprintf(buf2, "Version %d.%d", __VERSION__, __REVISION__);
#  else /* !USE_GER */
   sprintf(buf2, _("version %d.%d"), __VERSION__, __REVISION__);
#  endif /* !USE_GER */
#else
#  ifdef __VERSION__
#    if USE_GER
   sprintf(buf2, "Version %d", __VERSION__);
#    else /* !USE_GER */
   sprintf(buf2, _("version %d"), __VERSION__);
#    endif /* !USE_GER */
#  else
#    if USE_GER
   sprintf(buf2, "unbekannte Version");
#    else /* !USE_GER */
   sprintf(buf2, _("unknown version"));
#    endif /* !USE_GER */
#  endif
#endif

#ifdef __DATE__
#  if USE_GER
   sprintf(buf4, " am %s", __DATE__);
#  else /* !USE_GER */
   sprintf(buf4, _(" on %s"), __DATE__);
#  endif /* !USE_GER */
#else
#  if USE_GER
   strcpy(buf4, " unbekanntes Datum");
#  else /* !USE_GER */
   strcpy(buf4, _(" unknown date"));
#  endif /* !USE_GER */
#endif

   sprintf(s1, _(*compiler_info), buf1, buf2, buf3, buf4, "", "");

   print_text (fp, s1);
}
#        else /* !AMIGA */
#          if defined(ATARI)
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
#ifdef __TURBOC__
   char buf[40];
#endif

   sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
#  if 0
#    if USE_GER
   "cc ", (sprintf(buf, "Version %d", _RELEASE), buf),
#    else /* !USE_GER */
   "cc ", (sprintf(buf, _("version %d"), _RELEASE), buf),
#    endif /* !USE_GER */
#  else
#    ifdef __TURBOC__
   "Turbo C", (sprintf(buf, " (0x%04x = %d)", __TURBOC__, __TURBOC__), buf),
#    else
#      if USE_GER
   "unbekannter Kompilierer", "",
#      else /* !USE_GER */
   _("unknown compiler"), "",
#      endif /* !USE_GER */
#    endif
#  endif
#endif

#ifdef __MINT__
   "Atari TOS/MiNT",
#else
   "Atari TOS",
#endif

   " (Atari ST/TT/Falcon030)",

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#          else /* !ATARI */
#            if defined(__50SERIES)   /* Prime/PRIMOS */
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
   sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
   "cc", "",
#endif

   "PRIMOS",

   " (Prime Computer Inc)",

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#            else /* !__50SERIES */
#              if defined(VAXC) || defined(VMS)   /* DEC Vax */
   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
#ifdef VMS_VERSION
   char buf[40];
#endif
#ifdef __DECC_VER
   char buf2[40];
   int  vtyp;
#endif

/*  DEC C in ANSI mode does not like "#ifdef MACRO" inside another
    macro when MACRO is equated to a value (by "#define MACRO 1").   */

   sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
   "gcc ", __VERSION__,
#else
#  if defined(DECC) || defined(__DECC) || defined (__DECC__)
   "DEC C",
#    ifdef __DECC_VER
   (sprintf(buf2, " %c%d.%d-%03d",
            ((vtyp = (__DECC_VER / 10000) % 10) == 6 ? 'T' :
             (vtyp == 8 ? 'S' : 'V')),
            __DECC_VER / 10000000,
            (__DECC_VER % 10000000) / 100000, __DECC_VER % 1000), buf2),
#    else
   "",
#    endif
#  else
#    ifdef VAXC
   "VAX C", "",
#    else
#      if USE_GER
   "unbekannter Kompilierer", "",
#      else /* !USE_GER */
   _("unknown compiler"), "",
#      endif /* !USE_GER */
#    endif
#  endif
#endif

#ifdef VMS_VERSION
#  if defined(__alpha)
   "OpenVMS",   /* version has trailing spaces ("V6.1   "), so truncate: */
#    if USE_GER
   (sprintf(buf, " (%.4s f"UE"r Alpha)", VMS_VERSION), buf),
#    else /* !USE_GER */
   (sprintf(buf, _(" (%.4s for Alpha)"), VMS_VERSION), buf),
#    endif /* !USE_GER */
#  else /* VAX */
   (VMS_VERSION[1] >= '6')? "OpenVMS" : "VMS",
#    if USE_GER
   (sprintf(buf, " (%.4s f"UE"r VAX)", VMS_VERSION), buf),
#    else /* !USE_GER */
   (sprintf(buf, _(" (%.4s for VAX)"), VMS_VERSION), buf),
#    endif /* !USE_GER */
#  endif
#else
   "VMS", "",
#endif /* ?VMS_VERSION */

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#              else /* default: UNIX */
#if defined(__NetBSD__) || defined(__FreeBSD__) || defined(__386BSD__) || \
    defined(__bsdi__)
#include <sys/param.h> /* for the BSD4_4 define */
#endif

   LOCAL void
print_compiler_info (fp)
   FILE *fp;
{
#if defined(CRAY) || defined(NX_CURRENT_COMPILER_RELEASE) || defined(NetBSD)
   char buf1[40];
#  if defined(CRAY) || defined(NX_CURRENT_COMPILER_RELEASE)
   char buf2[40];
#  endif
#endif

    /* Pyramid, NeXT have problems with huge macro expansion, too:  no Info() */
    sprintf(s1, _(*compiler_info),

#ifdef __GNUC__
#  ifdef NX_CURRENT_COMPILER_RELEASE
   (sprintf(buf1, "NeXT DevKit %d.%02d ", NX_CURRENT_COMPILER_RELEASE/100,
    NX_CURRENT_COMPILER_RELEASE%100), buf1),
    (strlen(__VERSION__) > 8)? "(gcc)" :
     (sprintf(buf2, "(gcc %s)", __VERSION__), buf2),
#  else
   "gcc ", __VERSION__,
#  endif
#else
#  if defined(CRAY) && defined(_RELEASE)
#    if USE_GER
   "cc ", (sprintf(buf1, "Version %d", _RELEASE), buf1),
#    else /* !USE_GER */
   "cc ", (sprintf(buf1, _("version %d"), _RELEASE), buf1),
#    endif /* !USE_GER */
#  else
#    ifdef __VERSION__
   "cc ", __VERSION__,
#    else
   "cc", "",
#    endif
#  endif
#endif

   "Unix",

#if defined(sgi) || defined(__sgi)
   " (Silicon Graphics IRIX)",
#else
#  ifdef sun
#    ifdef sparc
#      ifdef __SVR4
   " (Sun Sparc/Solaris)",
#      else /* may or may not be SunOS */
   " (Sun Sparc)",
#      endif
#    else
#      if defined(sun386) || defined(i386)
   " (Sun 386i)",
#      else
#        if defined(mc68020) || defined(__mc68020__)
   " (Sun 3)",
#        else /* mc68010 or mc68000:  Sun 2 or earlier */
   " (Sun 2)",
#        endif
#      endif
#    endif
#  else
#    ifdef __hpux
   " (HP/UX)",
#    else
#      ifdef __osf__
   " (DEC OSF/1)",
#      else
#        ifdef _AIX
   " (IBM AIX)",
#        else
#          ifdef aiws
   " (IBM RT/AIX)",
#          else
#            if defined(CRAY) || defined(cray)
#              ifdef _UNICOS
   (sprintf(buf2, " (Cray UNICOS release %d)", _UNICOS), buf2),
#              else
   " (Cray UNICOS)",
#              endif
#            else
#              if defined(uts) || defined(UTS)
   " (Amdahl UTS)",
#              else
#                ifdef NeXT
#                  ifdef mc68000
   " (NeXTStep/black)",
#                  else
   " (NeXTStep for Intel)",
#                  endif
#                else              /* the next dozen or so are somewhat order-dependent */
#                  if defined(linux) || defined(__linux__)
#                    ifdef __ELF__
   " (Linux ELF)",
#                    else
   " (Linux a.out)",
#                    endif
#                  else
#                    ifdef MINIX
   " (Minix)",
#                    else
#                      ifdef M_UNIX
   " (SCO Unix)",
#                      else
#                        ifdef M_XENIX
   " (SCO Xenix)",
#                        else
#                          ifdef __NetBSD__
#                            ifdef NetBSD0_8
#                              if NetBSD0_8 == 1
   " (NetBSD 0.8)",
#                              else
   (sprintf(buf1, " (NetBSD 0.8%c)", (char) (NetBSD0_8 + '@')), buf1),
#                              endif
#                            else
#                              ifdef NetBSD0_9
#                                if NetBSD0_9 == 1
   " (NetBSD 0.9)",
#                                else
   (sprintf(buf1, " (NetBSD 0.9%c)", (char)(NetBSD0_9 + 'A' - 2)), buf1),
#                                endif
#                              else
#                                ifdef NetBSD1_0
#                                  if NetBSD1_0 == 1
   " (NetBSD 1.0)",
#                                  else
   (sprintf(buf1, " (NetBSD 1.0%c)", (char)(NetBSD1_0 + 'A' - 2)), buf1),
#                                  endif
#                                else
#                                  ifdef NetBSD1_1
#                                    if NetBSD1_1 == 1
   " (NetBSD 1.1)",
#                                    else
   (sprintf(buf1, " (NetBSD 1.1%c)", (char)(NetBSD1_1 + 'A' - 2)), buf1),
#                                    endif
#                                  else
#                                    if USE_GER
   (BSD4_4 == 0.5)? " (NetBSD vor 0.9)" : " (NetBSD 1.2 oder neuer)",
#                                    else /* !USE_GER */
   (BSD4_4 == 0.5)? _(" (NetBSD before 0.9)") : _(" (NetBSD 1.2 or later)"),
#                                    endif /* !USE_GER */
#                                  endif
#                                endif
#                              endif
#                            endif
#                          else
#                            ifdef __FreeBSD__
#                              if USE_GER
   (BSD4_4 == 0.5)? " (FreeBSD 1.x)" : " (FreeBSD 2.0 oder neuer)",
#                              else /* !USE_GER */
   (BSD4_4 == 0.5)? " (FreeBSD 1.x)" : _(" (FreeBSD 2.0 or later)"),
#                              endif /* !USE_GER */
#                            else
#                              ifdef __bsdi__
#                                if USE_GER
   (BSD4_4 == 0.5)? " (BSD/386 1.0)" : " (BSD/386 1.1 oder neuer)",
#                                else /* !USE_GER */
   (BSD4_4 == 0.5)? " (BSD/386 1.0)" : _(" (BSD/386 1.1 or later)"),
#                                endif /* !USE_GER */
#                              else
#                                ifdef __386BSD__
   (BSD4_4 == 1)? " (386BSD, post-4.4 release)" : " (386BSD)",
#                                else
#                                  if defined(i486) || defined(__i486) || defined(__i486__)
   " (Intel 486)",
#                                  else
#                                    if defined(i386) || defined(__i386) || defined(__i386__)
   " (Intel 386)",
#                                    else
#                                      ifdef pyr
   " (Pyramid)",
#                                      else
#                                        if defined(ultrix) || defined(__ultrix)
#                                          if defined(mips) || defined(__mips)
   " (DEC/MIPS)",
#                                          else
#                                            if defined(vax) || defined(__vax)
   " (DEC/VAX)",
#                                            else /* __alpha? */
   " (DEC/Alpha)",
#                                            endif
#                                          endif
#                                        else
#                                          ifdef gould
   " (Gould)",
#                                          else
#                                            ifdef MTS
   " (MTS)",
#                                            else
#                                              ifdef __convexc__
   " (Convex)",
#                                              else
   "",
#                                              endif /* Convex */
#                                            endif /* MTS */
#                                          endif /* Gould */
#                                        endif /* DEC */
#                                      endif /* Pyramid */
#                                    endif /* 386 */
#                                  endif /* 486 */
#                                endif /* 386BSD */
#                              endif /* BSDI BSD/386 */
#                            endif /* NetBSD */
#                          endif /* FreeBSD */
#                        endif /* SCO Xenix */
#                      endif /* SCO Unix */
#                    endif /* Minix */
#                  endif /* Linux */
#                endif /* NeXT */
#              endif /* Amdahl */
#            endif /* Cray */
#          endif /* RT/AIX */
#        endif /* AIX */
#      endif /* OSF/1 */
#    endif /* HP/UX */
#  endif /* Sun */
#endif /* SGI */

#ifdef __DATE__
#  if USE_GER
   " am ", __DATE__
#  else /* !USE_GER */
   _(" on "), __DATE__
#  endif /* !USE_GER */
#else
   "", ""
#endif
   );

   print_text (fp, s1);
}
#              endif /* default: UNIX */
#            endif /* !__50SERIES */
#          endif /* !ATARI */
#        endif /* !AMIGA */
#      endif /* !ACORN */
#    endif /* !OS2 */
#  endif /* !WIN32 */
#endif /* !MSDOS */
