#ifndef	_startup_user_
#define	_startup_user_

/* Module startup */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine startup_essential_task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __startup_essential_task
#if	defined(LINTLIBRARY)
    (server, task, excpt, name, credential)
	startup_t server;
	mach_port_t task;
	mach_port_t excpt;
	string_t name;
	mach_port_t credential;
{ return __startup_essential_task(server, task, excpt, name, credential); }
#else
(
	startup_t server,
	mach_port_t task,
	mach_port_t excpt,
	string_t name,
	mach_port_t credential
);
#endif

/* Routine startup_request_notification */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __startup_request_notification
#if	defined(LINTLIBRARY)
    (server, notify_port, notify_portPoly, name)
	startup_t server;
	mach_port_t notify_port;
	mach_msg_type_name_t notify_portPoly;
	string_t name;
{ return __startup_request_notification(server, notify_port, notify_portPoly, name); }
#else
(
	startup_t server,
	mach_port_t notify_port,
	mach_msg_type_name_t notify_portPoly,
	string_t name
);
#endif

/* Routine startup_reboot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __startup_reboot
#if	defined(LINTLIBRARY)
    (server, refport, reboot_code)
	startup_t server;
	mach_port_t refport;
	int reboot_code;
{ return __startup_reboot(server, refport, reboot_code); }
#else
(
	startup_t server,
	mach_port_t refport,
	int reboot_code
);
#endif

/* Routine startup_procinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __startup_procinit
#if	defined(LINTLIBRARY)
    (server, startup_proc, startup_task, auth, host_priv, device_master)
	startup_t server;
	process_t startup_proc;
	mach_port_t *startup_task;
	auth_t *auth;
	mach_port_t *host_priv;
	mach_port_t *device_master;
{ return __startup_procinit(server, startup_proc, startup_task, auth, host_priv, device_master); }
#else
(
	startup_t server,
	process_t startup_proc,
	mach_port_t *startup_task,
	auth_t *auth,
	mach_port_t *host_priv,
	mach_port_t *device_master
);
#endif

/* Routine startup_authinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __startup_authinit
#if	defined(LINTLIBRARY)
    (server, auth, authPoly, proc)
	startup_t server;
	mach_port_t auth;
	mach_msg_type_name_t authPoly;
	mach_port_t *proc;
{ return __startup_authinit(server, auth, authPoly, proc); }
#else
(
	startup_t server,
	mach_port_t auth,
	mach_msg_type_name_t authPoly,
	mach_port_t *proc
);
#endif


/* Module startup */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine startup_essential_task */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_essential_task
#if	defined(LINTLIBRARY)
    (server, task, excpt, name, credential)
	startup_t server;
	mach_port_t task;
	mach_port_t excpt;
	string_t name;
	mach_port_t credential;
{ return startup_essential_task(server, task, excpt, name, credential); }
#else
(
	startup_t server,
	mach_port_t task,
	mach_port_t excpt,
	string_t name,
	mach_port_t credential
);
#endif

/* Routine startup_request_notification */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_request_notification
#if	defined(LINTLIBRARY)
    (server, notify_port, notify_portPoly, name)
	startup_t server;
	mach_port_t notify_port;
	mach_msg_type_name_t notify_portPoly;
	string_t name;
{ return startup_request_notification(server, notify_port, notify_portPoly, name); }
#else
(
	startup_t server,
	mach_port_t notify_port,
	mach_msg_type_name_t notify_portPoly,
	string_t name
);
#endif

/* Routine startup_reboot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_reboot
#if	defined(LINTLIBRARY)
    (server, refport, reboot_code)
	startup_t server;
	mach_port_t refport;
	int reboot_code;
{ return startup_reboot(server, refport, reboot_code); }
#else
(
	startup_t server,
	mach_port_t refport,
	int reboot_code
);
#endif

/* Routine startup_procinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_procinit
#if	defined(LINTLIBRARY)
    (server, startup_proc, startup_task, auth, host_priv, device_master)
	startup_t server;
	process_t startup_proc;
	mach_port_t *startup_task;
	auth_t *auth;
	mach_port_t *host_priv;
	mach_port_t *device_master;
{ return startup_procinit(server, startup_proc, startup_task, auth, host_priv, device_master); }
#else
(
	startup_t server,
	process_t startup_proc,
	mach_port_t *startup_task,
	auth_t *auth,
	mach_port_t *host_priv,
	mach_port_t *device_master
);
#endif

/* Routine startup_authinit */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_authinit
#if	defined(LINTLIBRARY)
    (server, auth, authPoly, proc)
	startup_t server;
	mach_port_t auth;
	mach_msg_type_name_t authPoly;
	mach_port_t *proc;
{ return startup_authinit(server, auth, authPoly, proc); }
#else
(
	startup_t server,
	mach_port_t auth,
	mach_msg_type_name_t authPoly,
	mach_port_t *proc
);
#endif

#endif	/* not defined(_startup_user_) */
