#ifndef	_fsys_user_
#define	_fsys_user_

/* Module fsys */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine fsys_startup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_startup
#if	defined(LINTLIBRARY)
    (bootstrap, openflags, control_port, control_portPoly, realnode)
	mach_port_t bootstrap;
	int openflags;
	mach_port_t control_port;
	mach_msg_type_name_t control_portPoly;
	mach_port_t *realnode;
{ return __fsys_startup(bootstrap, openflags, control_port, control_portPoly, realnode); }
#else
(
	mach_port_t bootstrap,
	int openflags,
	mach_port_t control_port,
	mach_msg_type_name_t control_portPoly,
	mach_port_t *realnode
);
#endif

/* Routine fsys_goaway */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_goaway
#if	defined(LINTLIBRARY)
    (fsys, flags)
	fsys_t fsys;
	int flags;
{ return __fsys_goaway(fsys, flags); }
#else
(
	fsys_t fsys,
	int flags
);
#endif

/* Routine fsys_getroot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_getroot
#if	defined(LINTLIBRARY)
    (fsys, dotdot_node, dotdot_nodePoly, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, flags, do_retry, retry_name, file)
	fsys_t fsys;
	mach_port_t dotdot_node;
	mach_msg_type_name_t dotdot_nodePoly;
	idarray_t gen_uids;
	mach_msg_type_number_t gen_uidsCnt;
	idarray_t gen_gids;
	mach_msg_type_number_t gen_gidsCnt;
	int flags;
	retry_type *do_retry;
	string_t retry_name;
	mach_port_t *file;
{ return __fsys_getroot(fsys, dotdot_node, dotdot_nodePoly, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, flags, do_retry, retry_name, file); }
#else
(
	fsys_t fsys,
	mach_port_t dotdot_node,
	mach_msg_type_name_t dotdot_nodePoly,
	idarray_t gen_uids,
	mach_msg_type_number_t gen_uidsCnt,
	idarray_t gen_gids,
	mach_msg_type_number_t gen_gidsCnt,
	int flags,
	retry_type *do_retry,
	string_t retry_name,
	mach_port_t *file
);
#endif

/* Routine fsys_getfile */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_getfile
#if	defined(LINTLIBRARY)
    (fsys, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, filehandle, filehandleCnt, file)
	fsys_t fsys;
	idarray_t gen_uids;
	mach_msg_type_number_t gen_uidsCnt;
	idarray_t gen_gids;
	mach_msg_type_number_t gen_gidsCnt;
	data_t filehandle;
	mach_msg_type_number_t filehandleCnt;
	mach_port_t *file;
{ return __fsys_getfile(fsys, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, filehandle, filehandleCnt, file); }
#else
(
	fsys_t fsys,
	idarray_t gen_uids,
	mach_msg_type_number_t gen_uidsCnt,
	idarray_t gen_gids,
	mach_msg_type_number_t gen_gidsCnt,
	data_t filehandle,
	mach_msg_type_number_t filehandleCnt,
	mach_port_t *file
);
#endif

/* Routine fsys_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_syncfs
#if	defined(LINTLIBRARY)
    (fsys, wait, do_children)
	fsys_t fsys;
	int wait;
	int do_children;
{ return __fsys_syncfs(fsys, wait, do_children); }
#else
(
	fsys_t fsys,
	int wait,
	int do_children
);
#endif

/* Routine fsys_set_options */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_set_options
#if	defined(LINTLIBRARY)
    (fsys, options, optionsCnt, do_children)
	fsys_t fsys;
	data_t options;
	mach_msg_type_number_t optionsCnt;
	int do_children;
{ return __fsys_set_options(fsys, options, optionsCnt, do_children); }
#else
(
	fsys_t fsys,
	data_t options,
	mach_msg_type_number_t optionsCnt,
	int do_children
);
#endif

/* Routine fsys_getpriv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_getpriv
#if	defined(LINTLIBRARY)
    (fsys, host_priv, device_master, fstask)
	fsys_t fsys;
	mach_port_t *host_priv;
	mach_port_t *device_master;
	mach_port_t *fstask;
{ return __fsys_getpriv(fsys, host_priv, device_master, fstask); }
#else
(
	fsys_t fsys,
	mach_port_t *host_priv,
	mach_port_t *device_master,
	mach_port_t *fstask
);
#endif

/* Routine fsys_init */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_init
#if	defined(LINTLIBRARY)
    (fsys, proc_server, proc_serverPoly, auth_handle)
	fsys_t fsys;
	mach_port_t proc_server;
	mach_msg_type_name_t proc_serverPoly;
	auth_t auth_handle;
{ return __fsys_init(fsys, proc_server, proc_serverPoly, auth_handle); }
#else
(
	fsys_t fsys,
	mach_port_t proc_server,
	mach_msg_type_name_t proc_serverPoly,
	auth_t auth_handle
);
#endif

/* Routine fsys_forward */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_forward
#if	defined(LINTLIBRARY)
    (server, requestor, requestorPoly, argv, argvCnt)
	mach_port_t server;
	mach_port_t requestor;
	mach_msg_type_name_t requestorPoly;
	data_t argv;
	mach_msg_type_number_t argvCnt;
{ return __fsys_forward(server, requestor, requestorPoly, argv, argvCnt); }
#else
(
	mach_port_t server,
	mach_port_t requestor,
	mach_msg_type_name_t requestorPoly,
	data_t argv,
	mach_msg_type_number_t argvCnt
);
#endif

/* Routine fsys_get_options */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __fsys_get_options
#if	defined(LINTLIBRARY)
    (server, options, optionsCnt)
	fsys_t server;
	data_t *options;
	mach_msg_type_number_t *optionsCnt;
{ return __fsys_get_options(server, options, optionsCnt); }
#else
(
	fsys_t server,
	data_t *options,
	mach_msg_type_number_t *optionsCnt
);
#endif


/* Module fsys */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine fsys_startup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_startup
#if	defined(LINTLIBRARY)
    (bootstrap, openflags, control_port, control_portPoly, realnode)
	mach_port_t bootstrap;
	int openflags;
	mach_port_t control_port;
	mach_msg_type_name_t control_portPoly;
	mach_port_t *realnode;
{ return fsys_startup(bootstrap, openflags, control_port, control_portPoly, realnode); }
#else
(
	mach_port_t bootstrap,
	int openflags,
	mach_port_t control_port,
	mach_msg_type_name_t control_portPoly,
	mach_port_t *realnode
);
#endif

/* Routine fsys_goaway */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_goaway
#if	defined(LINTLIBRARY)
    (fsys, flags)
	fsys_t fsys;
	int flags;
{ return fsys_goaway(fsys, flags); }
#else
(
	fsys_t fsys,
	int flags
);
#endif

/* Routine fsys_getroot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_getroot
#if	defined(LINTLIBRARY)
    (fsys, dotdot_node, dotdot_nodePoly, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, flags, do_retry, retry_name, file)
	fsys_t fsys;
	mach_port_t dotdot_node;
	mach_msg_type_name_t dotdot_nodePoly;
	idarray_t gen_uids;
	mach_msg_type_number_t gen_uidsCnt;
	idarray_t gen_gids;
	mach_msg_type_number_t gen_gidsCnt;
	int flags;
	retry_type *do_retry;
	string_t retry_name;
	mach_port_t *file;
{ return fsys_getroot(fsys, dotdot_node, dotdot_nodePoly, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, flags, do_retry, retry_name, file); }
#else
(
	fsys_t fsys,
	mach_port_t dotdot_node,
	mach_msg_type_name_t dotdot_nodePoly,
	idarray_t gen_uids,
	mach_msg_type_number_t gen_uidsCnt,
	idarray_t gen_gids,
	mach_msg_type_number_t gen_gidsCnt,
	int flags,
	retry_type *do_retry,
	string_t retry_name,
	mach_port_t *file
);
#endif

/* Routine fsys_getfile */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_getfile
#if	defined(LINTLIBRARY)
    (fsys, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, filehandle, filehandleCnt, file)
	fsys_t fsys;
	idarray_t gen_uids;
	mach_msg_type_number_t gen_uidsCnt;
	idarray_t gen_gids;
	mach_msg_type_number_t gen_gidsCnt;
	data_t filehandle;
	mach_msg_type_number_t filehandleCnt;
	mach_port_t *file;
{ return fsys_getfile(fsys, gen_uids, gen_uidsCnt, gen_gids, gen_gidsCnt, filehandle, filehandleCnt, file); }
#else
(
	fsys_t fsys,
	idarray_t gen_uids,
	mach_msg_type_number_t gen_uidsCnt,
	idarray_t gen_gids,
	mach_msg_type_number_t gen_gidsCnt,
	data_t filehandle,
	mach_msg_type_number_t filehandleCnt,
	mach_port_t *file
);
#endif

/* Routine fsys_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_syncfs
#if	defined(LINTLIBRARY)
    (fsys, wait, do_children)
	fsys_t fsys;
	int wait;
	int do_children;
{ return fsys_syncfs(fsys, wait, do_children); }
#else
(
	fsys_t fsys,
	int wait,
	int do_children
);
#endif

/* Routine fsys_set_options */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_set_options
#if	defined(LINTLIBRARY)
    (fsys, options, optionsCnt, do_children)
	fsys_t fsys;
	data_t options;
	mach_msg_type_number_t optionsCnt;
	int do_children;
{ return fsys_set_options(fsys, options, optionsCnt, do_children); }
#else
(
	fsys_t fsys,
	data_t options,
	mach_msg_type_number_t optionsCnt,
	int do_children
);
#endif

/* Routine fsys_getpriv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_getpriv
#if	defined(LINTLIBRARY)
    (fsys, host_priv, device_master, fstask)
	fsys_t fsys;
	mach_port_t *host_priv;
	mach_port_t *device_master;
	mach_port_t *fstask;
{ return fsys_getpriv(fsys, host_priv, device_master, fstask); }
#else
(
	fsys_t fsys,
	mach_port_t *host_priv,
	mach_port_t *device_master,
	mach_port_t *fstask
);
#endif

/* Routine fsys_init */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_init
#if	defined(LINTLIBRARY)
    (fsys, proc_server, proc_serverPoly, auth_handle)
	fsys_t fsys;
	mach_port_t proc_server;
	mach_msg_type_name_t proc_serverPoly;
	auth_t auth_handle;
{ return fsys_init(fsys, proc_server, proc_serverPoly, auth_handle); }
#else
(
	fsys_t fsys,
	mach_port_t proc_server,
	mach_msg_type_name_t proc_serverPoly,
	auth_t auth_handle
);
#endif

/* Routine fsys_forward */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_forward
#if	defined(LINTLIBRARY)
    (server, requestor, requestorPoly, argv, argvCnt)
	mach_port_t server;
	mach_port_t requestor;
	mach_msg_type_name_t requestorPoly;
	data_t argv;
	mach_msg_type_number_t argvCnt;
{ return fsys_forward(server, requestor, requestorPoly, argv, argvCnt); }
#else
(
	mach_port_t server,
	mach_port_t requestor,
	mach_msg_type_name_t requestorPoly,
	data_t argv,
	mach_msg_type_number_t argvCnt
);
#endif

/* Routine fsys_get_options */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t fsys_get_options
#if	defined(LINTLIBRARY)
    (server, options, optionsCnt)
	fsys_t server;
	data_t *options;
	mach_msg_type_number_t *optionsCnt;
{ return fsys_get_options(server, options, optionsCnt); }
#else
(
	fsys_t server,
	data_t *options,
	mach_msg_type_number_t *optionsCnt
);
#endif

#endif	/* not defined(_fsys_user_) */
