/* sierp.c */

#include "glpimg.h"

static IMG *img;
static int n = 4, h0 = 512;
static int i, h, x, y, x0, y0;

static void A(int i), B(int i), C(int i), D(int i);

static void A(int i)
{     if (i > 0)
      {  A(i-1); x += h; y -= h; line_to(img, x, y);
         B(i-1); x += 2*h; line_to(img, x, y);
         D(i-1); x += h; y += h; line_to(img, x, y);
         A(i-1);
      }
      return;
}

static void B(int i)
{     if (i > 0)
      {  B(i-1); x -= h; y -= h; line_to(img, x, y);
         C(i-1); y -= 2*h; line_to(img, x, y);
         A(i-1); x += h; y -= h; line_to(img, x, y);
         B(i-1);
      }
      return;
}

static void C(int i)
{     if (i > 0)
      {  C(i-1); x -= h; y += h; line_to(img, x, y);
         D(i-1); x -= 2*h; line_to(img, x, y);
         B(i-1); x -= h; y -= h; line_to(img, x, y);
         C(i-1);
      }
      return;
}

static void D(int i)
{     if (i > 0)
      {  D(i-1); x += h; y += h; line_to(img, x, y);
         A(i-1); y += 2*h; line_to(img, x, y);
         C(i-1); x -= h; y += h; line_to(img, x, y);
         D(i-1);
      }
      return;
}

int main(void)
{     /* draw Serpinsky's curves of order 1 to n */
      img = create_img(IMG_16, h0, h0);
      h = h0 / 4; x0 = 2*h; y0 = 3*h;
      for (i = 1; i <= n; i++)
      {  x0 -= h; h /= 2; y0 += h;
         x = x0; y = y0; move_to(img, x, y);
         switch (i)
         {  case 1: set_color(img, 11); break;
            case 2: set_color(img, 13); break;
            case 3: set_color(img, 14); break;
            case 4: set_color(img, 15); break;
         }
         A(i); x += h; y -= h; line_to(img, x, y);
         B(i); x -= h; y -= h; line_to(img, x, y);
         C(i); x -= h; y += h; line_to(img, x, y);
         D(i); x += h; y += h; line_to(img, x, y);
      }
      save_as_bmp(img, "sierp.bmp");
      save_as_tiff(img, "sierp.tiff");
      delete_img(img);
      return 0;
}

/* eof */
