/* glprsm3.c (ufi) */

/*----------------------------------------------------------------------
-- Copyright (C) 2000, 2001, 2002 Andrew Makhorin <mao@mai2.rcnet.ru>,
--               Department for Applied Informatics, Moscow Aviation
--               Institute, Moscow, Russia. All rights reserved.
--
-- This file is a part of GLPK (GNU Linear Programming Kit).
--
-- GLPK is free software; you can redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2, or (at your option)
-- any later version.
--
-- GLPK is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
-- License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with GLPK; see the file COPYING. If not, write to the Free
-- Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
-- 02111-1307, USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

void *create_ufi(int m)
{     print("*create_ufi*");
      return create_pfi(m);
}

int build_ufi(void *ufi, MAT *A, int indb[])
{     print("*build_ufi*");
      return build_pfi(ufi, A, indb);
}

double *ufi_ftran(void *ufi, double z[], int save)
{     print("*ufi_ftran*");
      return pfi_ftran(ufi, z, save);
}

double *ufi_btran(void *ufi, double z[])
{     print("*ufi_btran*");
      return pfi_btran(ufi, z);
}

int update_ufi(void *ufi, int p)
{     print("*update_ufi*");
      return update_pfi(ufi, p);
}

void delete_ufi(void *ufi)
{     print("*delete_ufi*");
      delete_pfi(ufi);
      return;
}

/* eof */
