/* glpstr.h */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#ifndef _GLPSTR_H
#define _GLPSTR_H

#include "glpset.h"

#define str2int               _glp_str2int
#define str2dbl               _glp_str2dbl
#define strspx                _glp_strspx
#define strtrim               _glp_strtrim
#define clear_str             _glp_clear_str
#define compare_str           _glp_compare_str
#define create_str            _glp_create_str
#define create_str_pool       _glp_create_str_pool
#define delete_str            _glp_delete_str
#define get_str               _glp_get_str
#define set_str               _glp_set_str

extern int str2int(char *str, int *val);
/* convert character string to value of integer type */

extern int str2dbl(char *str, double *val);
/* convert character string to value of double type */

extern char *strspx(char *str);
/* remove all spaces from character string */

extern char *strtrim(char *str);
/* remove trailing spaces from character string */

typedef struct STR STR;
typedef struct SQE SQE;

struct STR
{     /* segmented character string of arbitrary length */
      POOL *pool;
      /* memory pool holding string elements */
      int len;
      /* current string length */
      SQE *head;
      /* pointer to the first string element */
      SQE *tail;
      /* pointer to the last string element */
};

#define SQE_SIZE 12
/* number of characters allocated in each string element */

struct SQE
{     /* element of segmented character string */
      char data[SQE_SIZE];
      /* characters allocated in this element */
      SQE *next;
      /* pointer to the next string element */
};

extern STR *clear_str(STR *str);
/* clear segmented character string */

extern int compare_str(STR *str1, STR *str2);
/* compare segmented character strings */

extern STR *create_str(POOL *pool);
/* create segmented character string */

extern POOL *create_str_pool(void);
/* create pool for segmented character strings */

extern void delete_str(STR *str);
/* delete segmented character string */

extern char *get_str(char *to, STR *str);
/* extract value from segmented character string */

extern STR *set_str(STR *str, char *from);
/* assign value to segmented character string */

#endif

/* eof */
