/* qmdqt.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- THIS CODE IS THE RESULT OF TRANSLATION OF THE FORTRAN SUBROUTINE
-- QMDQT FROM THE BOOK:
--
-- ALAN GEORGE, JOSEPH W-H LIU. COMPUTER SOLUTION OF LARGE SPARSE
-- POSITIVE DEFINITE SYSTEMS. PRENTICE-HALL, 1981.
--
-- THE TRANSLATION HAS BEEN DONE WITH THE PERMISSION OF THE AUTHORS
-- OF THE ORIGINAL FORTRAN SUBROUTINE: ALAN GEORGE AND JOSEPH LIU,
-- UNIVERSITY OF WATERLOO, WATERLOO, ONTARIO, CANADA.
--
-- The translation was made by Andrew Makhorin <mao@mai2.rcnet.ru>,
-- <mao@gnu.org>, Department for Applied Informatics, Moscow Aviation
-- Institute, Moscow, Russia.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpqmd.h"

/*----------------------------------------------------------------------
-- qmdqt - Quotient MD Quotient graph Transformation.
--
-- *Synopsis*
--
-- #include "glpqmd.h"
-- void qmdqt(int *root, int xadj[], int adjncy[], int marker[],
--    int *rchsze, int rchset[], int nbrhd[]);
--
-- *Purpose*
--
-- This subroutine performs the quotient graph transformation after a
-- node has been eliminated.
--
-- *Input parameters*
--
-- root   - the node just eliminated. It becomes the representative of
--          the new supernode;
-- (xadj, adjncy) -
--          the adjancy structure;
-- (rchsze, rchset) -
--          the reachable set of root in the old quotient graph;
-- nbrhd  - the neighborhood set which will be merged with root to form
--          the new supernode;
-- marker - the marker vector.
--
-- *Updated parameter*
--
-- adjncy - becomes the adjncy of the quotient graph.
----------------------------------------------------------------------*/

void qmdqt(int *_root, int xadj[], int adjncy[], int marker[],
      int *_rchsze, int rchset[], int nbrhd[])
{     int inhd, irch, j, jstop, jstrt, link, nabor, node;
#     define root   (*_root)
#     define rchsze (*_rchsze)
      irch = 0;
      inhd = 0;
      node = root;
s100: jstrt = xadj[node];
      jstop = xadj[node+1] - 2;
      if (jstop >= jstrt)
      {  /* Place reach nodes into the adjacent list of node. */
         for (j = jstrt; j <= jstop; j++)
         {  irch++;
            adjncy[j] = rchset[irch];
            if (irch >= rchsze) goto s400;
         }
      }
      /* Link to other space provided by the nbrhd set. */
      link = adjncy[jstop+1];
      node = - link;
      if (link >= 0)
      {  inhd++;
         node = nbrhd[inhd];
         adjncy[jstop+1] = - node;
      }
      goto s100;
      /* All reachable nodes have been saved. End the adjacent list.
         Add root to the neighborhood list of each node in the reach
         set. */
s400: adjncy[j+1] = 0;
      for (irch = 1; irch <= rchsze; irch++)
      {  node = rchset[irch];
         if (marker[node] >= 0)
         {  jstrt = xadj[node];
            jstop = xadj[node+1] - 1;
            for (j = jstrt; j <= jstop; j++)
            {  nabor = adjncy[j];
               if (marker[nabor] < 0)
               {  adjncy[j] = root;
                  goto s600;
               }
            }
         }
s600:    ;
      }
      return;
#     undef root
#     undef rchsze
}

/* eof */
