/* glpapi/glp_put_col_soln.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpapi.h"

/*----------------------------------------------------------------------
-- glp_put_col_soln - store column solution information.
--
-- *Synopsis*
--
-- #include "glpk.h"
-- void glp_put_col_soln(LPI *lp, int j, int tagx, double valx,
--    double dx);
--
-- *Description*
--
-- The routine glp_put_col_soln stores solution information for the
-- j-th column (structural variable) to the problem object.
--
-- The parameters tagx, valx, and dx specify status, primal value, and
-- dual value of the j-th structural variable, respectively.
--
-- This routine is intended for using by the solver. */

void glp_put_col_soln(LPI *lp, int j, int tagx, double valx, double dx)
{     if (!(1 <= j && j <= lp->n))
         fault("glp_put_col_soln: j = %d; invalid column number", j);
      if (!(tagx == 'B' || tagx == 'L' || tagx == 'U' || tagx == 'F' ||
            tagx == 'S'))
         fault("glp_put_col_soln: tagx = %d; invalid column status",
            tagx);
      lp->col[j]->tagx = tagx;
      lp->col[j]->valx = valx;
      lp->col[j]->dx = dx;
      return;
}

/* eof */
