/* glpchol/decomp_adat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpchol.h"

/*----------------------------------------------------------------------
-- decomp_adat - compute Cholesky factorization for S = A*D*A'.
--
-- *Synopsis*
--
-- #include "glpchol.h"
-- void decomp_adat(ADAT *adat, MAT *A, double D[]);
--
-- *Description*
--
-- The decomp_adat routine performs numeric phase of Cholesky
-- factorization for symmetric positive definite matrix S = A*D*A',
-- where A is rectangular matrix of full rank, D is diagonal matrix.
--
-- The matrix A passed to decomp_adat routine should have exactly the
-- same pattern as the matrix passed to create_adat routine. The matrix
-- A remains unchanged on exit.
--
-- The array D specifies diagonal matrix D of order n, where n is number
-- of columns of the matrix A. Diagonal elements of D should be placed
-- in locations D[1], D[2], ..., D[n]. If the parameter D is NULL, it is
-- assumed that D is unity matrix. */

void decomp_adat(ADAT *adat, MAT *A, double D[])
{     aat_numb(adat->S, A, D, NULL);
      decomp_chol(adat->chol, adat->S);
      return;
}

/* eof */
