/* glpbbm/btrack_fifo.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpbbm.h"

/*----------------------------------------------------------------------
-- btrack_fifo - select active problem using FIFO heuristic.
--
-- *Synopsis*
--
-- #include "glpbbm.h"
-- BBNODE *btrack_fifo(BBDATA *bb);
--
-- *Description*
--
-- The btrack_fifo routine selects an appropriate problem which should
-- be considered next from the active list.
--
-- *Returns*
--
-- The btrack_fifo routine returns a pointer to the problem node.
--
-- *Heuristic*
--
-- The btrack_fifo routine implements trivial FIFO (first-in-first-out)
-- heuristic, i.e. it selects the problem which was added to the active
-- list *before* any other problems. If this heuristic is used, the tree
-- is investigated in the breadth-first-search manner. */

BBNODE *btrack_fifo(BBDATA *bb)
{     BBNODE *node;
      node = bb->first;
      insist(node != NULL);
      return node;
}

/* eof */
