/* glplpm.h */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#ifndef _GLPLPM_H
#define _GLPLPM_H

#include "glpset.h"

#define free_lpm              glp_free_lpm
#define load_lpm              glp_load_lpm

typedef struct LPM LPM;
typedef struct LPMPAR LPMPAR;
typedef struct LPMROW LPMROW;
typedef struct LPMCOL LPMCOL;
typedef struct LPMLFE LPMLFE;

struct LPM
{     /* linear programming model */
      POOL *pool;
      /* memory pool for all data structures */
      char *name;
      /* model name */
      int npars;
      /* number of parameters */
      LPMPAR *first_par, *last_par;
      /* pointers to the first and to the last parameter */
      int nrows;
      /* number of rows */
      LPMROW *first_row, *last_row;
      /* pointers to the first and to the last row */
      int ncols;
      /* number of columns */
      LPMCOL *first_col, *last_col;
      /* pointers to the first and to the last column */
      int obj_dir;
      /* optimization direction flag:
         '-' - minimzation
         '+' - maximization */
      LPMROW *obj_row;
      /* pointer to the objective function row; NULL indicates that the
         objective function is identically equal to zero */
};

struct LPMPAR
{     /* model parameter (named constant) */
      char *name;
      /* parameter name */
      double val;
      /* parameter value */
      LPMPAR *next;
      /* pointer to the next parameter */
};

struct LPMROW
{     /* model row (constraint) */
      char *name;
      /* row name */
      LPMLFE *form;
      /* pointer to linear form */
      double lb;
      /* lower bound or -DBL_MAX (no lower bound) */
      double ub;
      /* upper bound or +DBL_MAX (no upper bound) */
      LPMROW *next;
      /* pointer to the next row */
};

struct LPMCOL
{     /* model column (variable) */
      char *name;
      /* column name */
      int kind;
      /* column kind (zero means continuous variable, non-zero means
         integer variable) */
      double lb;
      /* lower bound or -DBL_MAX (no lower bound) */
      double ub;
      /* upper bound or +DBL_MAX (no upper bound) */
      int seqn;
      /* column sequential number */
      LPMCOL *next;
      /* pointer to the next column */
};

struct LPMLFE
{     /* linear form element */
      LPMCOL *col;
      /* pointer to column (NULL means constant term) */
      double coef;
      /* coefficient (or constant term) */
      LPMLFE *next;
      /* pointer to the next element */
};

extern LPM *load_lpm(char *fname);
/* load linear programming model in LPM format */

extern void free_lpm(LPM *lpm);
/* free linear programming model in LPM format */

#endif

/* eof */
