/* glprsm/rsm_set_ap.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_set_ap - compute pivot row of simplex table.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- void rsm_set_ap(RSM *rsm);
--
-- *Description*
--
-- The rsm_set_ap routine computes the pivot row of the current simplex
-- table which corresponds to the chosen basis variable xB[p], and
-- stores this row to the array ap.
--
-- Since the computed row is p-th row of the matrix (-inv(B)*N), the
-- routine uses the following formula:
--
--    ap = - N' * bp,
--
-- where N' is a matrix transposed to N, N is the submatrix formed by
-- non-basis columns of the expanded constraint matrix A~, bp is the
-- p-th row of the inverse inv(B).
--
-- The rsm_set_ap routine assumes that the row bp were computed before
-- by the rsm_set_bp routine. */

void rsm_set_ap(RSM *rsm)
{     ELEM *e;
      int n = rsm->n, j , k;
      for (j = 1; j <= n; j++)
      {  k = rsm->indn[j]; /* x[k] = xN[j] */
         rsm->ap[j] = 0.0;
         for (e = rsm->A->col[k]; e != NULL; e = e->col)
            rsm->ap[j] -= e->val * rsm->bp[e->i];
      }
      return;
}

/* eof */
