/* glprsm/rsm_check_dev.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_check_dev - check deviation from given value.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- int rsm_check_dev(double x, double x0, double tol);
--
-- *Returns*
--
-- The rsm_check_dev routine checks deviation of x from the given value
-- x0 using the tolerance tol > 0 and returns one of the following code:
--
-- -2, if x < x0 - eps
-- -1, if x0 - eps <= x < x0
--  0, if x = x0
-- +1, if x0 < x <= x0 + eps
-- +2, if x > x0 + eps
--
-- where eps = tol * max(|x0|, 1). */

int rsm_check_dev(double x, double x0, double tol)
{     int ret;
      double eps;
      eps = (x0 >= 0.0 ? +x0 : -x0);
      eps = tol * (eps > 1.0 ? eps : 1.0);
      if (x < x0 - eps)
         ret = -2;
      else if (x > x0 + eps)
         ret = +2;
      else if (x < x0)
         ret = -1;
      else if (x > x0)
         ret = +1;
      else
         ret = 0;
      return ret;
}

/* eof */
