package html;

import java.net.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;

public class HtmlCanvas extends Canvas
{
  private HtmlDocument document = null;
  private int start = 0;
  private int width = 300;
  private int heights[] = null;
  private Href hrefs[] = null;
  private Hashtable names = null;
  private Image image = null;
  private HtmlImage imgs[] = null;

  public HtmlCanvas()
  {
    this.document = null;
  }

  public HtmlCanvas(HtmlDocument document)
  {
    changeDocument(document);
  }

  public void changeDocument(HtmlDocument document)
  {
    document.draw(new HtmlPager(this, width));
    this.document = document;
    start = 0;
  }

  public URL getHref(int x, int y)
  {
    if (hrefs == null)
      return null;

    int line = lineAt(y + start);

    for (int i = 0; i < hrefs.length; i++)
    {
      Href href = hrefs[i];
      if (line == href.startLine && x < href.startOffset)
        continue;
      if (line == href.endLine && x >= href.endOffset)
        continue;
      if (line >= href.startLine && line <= href.endLine)
        return href.url;
    }
    return null;
  }

  public int setStart(String name)
  {
    if (names == null || name == null)
    {
      start = 0;
    }
    else
    {
      Integer i = (Integer)names.get(name);
      if (i == null)
	start = 0;
      else
	start = heights[i.intValue() - 1];
    }
    repaint();
    return start;
  }

  public void setStart(int start)
  {
    this.start = start;
    repaint();
  }

  public int setWidth(int w)
  {
    if (document == null)
    {
      width = w;
      return 0;
    }

    if (w != width)
    {
      width = w;
      document.draw(new HtmlPager(this, w));
    }
    return heights[heights.length - 1];
  }

  private String statusString(int info)
  {
    String s = "";
    if ((info & ABORT) != 0) s += "ABORT ";
    if ((info & ALLBITS) != 0) s += "ALLBITS ";
    if ((info & ERROR) != 0) s += "ERROR ";
    if ((info & FRAMEBITS) != 0) s += "FRAMEBITS ";
    if ((info & HEIGHT) != 0) s += "HEIGHT ";
    if ((info & PROPERTIES) != 0) s += "PROPERTIES ";
    if ((info & SOMEBITS) != 0) s += "SOMEBITS ";
    if ((info & WIDTH) != 0) s += "WIDTH ";
    return s + info;
  }

  synchronized public void paint(Graphics g)
  {
    g.setColor(getBackground());
    if (document == null)
    {
      g.fillRect(0, 0, size().width, size().height);
    }
    else
    {
      if (image == null)
	document.draw(new HtmlPager(this, width));
      Graphics gg = image.getGraphics();
      for (int i = 0; i < imgs.length; i++)
        gg.drawImage(imgs[i].img, imgs[i].x, imgs[i].y, imgs[i].w, imgs[i].h, this);
      g.drawImage(image, 0, -start, this);
      int w = image.getWidth(null);
      if (w < size().width)
        g.fillRect(w, 0, size().width - w, size().height);
      int h = image.getHeight(null) - start;
      if (h < size().height)
        g.fillRect(0, h, size().width, size().height - h);
    }
  }

  public void update(Graphics g)
  {
    paint(g);
  }

  synchronized protected void setData(
	int heights[],
	Href hrefs[],
	Hashtable names,
	HtmlImage imgs[],
	Image image)
  {
    this.heights = heights;
    this.hrefs = hrefs;
    this.names = names;
    this.imgs = imgs;
    this.image = image;
  }

  private int lineAt(int y)
  {
    for (int line = 0; line < heights.length - 1; line++)
      if (y >= heights[line] && y < heights[line + 1])
        return line;
    return -1;
  }
}
