/*
 * LogicBenchmark.cs - Implementation of the "LogicBenchmark" class.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace PNetMark
{

using System;

/// <summary>
/// <para>The <see cref="T:PNetMark.LogicBenchmark"/> class implements
/// the <see cref="T:PNetMark.IBenchmark"/> interface, and runs number
/// of logic tests.</para>
/// </summary>
public class LogicBenchmark : IBenchmark
{
	// Internal state.
	public int numIterations;

	/// <summary>
	/// <para>Construct a new <see cref="T:PNetMark.LogicBenchmark"/>
	/// instance.</para>
	/// </summary>
	public LogicBenchmark()
	{
		numIterations = 1200;
	}

	/// <summary>
	/// <para>Initialize the benchmark to run on this system.</para>
	/// </summary>
	///
	/// <param name="size">
	/// <para>A value that indicates the size of the benchmark to run.
	/// This should be zero to use the default value.</para>
	/// </param>
	///
	/// <returns>
	/// <para>Returns <see langword="true"/> if the benchmark could be
	/// initialized, or <see langword="false"/> otherwise.</para>
	/// </returns>
	public bool Initialize(int size)
	{
		if(size != 0)
		{
			numIterations = size;
		}
		return true;
	}

	/// <summary>
	/// <para>Get the name of the benchmark.</para>
	/// </summary>
	///
	/// <value>
	/// <para>A <see cref="T:System.String"/> that contains the name
	/// of the benchmark.</para>
	/// </value>
	public String Name
	{
		get
		{
			return "Logic ";
		}
	}

	/// <summary>
	/// <para>Get the magnification factor for test scoring.</para>
	/// </summary>
	///
	/// <value>
	/// <para>The magnification factor.</para>
	/// </value>
	public int Magnification
	{
		get
		{
			return 3813;
		}
	}

	/// <summary>
	/// <para>Run the benchmark.</para>
	/// </summary>
	public void Run()
	{
		int iter;

		// Initialize.
		bool flag1 = true;
		bool flag2 = true;
		bool flag3 = true;
		bool flag4 = true;
		bool flag5 = true;
		bool flag6 = true;
		bool flag7 = true;
		bool flag8 = true;
		bool flag9 = true;
		bool flag10 = true;
		bool flag11 = true;
		bool flag12 = true;
		bool flag13 = true;

		// First set of tests.
		for(iter = 0; iter < numIterations; ++iter)
		{
			if((flag1 || flag2) && (flag3 || flag4) &&
			   (flag5 || flag6 || flag7))
			{
				flag8 = !flag8;
				flag9 = !flag9;
				flag10 = !flag10;
				flag11 = !flag11;
				flag12 = !flag12;
				flag13 = !flag13;
				flag1 = !flag1;
				flag2 = !flag2;
				flag3 = !flag3;
				flag4 = !flag4;
				flag5 = !flag5;
				flag6 = !flag6;
				flag1 = !flag1;
				flag2 = !flag2;
				flag3 = !flag3;
				flag4 = !flag4;
				flag5 = !flag5;
				flag6 = !flag6;
			}
		}

		// Adjust some of the flags.
		flag1 = true;
		flag2 = false;
		flag3 = true;
		flag4 = false;
		flag5 = true;
		flag6 = false;

		// Second set of tests.
		for(iter = 0; iter < numIterations; ++iter)
		{
			if((flag1 || flag2) && (flag3 || flag4) &&
			   (flag5 || flag6 || flag7))
			{
				flag1 = !flag1;
				flag2 = !flag2;
				flag3 = !flag3;
				flag4 = !flag4;
				flag5 = !flag5;
				flag6 = !flag6;
				flag8 = !flag8;
				flag9 = !flag9;
				flag10 = !flag10;
				flag11 = !flag11;
				flag12 = !flag12;
				flag13 = !flag13;
				flag8 = !flag8;
				flag9 = !flag9;
				flag10 = !flag10;
				flag11 = !flag11;
				flag12 = !flag12;
				flag13 = !flag13;
			}
		}
	}

	/// <summary>
	/// <para>Clean up after the benchmark has been run.</para>
	/// </summary>
	public void CleanUp()
	{
		// Nothing needs to be done here.
	}

} // class LogicBenchmark

} // namespace PNetMark
