/*
 * LineDrawingChar.cs - Special line drawing character codes for ncurses.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

namespace Curses
{

public enum LineDrawingChar
{
	ACS_ULCORNER	= (int)'l',		// upper left corner.
	ACS_LLCORNER	= (int)'m',		// lower left corner.
	ACS_URCORNER	= (int)'k',		// upper right corner.
	ACS_LRCORNER	= (int)'j',		// lower right corner.
	ACS_LTEE		= (int)'t',		// tee pointing right.
	ACS_RTEE		= (int)'u',		// tee pointing left.
	ACS_BTEE		= (int)'v',		// tee pointing up.
	ACS_TTEE		= (int)'w',		// tee pointing down.
	ACS_HLINE		= (int)'q',		// horizontal line.
	ACS_VLINE		= (int)'x',		// vertical line.
	ACS_PLUS		= (int)'n',		// large plus or crossover.
	ACS_S1			= (int)'o',		// scan line 1.
	ACS_S9			= (int)'s',		// scan line 9.
	ACS_DIAMOND		= (int)'`',		// diamond.
	ACS_CKBOARD		= (int)'a',		// checker board (stipple).
	ACS_DEGREE		= (int)'f',		// degree symbol.
	ACS_PLMINUS		= (int)'g',		// plus/minus.
	ACS_BULLET		= (int)'~',		// bullet.
	ACS_LARROW		= (int)',',		// arrow pointing left.
	ACS_RARROW		= (int)'+',		// arrow pointing right.
	ACS_DARROW		= (int)'.',		// arrow pointing down.
	ACS_UARROW		= (int)'-',		// arrow pointing up.
	ACS_BOARD		= (int)'h',		// board of squares.
	ACS_LANTERN		= (int)'i',		// lantern symbol.
	ACS_BLOCK		= (int)'0',		// solid square block.
	ACS_S3			= (int)'p',		// scan line 3.
	ACS_S7			= (int)'r',		// scan line 7.
	ACS_LEQUAL		= (int)'y',		// less/equal.
	ACS_GEQUAL		= (int)'z',		// greater/equal.
	ACS_PI			= (int)'{',		// Pi.
	ACS_NEQUAL		= (int)'|',		// not equal.
	ACS_STERLING	= (int)'}',		// UK pound sign.
	ACS_BSSB		= ACS_ULCORNER,	// upper left corner.
	ACS_SSBB		= ACS_LLCORNER,	// lower left corner.
	ACS_BBSS		= ACS_URCORNER,	// upper right corner.
	ACS_SBBS		= ACS_LRCORNER,	// lower right corner.
	ACS_SBSS		= ACS_RTEE,		// tee pointing left.
	ACS_SSSB		= ACS_LTEE,		// tee pointing right.
	ACS_SSBS		= ACS_BTEE,		// tee pointing up.
	ACS_BSSS		= ACS_TTEE,		// tee pointing down.
	ACS_BSBS		= ACS_HLINE,	// horizontal line.
	ACS_SBSB		= ACS_VLINE,	// vertical line.
	ACS_SSSS		= ACS_PLUS		// large plus or crossover.

} // enum LineDrawingChar

} // namespace Curses
