/*
 * testcurses.c - Test stub for the curses help routines.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#undef CSHARP_CURSES_DLL
#include "defs.h"

#ifdef	__cplusplus
extern	"C" {
#endif

int main(int argc, char *argv[])
{
	int ch;
	short fg, bg;

	/* Initialize the curses routines */
	if(!CursesHelpInitialize())
	{
		fprintf(stderr, "%s: could not initialize curses\n", argv[0]);
		return 1;
	}
	printw("num_pairs = %d\n", COLOR_PAIRS);
	pair_content(0, &fg, &bg);
	printw("default color = %d, %d\n", (int)fg, (int)bg);
	init_pair(1, COLOR_RED, -1);
	wattrset(stdscr, COLOR_PAIR(1));
	printw("should be red on default\n");
	wattrset(stdscr, COLOR_PAIR(0));
	printw("should be normal again\n");
	printw("stored size = %d, %d\n",
		   CursesHelpGetWidth(stdscr),
		   CursesHelpGetHeight(stdscr));

	/* Wait for the user to press 'q' */
	while((ch = CursesHelpGetNextChar(-1)) != 'q')
	{
		if(ch == (KEY_MAX << 16))
		{
			break;
		}
		else if(ch == (KEY_RESIZE << 16))
		{
			printw("%d, %d\n", COLS, LINES);
		}
	}

	/* Clean up and exit */
	CursesHelpTerminate();
	return 0;
}

#ifdef	__cplusplus
};
#endif
