/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.
*/

/* $Id: zdpsx.c,v 1.7 1999/09/05 18:28:35 masata-y Exp $ */
/* X Windows Display PostScript extensions */
#include "ghost.h"
#include "errors.h"
#include "oper.h"
#include "gsmatrix.h"
#include "gscoord.h"
#include "gspath.h"
#include "gspath2.h"
#include "gsstate.h"
#include "ialloc.h"
#include "igstate.h"
#include "ivmspace.h"
#include "store.h"
#include "stream.h"
#include "ibnum.h"

/* the X people can't make their headers define what they need automatically... */
#define NEED_REPLIES
#define NEED_EVENTS
#include "x_.h"                 /* standard X include files */
#include "X11/Xproto.h"
#include "X11/Xlibint.h"        /* we need internals, too */
#include "dpsNXprops.h" /* has the property definitions */
#include "DPS/XDPSproto.h"
#include "DPSCAPproto.h"
#include "DPSCAP.h"
#include "DPS/dpsNXargs.h"

#include "gx.h"
#include "gxdevice.h"
#include "gdevx.h"
extern gx_device_X gs_x11_device;

#include "gsdpsx.h"

/* ------ Agent state ------ */

/* - .startXdpsagent <bool> */
private int
zstartXdpsagent(register os_ptr op)
{	push(1);
	make_bool(op, gs_startXdpsagent(igs, imemory));
	return 0;
}

/* - currentXgcdrawable <int> <int> <int> <int> */
/* - currentXgcdrawable gc drawable x y */
private int
zcurrentXgcdrawable(register os_ptr op)
{       gx_device_X *xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;
        push(4);
        make_int(op-3, (int)XGContextFromGC(xdev_gc_inline(xdev)));
        make_int(op-2, (int)xdev_win_inline(xdev));
	/* OFFSET DPS */
	make_int(op-1, gsdpsx_get_offset(xdev, 0));
	make_int(op, gsdpsx_get_offset(xdev, 1));
        return 0;
}

/* <int> <int> <int> <int> setXgcdrawable - */
/* gc drawable x y setXgcdrawable - */
private int
zsetXgcdrawable(register os_ptr op)
{       gx_device_X *xdev;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;

        check_type(op[-3], t_integer);
        check_type(op[-2], t_integer);
        check_type(op[-1], t_integer);
        check_type(op[ 0], t_integer);
        if (op[-3].value.intval)
            xdev_gc_inline(xdev)->gid = (GContext)(op[-3].value.intval);
        if (op[-2].value.intval)
            gdev_x_set_drawable(xdev, (Drawable)(op[-2].value.intval));

	if (0) dprintf4("setXgcdrawable gc: %08X, drawable: %08x, x: %d, y: %d\n",
			(int)op[-3].value.intval, (int)op[-2].value.intval,
			(int)op[-1].value.intval, (int)op[ 0].value.intval);
	gsdpsx_set_offset(xdev, (op[-1].value.intval), 0);
	gsdpsx_set_offset(xdev, (op[0].value.intval), 1);
        gs_initmatrix(igs);
	gs_initclip(igs);
        pop(4);

        return 0;
}


/* - currentXoffset <int> <int> */
/* - currentXoffset x y */
private int
zcurrentXoffset(register os_ptr op)
{       gx_device_X *xdev;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;
        push(2);
	/* OFFSET DPS */
	make_int(op-1, gsdpsx_get_offset(xdev, 0));
	make_int(op, gsdpsx_get_offset(xdev, 1));
        return 0;
}

/* <int> <int> setXoffset - */
/* x y setXoffset - */
private int
zsetXoffset(register os_ptr op)
{       gx_device_X *xdev;
        xdev = (gx_device_X*)gs_currentdevice(igs);
        if (xdev->dname != gs_x11_type_name)
              return e_typecheck;
        check_type(op[-1], t_integer);
        check_type(op[ 0], t_integer);
        if (0) dprintf2("setXoffset, x: %d, y: %d\n", 
			(int)op[-1].value.intval, 
			(int)op[0].value.intval);
	/* OFFSET DPS */
	gsdpsx_set_offset(xdev, (op[-1].value.intval), 0);
	gsdpsx_set_offset(xdev, (op[0].value.intval), 1);
        /* reset the drawable to force window recalculation */
        gdev_x_set_drawable(xdev, (Drawable)(xdev_win_inline(xdev)));
        gs_initmatrix(igs);
        gs_initclip(igs);
        pop(2);

        return 0;
}
                   
/* ------ Initialization procedure ------ */

const op_def zdpsx_op_defs[] =
{
    op_def_begin_level2(),
		/* Agent state */
    {"1.startXdpsagent", zstartXdpsagent},
    {"0currentXgcdrawable", zcurrentXgcdrawable},
    {"4setXgcdrawable", zsetXgcdrawable},
    {"0currentXoffset", zcurrentXoffset},
    {"2setXoffset", zsetXoffset},
    op_def_end(0)
};
