/* Copyright (C) 1997 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.

  However Display Ghostscript System depends on GLib. */

/* $Id: dgsdps.h,v 1.2 2000/02/28 19:31:31 cigas Exp $ */

#ifndef dgsdps_INCLUDED
#define dgsdps_INCLUDED

#include "dgs.h"
/* message handlers */
/* returns the number of bytes message used.  0 if it is just a fragment. */
/* returns negative on a different error. */

/* DPSCAP  */
int dpscap_ConnSetup(gsdpsx_conn_info * conn,
		     unsigned char *pmsg, int remaining);

int dpscap_Notify(gsdpsx_conn_info * conn,
		  unsigned char *pmsg, int remaining,
		  enum scheduling_action *sched_act);

Bool dpscap_Notify_pause_check(gsdpsx_conn_info * conn, int cxid, int sync);

int dpscap_FlushAgent(gsdpsx_conn_info * conn,
		      unsigned char *pmsg, int remaining);

int dpscap_SetArg(gsdpsx_conn_info * conn,
		  unsigned char *pmsg, int remaining);

/* DPS  */
int dps_CreateContext(gsdpsx_conn_info * conn,
		      unsigned char *pmsg, int remaining,
		      enum scheduling_action *sched_act);

void dps_CreateContext_reply(gsdpsx_conn_info * conn, int cpsid);

int dps_SetStatusMask(gsdpsx_conn_info * conn,
		      unsigned char *pmsg, int remaining);

int dps_NotifyContext(gsdpsx_conn_info * conn,
		      unsigned char *pmsg, int remaining,
		      enum scheduling_action *sched_act);

int dps_DestroySpace(gsdpsx_conn_info * conn,
		     unsigned char *pmsg, int remaining);

int dps_GiveInput(gsdpsx_conn_info * conn,
		  unsigned char *pmsg, int remaining,
		  enum scheduling_action *sched_act);

int dps_Init(gsdpsx_conn_info * conn, unsigned char *pmsg, int remaining);

int dps_CreateSpace(gsdpsx_conn_info * conn,
		    unsigned char *pmsg, int remaining);

int dps_GetStatus(gsdpsx_conn_info * conn,
		  unsigned char *pmsg, int remaining);

int dps_Reset(gsdpsx_conn_info * conn, unsigned char *pmsg, int remaining);

int dps_CreateContextFromID(gsdpsx_conn_info * conn,
			    unsigned char *pmsg, int remaining);

int dps_XIDFromContext(gsdpsx_conn_info * conn,
		       unsigned char *pmsg, int remaining);

int dps_ContextFromXID(gsdpsx_conn_info * conn,
		       unsigned char *pmsg, int remaining);

int dps_CreateSecureContext(gsdpsx_conn_info * conn,
			    unsigned char *pmsg, int remaining);

int dps_NotifyWhenReady(gsdpsx_conn_info * conn,
			unsigned char *pmsg, int remaining);

/* DPSX */
int dpsx_ChangeGC(gsdpsx_conn_info * conn,
		  unsigned char *pmsg, int remaining);

/* status */
int status_send_if_masked(gsdpsx_conn_info * conn,
			  int cpsid, int status, int steady1_or_next0);


#endif /* dgsdps_INCLUDED */
