#! /usr/bin/env perl
#
#	Create a program from three source files with variant builds
#	for two different "architectures."  Define SUFOBJ differently
#	for the two variants by including the architecture:  ".arch.o".
#	Build these two the same subdirectory so any confusion about
#	object files will show up in the resulting program output.
#

# $Id: t0082.t,v 1.1 2000/10/17 17:01:51 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons qw($_o);
use Config;

$test = Test::Cmd::Cons->new(string => 'SUFOBJ');

$test->subdir('src');

#
$test->write('Construct', <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
\@archs = qw(FOO BAR);
\$src = "#src";
\$bld = "#bld";

Link \$bld => \$src;
Export qw(arch cons);
Default (\$bld);

foreach \$arch (\@archs) {
	\$cons = \$env->clone('SUFOBJ' => ".\$arch$_o", "CFLAGS" => "-D\$arch");
	Build "\$bld/Conscript";
}
_EOF_

$test->write(['src', 'Conscript'], <<_EOF_);
Import qw(arch cons);

\@objs = Objects \$cons qw(aaa.c bbb.c main.c);

Program \$cons "program\$arch", \@objs;
_EOF_

$test->write(['src', 'aaa.c'], <<'_EOF_');
void
aaa(void)
{
#ifdef	FOO
	printf("src/aaa.c:  FOO\n");
#endif
#ifdef	BAR
	printf("src/aaa.c:  BAR\n");
#endif
}
_EOF_

$test->write(['src', 'bbb.c'], <<'_EOF_');
void
bbb(void)
{
#ifdef	FOO
	printf("src/bbb.c:  FOO\n");
#endif
#ifdef	BAR
	printf("src/bbb.c:  BAR\n");
#endif
}
_EOF_

$test->write(['src', 'main.c'], <<'_EOF_');
int
main(int argc, char *argv[])
{
	aaa();
	bbb();
#ifdef	FOO
	printf("src/main.c:  FOO\n");
#endif
#ifdef	BAR
	printf("src/main.c:  BAR\n");
#endif
	exit (0);
}
_EOF_

#
$test->run(targets => ".");

$test->execute(prog => 'bld/programFOO', stdout => <<_EOF_);
src/aaa.c:  FOO
src/bbb.c:  FOO
src/main.c:  FOO
_EOF_

$test->execute(prog => 'bld/programBAR', stdout => <<_EOF_);
src/aaa.c:  BAR
src/bbb.c:  BAR
src/main.c:  BAR
_EOF_

#
$test->pass;
__END__
