#! /usr/bin/env perl
#
#       Create a Perl module that initializes and exports a varaible.
#	Create a Construct file that uses the module, and two
#	Conscript files, one that uses the module and one that
#	doesn't.  Print the contents of the module variable (and
#	an exported variable, for a sanity check) in all three
#	files.  Check that we only see the module variable's
#	initialized value in the Construct/Conscript files that
#	use the module.
#

#
#       10 Aug 2000 Johan Holmberg  <holmberg@iar.se>
#

# $Id: t0079.t,v 1.3 2000/09/20 13:50:32 rv Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => 'use a_perl_module');

#----------------------------------------------------------------------
# This is the Perl module that will be use'd twice below.

$test->write("a_perl_module.pm", <<'_EOF_');

package a_perl_module;

require Exporter;
@ISA = qw(Exporter);

@EXPORT = qw( $a_module_variable );

$a_module_variable = 31415;

1;

_EOF_
#----------------------------------------------------------------------
# First use

$test->write("Construct", <<'_EOF_');

use a_perl_module;

print "This is Construct: $a_module_variable\n";
$an_exported_variable = 92653;
Export qw( an_exported_variable );
Build qw( Conscript1 Conscript2 );

_EOF_
#----------------------------------------------------------------------
# Second use

$test->write("Conscript1", <<'_EOF_');

use a_perl_module;

Import qw( an_exported_variable );
print "This is Conscript1: $a_module_variable, $an_exported_variable\n";

_EOF_
#----------------------------------------------------------------------
# Third use

$test->write("Conscript2", <<'_EOF_');

use English;

Import qw( an_exported_variable );

$a_module_variable ||= '';

$_ = 'abcdefghi';
/def/;

print "This is Conscript2: $a_module_variable, $an_exported_variable, $POSTMATCH\n";

_EOF_
#----------------------------------------------------------------------
# Run cons

$test->run(stdout => <<'_EOF_');
This is Construct: 31415
This is Conscript1: 31415, 92653
This is Conscript2: , 92653, ghi
_EOF_

#
$test->pass;
__END__
