#! /usr/bin/env perl
#
#	Create a Construct file that puts "." in CPPPATH and Builds a
#	Conscript file in a subdirectory, which builds a Program with the
#	same name as the subdirectory.	The Program #includes a header
#	file with the subdirectory explicitly named.  Make sure the
#	Program builds correctly and executes correctly.  (The failure
#	case we're checking for is confusion about whether the common
#	name refers to program or the subdirectory in which it resides
#	leading to a "Can't locate object method" error.)
#

# $Id: t0065.t,v 1.4 2000/09/10 05:01:27 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons;

$test = Test::Cmd::Cons->new(string => 'CPPPATH with same-named file/program');

$test->subdir('foo');

#
$foo_Conscript = $test->catfile('foo', 'Conscript');
$foo_foo = $test->catfile('foo', 'foo');

#
$test->write('Construct', <<_EOF_);
\%env_hash = ( ${\$test->cons_env} );
\$env_hash{'CPPPATH'} = ".";
\$env = new cons ( \%env_hash );
Export qw( env );
Build '$foo_Conscript';
_EOF_

$test->write($foo_Conscript, <<_EOF_);
Import qw( env );
Program \$env 'foo', 'main.c';
_EOF_

$test->write(['foo', 'main.c'], <<'_EOF_');
#include "foo/hdr.h"
main()
{
	printf("foo/main.c\n");
	exit (0);
}
_EOF_

$test->write(['foo', 'hdr.h'], <<'_EOF_');
extern int x;
_EOF_

$test->run(targets => ".");

$test->execute(prog => $foo_foo, stdout => <<_EOF_);
foo/main.c
_EOF_

#
$test->pass;
__END__
