#! /usr/bin/env perl
#
#	Define a Construct file to compile a single executable from
#	a single .c file in the	local directory, with Help text
#	defined.  Check that the help text is generated by -h.
#	Check that the Program builds successfully without -h.
#

# $Id: t0037.t,v 1.4 2000/08/03 02:20:38 knight Exp $

# Copyright (c) 1996-2000 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Test::Cmd::Cons qw($_exe);

$test = Test::Cmd::Cons->new(string => '-h, Help');

#
$foo_exe = "foo$_exe";

#
$test->write('Construct', <<_EOF_);
\$env = new cons ( ${\$test->cons_env} );
Program \$env '$foo_exe', 'foo.c';
Help qq(
This is help text.
It should appear in response to a -h flag.
);
_EOF_

$test->write('foo.c', <<'_EOF_');
int
main(int argc, char *argv[])
{
	printf("SUCCESS!\n");
	exit (0);
}
_EOF_

#

# NOTE FAILURE, != 2
$test->run(flags => "-h", targets => "", fail => '($?>>8) != 2', stdout => <<_EOF_);

This is help text.
It should appear in response to a -h flag.

_EOF_

$test->must_not_exist(foo_exe);

#
$test->run(targets => ".");

$test->execute(prog => 'foo', stdout => <<_EOF_);
SUCCESS!
_EOF_

#
$test->pass;
__END__
