// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"

Network::Network() :
Thread(NULL, keythreads.priNetwork(), keythreads.getStack()),
UDPSocket(keynetwork.getAddress(), keynetwork.getPort()),
MappedFile(getPath(), FILE_ACCESS_READWRITE)
{}

void Network::Initial(void)
{
	statnode_t node;
	int i, nodes = keyserver.getNodeCount();
	char *addr = NULL;

	time(&last);
	UDPSocket::setError(false);
	RandomFile::setError(false);
	broadcast = NULL;
	if(setBroadcast(true))
		slog(SLOG_WARNING) << "network: no broadcast access" << endl;
	else
	{
		broadcast = (struct sockaddr_in *)&bcast;
		broadcast->sin_addr = getaddress(keynetwork.getBroadcast());
		broadcast->sin_port = htons(keynetwork.getPort());
		broadcast->sin_family = AF_INET;
	}
	 	
	memset(&node, 0, sizeof(node));
	for(i = 0; i < nodes; ++i)
		::write(fd, &node, sizeof(node));

	map = (statnode_t *)MappedFile::Fetch(0, nodes * sizeof(node));
	if(!map)
		slog(SLOG_ERROR) << "network: mapping failed" << endl;
}

void Network::Run(void)
{
	int rtn;
	unsigned port;
	char *cp;
	Trunk *trunk;
	TrunkEvent event;
	time_t now;
	long diff;
	int refresh = keynetwork.getRefresh();
	statnode_t node;
	int ports = driver->getTrunkCount();
	statnode_t *list;
	char *buffer = (char *)&node;

	time(&last);
	last -= refresh - 1;
	slog(SLOG_INFO) << "network: starting" << endl;

	for(;;)
	{
		setCancel(THREAD_CANCEL_IMMEDIATE);
		time(&now);
		if(now >= last + refresh)
		{
			memset(&node, 0, sizeof(node));
			strncpy(node.name, keyserver.getNode(), sizeof(node.name));
			strncpy((char *)&node.update, "*MON", 4);
			node.ports = ports;
			driver->getStatus(node.stat);
			if(broadcast)
			{
				::sendto(so, &node, sizeof(node), 0,
					&bcast, sizeof(struct sockaddr_in));
			}		
			time(&node.update);
			memcpy(map, &node, sizeof(node));
			time(&last);
		}
		diff = last + refresh - now;
		if(diff < 0)
			continue;


		if(diff < 1)
			diff = 100;
		else
			diff = diff * 1000;

		if(!isPending(SOCKET_PENDING_INPUT, diff))
			continue;

		setCancel(THREAD_CANCEL_DEFERRED);
		memset(&node, 0, sizeof(node));
		rtn = Recv(buffer, sizeof(node));
		if(rtn < 1)	
		{		
			slog(SLOG_WARNING) << "network: input error..." << endl;
			Sleep(1000);
			continue;
		}
		switch(buffer[0])
		{
		case '*':
			time(&node.update);
			list = map;
			while(list->name[0])
			{
				if(memcmp(list->name, node.name, sizeof(node.name)))
					break;
				++list;
			}
			memcpy(list, &node, sizeof(node));
			break;
		case 'S':
		case 'F':
			port = atoi(buffer + 1);
			trunk = driver->getTrunkPort(port);
			if(!port)
				continue;
			cp = strchr(buffer, '\t');
			if(!cp)
				continue;
			memset(&event, 0, sizeof(event));
			event.id = TRUNK_SERVICE_LOOKUP;
			event.parm.lookup.seq = atoi(++cp);
			if(buffer[0] == 'S')
			{
				cp = strchr(cp, '\t');
				if(cp)
					++cp;
				event.parm.lookup.result = true;
				event.parm.lookup.data = cp;
			}
			else
				event.parm.lookup.result = false;
			if(!trunk->postEvent(&event))
			{
				trunk->getName(buffer);
				slog(SLOG_INFO) << buffer << ": database lookup late" << endl;
			}
		}
	}
}

void Network::Stop(void)
{
	slog(SLOG_DEBUG) << "network: stopping" << endl;
	Terminate();
	endSocket();
}

bool Network::Query(unsigned adapter, void *buf, size_t len)
{
	int rtn;
	InetHostAddress addr = keynetwork.getDatabase(adapter);
	tpport_t port = keynetwork.getDatabasePort(adapter);
	struct sockaddr soaddr;
	struct sockaddr_in *inaddr = (struct sockaddr_in *)&soaddr;

	if(!port)
		return false;
	
	inaddr->sin_family = AF_INET;
	inaddr->sin_addr = getaddress(addr);
	inaddr->sin_port = htons(port);	
	rtn = ::sendto(so, buf, len, 0, &soaddr, sizeof(struct sockaddr_in));
	if(rtn != len)
		return false;

	return true;
}

char *Network::getPath(void) 
{
        static char path[256];
 
        if(canModify(keypaths.getRunfiles()))
                sprintf(path, "%s/bayonne.nodes", keypaths.getRunfiles());
        else
                sprintf(path, "%s/.bayonne.nodes", getenv("HOME"));
        return path;
}

statnode_t *Network::getNode(const char *name) 
{
        statnode_t *list = map;
 
        while(list->name[0])
        {
                if(!strncmp(list->name, name, 16))
                        return list;
                ++list;
        }
        return NULL; 
}
                   
	
