// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "server.h"
#include <fx.h>

class GUITabs : public FXTabBook
{
protected:
	FXTabItem *items[4];
	// FXHorizontalFrame *frame[4];

	void mkitem(int id, FXchar *title);

public:
	GUITabs(FXComposite *frame);
};

class TabInfo : public FXVerticalFrame
{
private:
	FXLabel *data[8];

protected:
	void mkheader(FXchar *text);
	void mkfield(int id, FXchar *text);

public:
	TabInfo(FXComposite *frame);

	inline void setField(int id, FXchar *value)
		{data[id]->setText(value);};

	enum
	{
		TIMESLOTS_TOTAL = 0,
		TIMESLOTS_AVAIL,
		INCOMING_CALLS,
		OUTGOING_CALLS,
		INCOMING_TOTAL,
		OUTGOING_TOTAL,
		NODES_TOTAL,
		NODES_AVAIL
	};
};

class GUIMain : public FXMainWindow
{
private:
	FXDECLARE(GUIMain)

protected:
	GUIMain() {};

	GUITabs *tabs;

	FXMenubar *menubar;
	FXHorizontalSeparator *separator;
	FXHorizontalFrame *contents;
	FXMenuPane *filemenu, *tabmenu;

	void mkmenuitem(FXMenuPane *menu, FXchar *name, FXuint id);
	FXMenuPane *mkmenutitle(FXchar *name);

public:
	GUIMain(FXApp *a);
	virtual ~GUIMain();

	long onMenu(FXObject *, FXSelector, void *);

	enum {
		ID_COMPILE = FXMainWindow::ID_LAST,
		ID_DOWN
	};
};

class GUIApp : public FXApp, public Server, public Debug, public Keydata
{
private:
	friend class GUIDebug;
	static GUIApp *first;
	GUIApp *next;
	GUIMain *main;
	FXFont *menu, *title, *fixed, *body;

	void Initial(void);
	void Run(void);
	void Stop(void);

public:
	GUIApp();
	~GUIApp()
		{Stop();};

	inline int getPoints(void)
		{return atoi(getLast("points"));};

	inline int getHeight(void)
		{return atoi(getLast("height"));};

	inline int getWidth(void)
		{return atoi(getLast("width"));};

	inline FXchar *getTypeface(void)
		{return (FXchar *)getLast("typeface");};

	inline FXchar *getFixed(void)
		{return (FXchar *)getLast("fixed");};

	inline FXFont *getMenuFont(void)
		{return menu;};

	inline FXFont *getTitleFont(void)
		{return title;};

	inline FXFont *getFixedFont(void)
		{return fixed;};

	inline FXFont *getBodyFont(void)
		{return body;};
};

extern GUIApp gui;
