// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

bool VPBTrunk::seizeHandler(TrunkEvent *event)
{
	char script[256];
	const char *start = NULL;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "seize");
		status[id] = 's';
		flags.dsp = DSP_MODE_VOICE;
		flags.offhook = true;
		vpb_sethook_async(handle, VPB_OFFHOOK);
		setTimer(group->getDialtone());	
		return true;
	case TRUNK_CPA_DIALTONE:
		status[id] = 'o';
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_TIMER_EXPIRED:
		flags.dsp = DSP_MODE_INACTIVE;
		slog(SLOG_WARNING) << "phone" << id << ": sieze failed; ringing line" << endl;
		Detach();
		start = group->getSchedule(script);
		if(Attach(start))
		{
			handler = &VPBTrunk::stepHandler;
			return true;
		}
		handler = &VPBTrunk::hangupHandler;
		slog(SLOG_ERROR) << "phone" << id << ": " << script << ": cannot start" << endl;
		return true;
	}
	return false;
}
