// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"
#include <sys/ioctl.h>

bool PhonedevTrunk::idleHandler(TrunkEvent *event)
{
	char script[256];
	int argc = 0;
	const char *start = NULL;
	const char *data;
	const char *value;
	TrunkGroup *grp = NULL;
	char *sp;
	int ctrl;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "idle");
		setCPADetect(CPA_DIALTONE, false);
		setCPADetect(CPA_BUSYTONE, false);
		flags.dsp = DSP_MODE_INACTIVE;
		tgi.pid = 0;
		digits = 0;
		switch(flags.trunk)
		{
		case TRUNK_MODE_OUTGOING:
			group->decOutgoing();
			break;
		case TRUNK_MODE_INCOMING:
			group->decIncoming();
		}

		flags.trunk = TRUNK_MODE_INACTIVE;
		status[id] = '-';
		time(&idle);
		Purge();
		rings = 0;
		switch(driver)
		{
#ifdef	IXJ_PHONEDEV
		case ixj_driver:
			close(dev);
			strcpy(script, "/dev/");
			getName(script + 5);
			dev = open(script, O_RDWR);
			if(dev < 0)
			{
				slog(SLOG_CRITICAL) << script + 5 << ": device reset failed" << endl;
				raise(SIGINT);
			}
#ifdef	POSIX_PHONEDEV
			ctrl = PORT_PSTN;
			ioctl(dev, IXJCTL_PORT, &ctrl);
#else
			ioctl(dev, IXJCTL_PORT, PORT_PSTN);
#endif
#endif
		}
		return true;
	case TRUNK_LINE_WINK:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_MAKE_IDLE:
	case TRUNK_STOP_DISCONNECT:
		return true;
	case TRUNK_MAKE_BUSY:
		handler = &PhonedevTrunk::busyHandler;
		return true;
	case TRUNK_START_SCRIPT:
		flags.trunk = TRUNK_MODE_OUTGOING;
	case TRUNK_RING_START:
		start = event->parm.argv[0];
		if(start)
		{
			if(strchr(start, '='))
				start = group->getSchedule(script);
			else
				++argc;
		}
		if(flags.trunk == TRUNK_MODE_INACTIVE)
			flags.trunk = TRUNK_MODE_INCOMING;
		rings = 0;
		if(!start)
			start = group->getSchedule(script);
		if(Attach(start))
		{
			while(event->parm.argv[argc])
			{
				strcpy(script, event->parm.argv[argc++]);
				data = strtok_r(script, "=", &sp);
				value = strtok_r(NULL, "=", &sp);
				if(data && value)
					setConstant(data, value);
			}		
			if(flags.trunk == TRUNK_MODE_OUTGOING)
			{
				handler = &PhonedevTrunk::seizeHandler;
				group->incOutgoing();
			}
			else
			{
				handler = &PhonedevTrunk::stepHandler;
				group->incIncoming();
			}
			return true;
		}
		flags.trunk = TRUNK_MODE_INACTIVE;
		slog(SLOG_ERROR) << "phone" << id << ": " << start << ": cannot start" << endl;
		return true;		
	case TRUNK_RINGING_ON:
		rings = 1;
		flags.trunk = TRUNK_MODE_INCOMING;
		group->incIncoming();
		handler = &PhonedevTrunk::ringHandler;
		return true;
	}
	return false;
}
