%define _release 3
%define _version 0.5.3
%define _dsopath %{_prefix}/lib/bayonne/%{_version}

Summary: bayonne - the telephony server of the GNU project
Name: bayonne
Version: %{_version}
Release: %{_release}
Group: Communications
Source: ftp://www.voxilla.org/pub/bayonne/bayonne-%{PACKAGE_VERSION}.tar.gz
Prefix: %{_prefix}
Vendor: Open Source Telecom
Copyright: GPL
BuildRoot: %{_tmppath}/bayonne-root
Packager: David Sugar <dyfet@ostel.com>
url: http://www.bayonne.cx
BuildRequires: ccscript >= 1.1.0 ccaudio

%description
Bayonne offers a script programmable modular server for deploying
multi-line telephony voice response and computer telephony applications.

%package UsEngM
Summary: bayonne-UsEngM - voice library for US English Male speaker
Group: Communications
Requires: bayonne

%package FrenchM
Summary: bayonne-FrenchM - international voice library for French
Group: Communications
Requires: bayonne

%package drivers
Summary: bayonne telephony device drivers
Group: Communications
Requires: bayonne

%description drivers
The actual set of device drivers that may be built from Bayonne depends
on which telephony API's are found on the build host by "configure".  Some
Bayonne driver dso's are always built for all GNU/Linux systems, such as
phonedev or dummy.  Others, like the Pika driver, require the MonteCarlo
API.  Unfortunately there is no support in RPM packages for conditionally
building a subpackage based on the presense or absence of a dependent
library.  Hence, the drivers package will contain those drivers that were
buildable on the build host rather than those that might be supported on
the end user's target system.  Ideally the build host that was used to
prepare this package in binary form should contain all possible telephony
api packages that Bayonne will support.

%description UsEngM
The US English "male" speaker library offers default voice prompts
for the Bayonne telephony server.

%description FrenchM
The French international "male" speaker library offers default French 
language voice prompts for the Bayonne telephony server.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

# NOTE: in Common C++, compiler options are retreived from config.def
# and should not be overriden here!

./configure --prefix=%{_prefix}

%build
uname -a|grep SMP && make -j 2 || make

%install
mkdir -p $RPM_BUILD_ROOT/var/bayonne
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/%{_prefix}/bin
make prefix=$RPM_BUILD_ROOT/%{_prefix} etc_prefix=$RPM_BUILD_ROOT/etc \
	mandir=$RPM_BUILD_ROOT/%{_mandir} etc_suffix="" install

%files
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README TODO DRIVERS.TXT PROMPTS.TXT SCRIPT.TXT ChangeLog BAYONNE.FAQ
%config %attr(0600,root,root) /etc/bayonne.conf
%config %attr(0600,root,root) /etc/bayonne.sched
%dir %{_prefix}/share/aaprompts
%dir %{_dsopath}
/etc/rc.d/init.d/bayonne
%{_mandir}/man8/bayonne.8*
%{_prefix}/libexec/tgi
%{_dsopath}/*.aud
%{_dsopath}/*.fun
%{_dsopath}/*.dbg
%{_dsopath}/*.tts
%{_dsopath}/*.mod
%{_prefix}/include/cc++/bayonne.h
%{_prefix}/share/aascripts
%{_prefix}/sbin/bayonne
%{_prefix}/bin/baxs
/var/bayonne

%files drivers
%defattr(-,root,root)
%{_dsopath}/*.ivr

%files UsEngM
%defattr(-,root,root)
%{_prefix}/share/aaprompts/UsEngM

%files FrenchM
%defattr(-,root,root)
%{_prefix}/share/aaprompts/FrenchM

%clean
rm -rf $RPM_BUILD_ROOT

%post
#/sbin/chkconfig --add bayonne

%preun
/sbin/chkconfig --del bayonne

%changelog
* Tue Jul 25 2000 David Sugar <dyfet@ostel.com> 0.4-3
- added changes suggested by Lenny Cartier <lenny@mandrakesoft.com>.
- made into a relocatable package.
