// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

int VPBThread::count = 0;

VPBThread::VPBThread() :
Thread(NULL, keythreads.priService(), vpbivr.getStack()), Mutex()
{
	id = ++count;
	active = false;
	memset(&handles, 0, sizeof(handles));
}

VPBThread::~VPBThread()
{
	if(!active)
		return;

	active = false;
	Terminate();
}

void	VPBThread::Run(void)
{
	VPB_EVENT vpbevt;
	TrunkEvent event;
	VPBTrunk *trunk;
	int port;

	slog(SLOG_INFO) << "evt(" << id << ") running..." << endl;

	active = true;

	while(active)
	{
		setCancel(THREAD_CANCEL_DISABLED);
		if(vpb_get_event_async(id, &vpbevt) == VPB_NO_EVENTS)
		{
			setCancel(THREAD_CANCEL_IMMEDIATE);
			for(port = 0; port < 4; ++port)
			{
				if(!handles[port])
					continue;

				if(!handles[port]->getTimer())
				{
					event.id = handles[port]->notify;
					handles[port]->endTimer();
					handles[port]->postEvent(&event);
				}
			}	
			continue;		
		}

		for(port = 0; port < 4; ++port)
		{
			if(!handles[port])
				continue;
	
			if(handles[port]->handle = vpbevt.handle)
				break;
		}

		if(port >= 4)
			continue;

		trunk = handles[port];
		if(!trunk)
			continue;

		memset(&event, 0, sizeof(event));
		switch(vpbevt.type)
		{
		case VPB_RING:
			event.id = TRUNK_RINGING_OFF;
			break;
		case VPB_DTMF:
			event.id = TRUNK_DTMF_KEYUP;
			event.parm.dtmf.digit = trunk->getDigit(vpbevt.data);
			event.parm.dtmf.duration = 40;
			break;
		case VPB_TIMEREXP:
			event.id = TRUNK_TIMER_EXPIRED;
			break;
		case VPB_VOXON:
			event.id = TRUNK_AUDIO_START;
			break;
		case VPB_VOXOFF:
			event.id = TRUNK_AUDIO_STOP;
			break;
		case VPB_PLAYEND:
		case VPB_RECORDEND:
			event.id = TRUNK_AUDIO_IDLE;
			break;
		case VPB_DIALEND:
			event.id = TRUNK_TONE_IDLE;
			break;
		case VPB_CALLEND:
			event.id = TRUNK_LINE_WINK;
			break;
		case VPB_TONEDETECT:
			switch(vpbevt.data)
			{
			case VPB_DIAL:
				event.id = TRUNK_CPA_DIALTONE;
				break;
			case VPB_RINGBACK:
				event.id = TRUNK_CPA_RINGING;
				break;
			case VPB_BUSY:
				event.id = TRUNK_CPA_BUSYTONE;
				break;
			}
			break;
		}
		if(event.id)
			trunk->postEvent(&event);
	}
	setCancel(THREAD_CANCEL_IMMEDIATE);
	Sleep(50);
}

