// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

bool PhonedevTrunk::hangupHandler(TrunkEvent *event)
{
	timeout_t reset;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "hangup");
		status[id] = 'h';
		endTimer();
		if(tgi.pid)
			kill(tgi.pid, SIGHUP);
		if(thread)
			reset = thread->Stop();
		else
			reset = 0;
		setDTMFDetect(false);
		setCPADetect(CPA_DIALTONE, false);
		setCPADetect(CPA_BUSYTONE, false);
		flags.dsp = DSP_MODE_INACTIVE;
		setHookState(false);
		Detach();
		if(group->getHangup() > reset)
			setTimer(group->getHangup());
		else
			setTimer(reset);
		return true;
	case TRUNK_TIMER_EXPIRED:
		stopServices();
		flags.reset = false;
		handler = &PhonedevTrunk::idleHandler;
		return true;
	case TRUNK_MAKE_IDLE:
		return true;
	case TRUNK_RINGING_ON:
		endTimer();
		flags.reset = false;
		handler = &PhonedevTrunk::idleHandler;
		return idleHandler(event);
	}
	return false;
}
