// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

bool PhonedevTrunk::collectHandler(TrunkEvent *event)
{
	timeout_t wakeup;
	unsigned short mask;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		debug->DebugState(this, "collect");
		if(digits >= data.collect.count)
		{
			TrunkSignal(TRUNK_SIGNAL_STEP);
			handler = &PhonedevTrunk::stepHandler;
			return true;
		}
		flags.dsp = DSP_MODE_VOICE;
		setDTMFDetect(true);
		setTimer(data.collect.timeout);
		return true;
	case TRUNK_TIMER_EXPIRED:
		TrunkSignal(TRUNK_SIGNAL_TIMEOUT);
		handler = &PhonedevTrunk::stepHandler;
		return true;
	case TRUNK_DTMF_KEYUP:
		endTimer();
		mask = (1 << event->parm.dtmf.digit);
		if(mask & data.collect.ignore)
		{
			setTimer(data.collect.timeout);
			return true;
		}
		if(!(mask & data.collect.term))
		{
			dtmf.bin.data[digits++] = digit[event->parm.dtmf.digit];
			dtmf.bin.data[digits] = 0;
		}				
		if(digits >= data.collect.count || (mask & data.collect.term))
		{
			TrunkSignal(TRUNK_SIGNAL_STEP);
			handler = &PhonedevTrunk::stepHandler;
		}
		return true;
	}
	return false;
}
